//
// This is meant to be a container of js functions of general purpose utility.
//
// It is included in theme.html so we can use them anywhere.
//

// Encodes all arguments, concatenates them with slashes and prepends the base url if it is set
// if the last argument is a dictionary, it is used to create a query string
function encodedURLFromComponents() {
	var url = BASE_URL;
	
	// defend against evil extra slashes that give mod_python so much trouble
	if ((/\/$/).test(url))
		url = url.slice(0,-1);
	
	for (var i = 0; i < arguments.length; i++)
		if (shouldEncodeParameterAsQueryString(i, arguments))
			url += encodedQueryParametersFromDict(arguments[i]);
		else
			url += '/' + encodeURIComponent(arguments[i]);
	
	return url;
	
	function shouldEncodeParameterAsQueryString(index, arguments) {
		var isLastArgument = index === arguments.length - 1;
		var isNotString = 'object' === typeof(arguments[index]);
		return isLastArgument && isNotString;
	}
}

function encodedQueryParametersFromDict(aDictionary) {
	var queryComponents = [];
	for (var key in aDictionary)
		queryComponents.push(encodeURIComponent(key) + '=' + encodeURIComponent(aDictionary[key]));
	
	if (0 === queryComponents.length)
		return '';
	
	return '?' + queryComponents.join('&');
}