jQuery(document).ready(function($) {
  var usernames = [];
  var elements = $('.report').find("td.owner, td.reporter, td.担当者, td.報告者");
  var uniq_username = {};
  var data = {username: [], __FORM_TOKEN: form_token};
  elements.each(function() {
    var text = $.trim($(this).text());
    usernames.push(text);
    if (!text || text == 'anonymous' || text == 'somebody' || text == 'trac' || text == '')
      return;
    if (!(text in uniq_username)) {
      uniq_username[text] = true;
      data.username.push(text);
    }
  });

  if (data.username.length == 0)
    return;

  $.ajax({
    url: avatar_request_path,
    data: data,
    traditional: true,
    dataType: 'json',
    type: 'POST',
    success: function(json) {
      var images = {};
      $.each(json, function(username, href) {
        var image = new Image();
        image.className = 'avatar';
        image.src = href;
        images[username] = image;
      });
      var curr = 0;
      var length = elements.length;
      function step() {
        var n = Math.min(length - curr, 25);
        for (var i = 0; i < n; i++) {
          var index = curr + i;
          var username = usernames[index];
          if (username in images)
            $(elements[index]).prepend(images[username].cloneNode(false));
        };
        curr += n;
        if (curr < length)
          setTimeout(step, 50);
      }
      step();
    }
  });
});