/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import java.lang.reflect.Method;
import net.java.ao.Accessor;
import net.java.ao.Common;
import net.java.ao.ManyToMany;
import net.java.ao.Mutator;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.RawEntity;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.PrimaryKey;

public abstract class AbstractFieldNameConverter
implements FieldNameConverter {
    protected AbstractFieldNameConverter() {
    }

    public String getName(Method method) {
        return this.getNameImpl(method, false);
    }

    public String getPolyTypeName(Method method) {
        return this.getNameImpl(method, true);
    }

    private String getNameImpl(Method method, boolean polyType) {
        if (method == null) {
            throw new IllegalArgumentException("Problem in ActiveObjects core, looking for field name for null method");
        }
        String attributeName = null;
        Class<?> type = Common.getAttributeTypeFromMethod(method);
        Mutator mutatorAnnotation = method.getAnnotation(Mutator.class);
        Accessor accessorAnnotation = method.getAnnotation(Accessor.class);
        PrimaryKey primaryKeyAnnotation = method.getAnnotation(PrimaryKey.class);
        OneToOne oneToOneAnnotation = method.getAnnotation(OneToOne.class);
        OneToMany oneToManyAnnotation = method.getAnnotation(OneToMany.class);
        ManyToMany manyToManyAnnotation = method.getAnnotation(ManyToMany.class);
        if (mutatorAnnotation != null) {
            attributeName = mutatorAnnotation.value();
            if (!polyType) {
                return attributeName;
            }
        } else if (accessorAnnotation != null) {
            attributeName = accessorAnnotation.value();
            if (!polyType) {
                return attributeName;
            }
        } else if (primaryKeyAnnotation != null && !primaryKeyAnnotation.value().trim().equals("")) {
            attributeName = primaryKeyAnnotation.value();
            if (!polyType) {
                return attributeName;
            }
        } else {
            if (oneToOneAnnotation != null) {
                return null;
            }
            if (oneToManyAnnotation != null) {
                return null;
            }
            if (manyToManyAnnotation != null) {
                return null;
            }
            if (method.getName().startsWith("get") || method.getName().startsWith("set")) {
                attributeName = method.getName().substring(3);
            } else if (method.getName().startsWith("is")) {
                attributeName = method.getName().substring(2);
            } else {
                return null;
            }
        }
        return this.convertName(attributeName, Common.interfaceInheritsFrom(type, RawEntity.class), polyType);
    }

    protected abstract String convertName(String var1, boolean var2, boolean var3);
}

