/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdbcacsess2.main.FontZoom;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.JmyTable;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.main.TableColumnFit;
import jdbcacsess2.main.icon.IconImage;
import jdbcacsess2.sqlService.ColumnAttributeResult;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.DataBaseConnectionListener;
import jdbcacsess2.sqlService.DataBaseTransactionListener;
import jdbcacsess2.sqlService.PropertyResultSetTableModel;
import jdbcacsess2.sqlService.ResultsTableModel;
import jdbcacsess2.sqlService.SqlExecuteTask;
import jdbcacsess2.sqlService.SqlExecutedListener;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class JPanelSql
extends JPanel
implements SqlExecutedListener,
DataBaseConnectionListener,
DataBaseTransactionListener {
    private static final int TABBEDPANEL_INDEX_DATA = 0;
    private static final int TABBEDPANEL_INDEX_LOG = 1;
    private static final int TABBEDPANEL_INDEX_RS = 2;
    private DataBaseConnection dataBaseConnection;
    private SqlExecuteTask sqlExecuteTask;
    private TableColumnFit resultsTableColumnFit;
    private SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentenceLast;
    private boolean exceptionContinue;
    private static final long serialVersionUID = 1L;
    private JSplitPane jSplitPaneTable = null;
    private RTextScrollPane rTextScrollPaneSql = null;
    private RSyntaxTextArea rSyntaxTextAreaSql = null;
    private JTabbedPane jTabbedPaneResult = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JScrollPane jScrollPaneLog = null;
    private JTextArea jTextAreaLog = null;
    private JToolBar jJToolBarBar = null;
    private JButton jButtonContinue = null;
    private JCheckBox jCheckBoxAutoCommit = null;
    private JButton jButtonCommit = null;
    private JButton jButtonRollback = null;
    private JToggleButton jToggleButtonExecution = null;
    private JToggleButton jToggleButtonConnection = null;
    private JScrollPane jScrollPane1 = null;
    private JTable jTableResultSet = null;
    private JComboBox<SentenceSeparator> jComboBoxSentenceSeparator = null;

    @Override
    public void dataBaseConnectionOpened(DataBaseConnection dataBaseConnection) {
        this.dataBaseConnection = dataBaseConnection;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.writeGuiLog("connection opened");
                boolean flg = JPanelSql.this.getJCheckBoxAutoCommit().isSelected();
                try {
                    JPanelSql.this.getDataBaseConnection().setAutoCommit(flg);
                    JPanelSql.this.getJToggleButtonExecution().setEnabled(true);
                    JPanelSql.this.getJButtonContinue().setEnabled(false);
                    JPanelSql.this.getJCheckBoxAutoCommit().setEnabled(true);
                    JPanelSql.this.getJToggleButtonConnection().setSelected(true);
                }
                catch (Exception e) {
                    ShowDialog.errorMessage(e);
                }
            }
        });
    }

    @Override
    public void dataBaseConnectionClosing(DataBaseConnection dataBaseConnection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(false);
                JPanelSql.this.getJButtonContinue().setEnabled(false);
                JPanelSql.this.getJCheckBoxAutoCommit().setEnabled(false);
                JPanelSql.this.getJButtonCommit().setEnabled(false);
                JPanelSql.this.getJButtonRollback().setEnabled(false);
                JPanelSql.this.getJToggleButtonConnection().setSelected(false);
            }
        });
    }

    @Override
    public void dataBaseConnectionClosed(DataBaseConnection dataBaseConnection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.writeGuiLog("connection closed");
            }
        });
    }

    DataBaseConnection getDataBaseConnection() {
        return this.dataBaseConnection;
    }

    @Override
    public void autoCommitChange(DataBaseConnection dataBaseConnection, final boolean autoCommit) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.writeGuiLog("autocommit[" + autoCommit + "]");
            }
        });
    }

    @Override
    public void commitEnd(DataBaseConnection dataBaseConnection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJTabbedPaneResult().setSelectedIndex(1);
                JPanelSql.this.writeGuiLog("commit end");
            }
        });
    }

    @Override
    public void rollbackEnd(DataBaseConnection dataBaseConnection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJTabbedPaneResult().setSelectedIndex(1);
                JPanelSql.this.writeGuiLog("rollback end");
            }
        });
    }

    private void writeGuiLog(String message) {
        int i = message.length();
        while (i > 0) {
            String s = message.substring(i - 1, i);
            if (!s.equals("\n")) break;
            --i;
        }
        this.getJTextAreaLog().append(message.substring(0, i));
        this.getJTextAreaLog().append("\n");
        this.getJTextAreaLog().setCaretPosition(this.getJTextAreaLog().getText().length());
    }

    public void insertStringPreviousCaret(String str) {
        if (str.equals("")) {
            return;
        }
        this.rSyntaxTextAreaSql.replaceRange(this.addIndent(str), this.rSyntaxTextAreaSql.getSelectionStart(), this.rSyntaxTextAreaSql.getSelectionEnd());
        this.rSyntaxTextAreaSql.requestFocus();
    }

    private String addIndent(String editor) {
        int x = this.rSyntaxTextAreaSql.getCaretPosition() - this.rSyntaxTextAreaSql.getLineStartOffsetOfCurrentLine();
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < x) {
            indent.append(' ');
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        while (i2 < editor.length()) {
            char c = editor.charAt(i2);
            buf.append(c);
            if (c == '\n') {
                buf.append((CharSequence)indent);
            }
            ++i2;
        }
        return buf.toString();
    }

    public void taskWakuUp() {
        this.sqlExecuteTask.taskWakeUp();
    }

    public void taskCancel() {
        this.sqlExecuteTask.taskCancel();
    }

    @Override
    public void taskAccept(SqlExecuteTask sqlExecuteTask) {
        this.sqlExecuteTask = sqlExecuteTask;
        this.exceptionContinue = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(false);
                JPanelSql.this.getJToggleButtonExecution().setSelected(true);
                JPanelSql.this.getJButtonContinue().setEnabled(false);
                JPanelSql.this.getJToggleButtonConnection().setEnabled(false);
            }
        });
    }

    @Override
    public void executBegin(final SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentence) {
        this.sqlExecuteSentenceLast = sqlExecuteSentence;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sqlExecuteSentence.getSqlCommand().toUpperCase().equals("SELECT")) {
                    JPanelSql.this.resultsTableColumnFit.setEnableAutoFit(true);
                    JPanelSql.this.getJTabbedPaneResult().setSelectedIndex(0);
                } else {
                    JPanelSql.this.getJTabbedPaneResult().setSelectedIndex(1);
                }
                JPanelSql.this.writeGuiLog("\nstart sql\n" + sqlExecuteSentence.getSqlSentence());
            }
        });
    }

    @Override
    public void executNormalFinish(final int rowCnt) {
        final String counrMessage = this.countmsg();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(true);
                JPanelSql.this.writeGuiLog("normal end sql" + counrMessage + " " + Integer.toString(rowCnt) + " row " + JPanelSql.this.sqlExecuteTask.getExecutionTime() + "ms");
            }
        });
    }

    @Override
    public void executeException(final Throwable t) {
        final String counrMessage = this.countmsg();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(true);
                JPanelSql.this.writeGuiLog("abnormal end " + counrMessage + "\n " + t.getLocalizedMessage());
            }
        });
        ShowDialog.errorMessage(t);
        int zan = this.sqlExecuteTask.getCnt() - this.sqlExecuteSentenceLast.getSentenceCount();
        if (!this.exceptionContinue && zan > 0) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Object[] options = new Object[]{"\u306f\u3044\u3001\u5f8c\u7d9a\u306eSQL\u5b9f\u884c\u3092\u4e2d\u65ad", "\u3044\u3044\u3048\u3001\u4ee5\u964d\u306e\u5168\u30a8\u30e9\u30fc\u3092\u7121\u8996"};
                        int n = JOptionPane.showOptionDialog(null, "\u6b8b\u308a\u306eSQL\u5b9f\u884c\u306f\u4e2d\u65ad\u3057\u307e\u3059\u304b\uff1f", "\u307e\u3060\u5b9f\u884c\u4e88\u5b9a\u306eSQL\u304c\u6b8b\u3063\u3066\u307e\u3059", 0, 3, null, options, options[0]);
                        if (n == 1) {
                            JPanelSql.this.exceptionContinue = true;
                        } else {
                            JPanelSql.this.taskCancel();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ShowDialog.errorMessage(e);
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private String countmsg() {
        return "[" + this.sqlExecuteSentenceLast.getSentenceCount() + "/" + this.sqlExecuteTask.getCnt() + "]";
    }

    @Override
    public void resultHeader(List<ColumnAttributeResult> header) {
        final PropertyResultSetTableModel dataModel = new PropertyResultSetTableModel(header);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJTableResultSet().setModel(dataModel);
            }
        });
    }

    @Override
    public void resultDetail(int seq, List<Object> detail) {
    }

    @Override
    public void statusContinue(final int seqNo) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(true);
                JPanelSql.this.getJButtonContinue().setEnabled(true);
                JPanelSql.this.getJToggleButtonConnection().setEnabled(false);
                JPanelSql.this.writeGuiLog("data cotinue  now " + Integer.toString(seqNo) + " row");
            }
        });
    }

    @Override
    public void executeAllEnd() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSql.this.getJToggleButtonExecution().setEnabled(true);
                JPanelSql.this.getJToggleButtonExecution().setSelected(false);
                JPanelSql.this.getJButtonContinue().setEnabled(false);
                JPanelSql.this.getJToggleButtonConnection().setEnabled(true);
            }
        });
    }

    public JPanelSql() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPaneTable(), "Center");
        this.add((Component)this.getJJToolBarBar(), "North");
    }

    JSplitPane getJSplitPaneTable() {
        if (this.jSplitPaneTable == null) {
            this.jSplitPaneTable = new JSplitPane();
            this.jSplitPaneTable.setOrientation(0);
            this.jSplitPaneTable.setDividerLocation(200);
            this.jSplitPaneTable.setDividerSize(10);
            this.jSplitPaneTable.setOneTouchExpandable(true);
            this.jSplitPaneTable.setTopComponent((Component)this.getRTextScrollPaneSql());
            this.jSplitPaneTable.setBottomComponent(this.getJTabbedPaneResult());
        }
        return this.jSplitPaneTable;
    }

    private RTextScrollPane getRTextScrollPaneSql() {
        if (this.rTextScrollPaneSql == null) {
            this.rTextScrollPaneSql = new RTextScrollPane();
            this.rTextScrollPaneSql.setViewportView((Component)this.getRSyntaxTextAreaSql());
        }
        return this.rTextScrollPaneSql;
    }

    RSyntaxTextArea getRSyntaxTextAreaSql() {
        if (this.rSyntaxTextAreaSql == null) {
            this.rSyntaxTextAreaSql = new RSyntaxTextArea();
            this.rSyntaxTextAreaSql.setSyntaxEditingStyle("text/sql");
            this.rSyntaxTextAreaSql.setAntiAliasingEnabled(true);
            FontZoom.setMouseWheel((Component)this.rSyntaxTextAreaSql);
        }
        return this.rSyntaxTextAreaSql;
    }

    JTabbedPane getJTabbedPaneResult() {
        if (this.jTabbedPaneResult == null) {
            this.jTabbedPaneResult = new JTabbedPane();
            this.jTabbedPaneResult.setTabPlacement(2);
            this.jTabbedPaneResult.add(this.getJScrollPane(), "data", 0);
            this.jTabbedPaneResult.add(this.getJScrollPaneLog(), "log", 1);
            this.jTabbedPaneResult.add(this.getJScrollPane1(), "RS", 2);
        }
        return this.jTabbedPaneResult;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setIntercellSpacing(new Dimension(3, 2));
            this.jTable.setAutoCreateRowSorter(true);
            this.jTable.setCellSelectionEnabled(true);
            this.jTable.setSelectionMode(2);
            Font font = this.jTable.getFont();
            this.jTable.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
            FontZoom.setMouseWheel(this.jTable);
            this.resultsTableColumnFit = new TableColumnFit(this.jTable);
            this.jTable.setModel(new ResultsTableModel());
        }
        return this.jTable;
    }

    private JToolBar getJJToolBarBar() {
        if (this.jJToolBarBar == null) {
            this.jJToolBarBar = new JToolBar();
            this.jJToolBarBar.add(this.getJToggleButtonExecution());
            this.jJToolBarBar.add(this.getJButtonContinue());
            this.jJToolBarBar.add(this.getJCheckBoxAutoCommit());
            this.jJToolBarBar.add(this.getJButtonCommit());
            this.jJToolBarBar.add(this.getJButtonRollback());
            this.jJToolBarBar.add(this.getJToggleButtonConnection());
            this.jJToolBarBar.add(this.getJComboBoxSentenceSeparator());
        }
        return this.jJToolBarBar;
    }

    JToggleButton getJToggleButtonExecution() {
        if (this.jToggleButtonExecution == null) {
            this.jToggleButtonExecution = new JToggleButton(IconImage.EXECUTE.getValue(), false);
            this.jToggleButtonExecution.setText("Execute");
            this.jToggleButtonExecution.setEnabled(false);
            this.jToggleButtonExecution.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JToggleButton b = (JToggleButton)e.getSource();
                    if (b.isSelected()) {
                        b.setIcon(IconImage.STOP.getValue());
                    } else {
                        b.setIcon(IconImage.EXECUTE.getValue());
                    }
                }
            });
        }
        return this.jToggleButtonExecution;
    }

    JButton getJButtonContinue() {
        if (this.jButtonContinue == null) {
            this.jButtonContinue = new JButton(IconImage.GO_DOWN.getValue());
            this.jButtonContinue.setEnabled(false);
            this.jButtonContinue.setText("Continue");
        }
        return this.jButtonContinue;
    }

    JCheckBox getJCheckBoxAutoCommit() {
        if (this.jCheckBoxAutoCommit == null) {
            this.jCheckBoxAutoCommit = new JCheckBox();
            this.jCheckBoxAutoCommit.setText("AutoCommit");
            this.jCheckBoxAutoCommit.setEnabled(false);
            this.jCheckBoxAutoCommit.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean flg = JPanelSql.this.jCheckBoxAutoCommit.isSelected();
                    JPanelSql.this.getJButtonCommit().setEnabled(!flg);
                    JPanelSql.this.getJButtonRollback().setEnabled(!flg);
                    Jdbcacsess2.logger.fine("autocomit:" + flg);
                    if (JPanelSql.this.getDataBaseConnection() == null) {
                        return;
                    }
                    try {
                        JPanelSql.this.getDataBaseConnection().setAutoCommit(flg);
                    }
                    catch (Exception ex) {
                        ShowDialog.errorMessage(ex);
                    }
                }
            });
            this.jCheckBoxAutoCommit.setSelected(true);
        }
        return this.jCheckBoxAutoCommit;
    }

    JButton getJButtonCommit() {
        if (this.jButtonCommit == null) {
            this.jButtonCommit = new JButton(IconImage.COMMIT.getValue());
            this.jButtonCommit.setText("Commit");
            this.jButtonCommit.setEnabled(false);
        }
        return this.jButtonCommit;
    }

    JButton getJButtonRollback() {
        if (this.jButtonRollback == null) {
            this.jButtonRollback = new JButton(IconImage.ROLLBACK.getValue());
            this.jButtonRollback.setText("Rollback");
            this.jButtonRollback.setEnabled(false);
        }
        return this.jButtonRollback;
    }

    private JScrollPane getJScrollPaneLog() {
        if (this.jScrollPaneLog == null) {
            this.jScrollPaneLog = new JScrollPane();
            this.jScrollPaneLog.setViewportView(this.getJTextAreaLog());
        }
        return this.jScrollPaneLog;
    }

    JTextArea getJTextAreaLog() {
        if (this.jTextAreaLog == null) {
            this.jTextAreaLog = new JTextArea();
            this.jTextAreaLog.setEditable(false);
            this.jTextAreaLog.setLineWrap(false);
            this.jTextAreaLog.setOpaque(false);
        }
        return this.jTextAreaLog;
    }

    JToggleButton getJToggleButtonConnection() {
        if (this.jToggleButtonConnection == null) {
            this.jToggleButtonConnection = new JToggleButton(IconImage.DISCONNECT.getValue());
            this.jToggleButtonConnection.setText("session");
            this.jToggleButtonConnection.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JToggleButton b = (JToggleButton)e.getSource();
                    if (b.isSelected()) {
                        b.setIcon(IconImage.CONNECT.getValue());
                    } else {
                        b.setIcon(IconImage.DISCONNECT.getValue());
                    }
                }
            });
        }
        return this.jToggleButtonConnection;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTableResultSet());
        }
        return this.jScrollPane1;
    }

    private JTable getJTableResultSet() {
        if (this.jTableResultSet == null) {
            this.jTableResultSet = new JmyTable();
        }
        return this.jTableResultSet;
    }

    JComboBox<SentenceSeparator> getJComboBoxSentenceSeparator() {
        if (this.jComboBoxSentenceSeparator == null) {
            this.jComboBoxSentenceSeparator = new JComboBox();
            this.jComboBoxSentenceSeparator.setEditable(true);
            this.jComboBoxSentenceSeparator.addItem(new SentenceSeparator(";", ";\\s*\\n?"));
            this.jComboBoxSentenceSeparator.addItem(new SentenceSeparator("/", "\\n+\\s*/\\s*\\n?"));
            this.jComboBoxSentenceSeparator.addItem(new SentenceSeparator("//", "\\n+?\\s*//\\s*\\n?"));
            this.jComboBoxSentenceSeparator.addItem(new SentenceSeparator("GO", "\\n+\\s*[Gg][Oo]\\s*\\n?"));
        }
        return this.jComboBoxSentenceSeparator;
    }

    public static class SentenceSeparator {
        private final String guiVal;
        private final String regVal;

        SentenceSeparator(String guiVal, String regVal) {
            this.guiVal = guiVal;
            this.regVal = regVal;
        }

        public String toString() {
            return this.guiVal;
        }

        public String getRegVal() {
            return this.regVal;
        }
    }
}

