/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class JTableShortcut {
    private static final Action actionRowFirstJump = new JTableCursorJump(){
        private static final long serialVersionUID = -2158918605198692637L;

        @Override
        int getColumnJumpIndex(int ColumnIndex, int columnCount) {
            return 0;
        }

        @Override
        int getRowJumpIndex(int rowIndex, int rowCount) {
            return rowIndex;
        }
    };
    private static final Action actionRowEndJump = new JTableCursorJump(){
        private static final long serialVersionUID = 7159547464095054706L;

        @Override
        int getColumnJumpIndex(int ColumnIndex, int columnCount) {
            return columnCount - 1;
        }

        @Override
        int getRowJumpIndex(int rowIndex, int rowCount) {
            return rowIndex;
        }
    };
    private static final Action actionColumnFirstJump = new JTableCursorJump(){
        private static final long serialVersionUID = 3289572832545730204L;

        @Override
        int getColumnJumpIndex(int ColumnIndex, int columnCount) {
            return ColumnIndex;
        }

        @Override
        int getRowJumpIndex(int rowIndex, int rowCount) {
            return 0;
        }
    };
    private static final Action actionColumnEndJump = new JTableCursorJump(){
        private static final long serialVersionUID = 2404431616648661021L;

        @Override
        int getColumnJumpIndex(int ColumnIndex, int columnCount) {
            return ColumnIndex;
        }

        @Override
        int getRowJumpIndex(int rowIndex, int rowCount) {
            return rowCount - 1;
        }
    };
    private static final Action actionRowSelectExpand = new AbstractAction(){
        private static final long serialVersionUID = 8769124792157544519L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JTable) {
                JTable jTable = (JTable)e.getSource();
                int rowIndex = jTable.getSelectedRow();
                int columnIndex = jTable.getSelectedColumn();
                jTable.addRowSelectionInterval(0, jTable.getRowCount() - 1);
                jTable.changeSelection(rowIndex, columnIndex, true, true);
            }
        }
    };
    private static final Action actionColumnSelectexpand = new AbstractAction(){
        private static final long serialVersionUID = 7534881048814827865L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JTable) {
                JTable jTable = (JTable)e.getSource();
                int rowIndex = jTable.getSelectedRow();
                int columnIndex = jTable.getSelectedColumn();
                jTable.addColumnSelectionInterval(0, jTable.getColumnCount() - 1);
                jTable.changeSelection(rowIndex, columnIndex, true, true);
            }
        }
    };

    public static void setJTableShortcut(JTable jtable) {
        JTableShortcut.setShortCut(jtable, 38, 128, "columnFirst", actionColumnFirstJump);
        JTableShortcut.setShortCut(jtable, 40, 128, "columnEnd", actionColumnEndJump);
        JTableShortcut.setShortCut(jtable, 37, 128, "rowFirst", actionRowFirstJump);
        JTableShortcut.setShortCut(jtable, 39, 128, "rowEnd", actionRowEndJump);
        JTableShortcut.setShortCut(jtable, 32, 128, "rowexpand", actionRowSelectExpand);
        JTableShortcut.setShortCut(jtable, 32, 64, "colexpand", actionColumnSelectexpand);
    }

    private static void setShortCut(JComponent jComponent, int keyCode, int modifiers, String key, Action action) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        inputMap.put(keyStroke, key);
        actionMap.put(key, action);
    }

    private static abstract class JTableCursorJump
    extends AbstractAction {
        private static final long serialVersionUID = -8725551506660304024L;

        private JTableCursorJump() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JTable) {
                int columnIndex;
                int rowIndex;
                JTable jTable = (JTable)e.getSource();
                Rectangle cellRect = jTable.getCellRect(rowIndex = this.getRowJumpIndex(jTable.getSelectedRow(), jTable.getRowCount()), columnIndex = this.getColumnJumpIndex(jTable.getSelectedColumn(), jTable.getColumnCount()), false);
                if (cellRect != null) {
                    jTable.scrollRectToVisible(cellRect);
                }
                jTable.changeSelection(rowIndex, columnIndex, false, false);
            }
        }

        abstract int getRowJumpIndex(int var1, int var2);

        abstract int getColumnJumpIndex(int var1, int var2);
    }
}

