/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jdbcacsess2.sqlService.ColumnAttributeResult;

public class PropertyResultSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7827100875320667597L;
    private final List<List<String>> col = new ArrayList<List<String>>();
    private final List<ColumnAttributeResult> header;

    public PropertyResultSetTableModel(List<ColumnAttributeResult> header) {
        this.header = header;
        ArrayList<String> s = new ArrayList<String>();
        s.add("ColumnName");
        s.add("ColumnLabel");
        s.add("ColumnType");
        s.add("ColumnTypeName");
        s.add("ColumnClassName");
        s.add("ColumnDisplaySize");
        s.add("Precision");
        s.add("Scale");
        s.add("CatalogName");
        s.add("SchemaName");
        s.add("TableName");
        s.add("AutoIncrement");
        s.add("CaseSensitive");
        s.add("Currency");
        s.add("DefinitelyWritable");
        s.add("Nullable");
        s.add("ReadOnly");
        s.add("Searchable");
        s.add("Writable");
        this.col.add(s);
        for (ColumnAttributeResult columnAttributeResult : header) {
            ArrayList<String> row = new ArrayList<String>(s.size());
            row.add(columnAttributeResult.getColumnName());
            row.add(columnAttributeResult.getColumnLabel());
            row.add(columnAttributeResult.getColumnType().toString());
            row.add(columnAttributeResult.getColumnTypeName());
            row.add(columnAttributeResult.getColumnClassName());
            row.add(Integer.toString(columnAttributeResult.getColumnDisplaySize()));
            row.add(Integer.toString(columnAttributeResult.getPrecision()));
            row.add(Integer.toString(columnAttributeResult.getScale()));
            row.add(columnAttributeResult.getCatalogName());
            row.add(columnAttributeResult.getSchemaName());
            row.add(columnAttributeResult.getTableName());
            row.add(Boolean.toString(columnAttributeResult.isAutoIncrement()));
            row.add(Boolean.toString(columnAttributeResult.isCaseSensitive()));
            row.add(Boolean.toString(columnAttributeResult.isCurrency()));
            row.add(Boolean.toString(columnAttributeResult.isDefinitelyWritable()));
            switch (columnAttributeResult.getNullable()) {
                case 0: {
                    row.add("NoNulls");
                    break;
                }
                case 1: {
                    row.add("Nullable");
                    break;
                }
                case 2: {
                    row.add("NullableUnknown");
                    break;
                }
                default: {
                    row.add("");
                }
            }
            row.add(Boolean.toString(columnAttributeResult.isReadOnly()));
            row.add(Boolean.toString(columnAttributeResult.isSearchable()));
            row.add(Boolean.toString(columnAttributeResult.isWritable()));
            this.col.add(row);
        }
    }

    @Override
    public int getColumnCount() {
        return this.header.size() + 1;
    }

    @Override
    public int getRowCount() {
        return this.col.get(0).size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.col.get(columnIndex).get(rowIndex);
    }
}

