/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectCatalogs;
import jdbcacsess2.sqlService.dbobject.DBObjectProcedureColumns;
import jdbcacsess2.sqlService.dbobject.DBObjectSchemas;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectProcedures
extends DBObjects {
    private final ArrayList<DBObjectProcedure> procedures = new ArrayList();

    public DBObjectProcedures(DBObjectCatalogs.DBObjectCatalog catalog, DBObjectSchemas.DBObjectSchema schema, DatabaseMetaData dmd) throws SQLException {
        String catalogName = null;
        if (catalog != null) {
            catalogName = catalog.catalogName;
        }
        String schemaName = null;
        if (schema != null) {
            schemaName = schema.schemaName;
        }
        ResultSet rs = dmd.getProcedures(catalogName, schemaName, "%");
        DBObjectProcedure prev = new DBObjectProcedure();
        while (rs.next()) {
            DBObjectProcedure procedure = new DBObjectProcedure(rs);
            if (!prev.getKey().equals(procedure.getKey())) {
                this.procedures.add(procedure);
                prev = procedure;
                continue;
            }
            prev.incrementDuplicateCnt();
        }
        rs.close();
    }

    @Override
    public ArrayList<? extends DBObject> getDBObjects() {
        return this.procedures;
    }

    @Override
    public String toString() {
        return "PROCEDURE";
    }

    public static class DBObjectProcedure
    extends DBObject {
        private String procedureCat = "";
        private String procedureSchem = "";
        private String procedureName = "";
        private String remarks = "";
        private short procedureType = 0;
        private String specificName = "";
        private int duplicateCnt = 1;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        public String getProcedureCatalog() {
            return this.procedureCat;
        }

        public String getProcedureSchema() {
            return this.procedureSchem;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public short getProcedureType() {
            return this.procedureType;
        }

        public String getProcedureTypeName() {
            switch (this.procedureType) {
                case 0: {
                    return "ResultUnknown";
                }
                case 1: {
                    return "NoResult";
                }
                case 2: {
                    return "ReturnsResult";
                }
            }
            return "?";
        }

        public String getSpecificName() {
            return this.specificName;
        }

        public int getDuplicateCnt() {
            return this.duplicateCnt;
        }

        void incrementDuplicateCnt() {
            ++this.duplicateCnt;
        }

        String getKey() {
            return String.valueOf(this.procedureCat) + this.procedureSchem + this.procedureName;
        }

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectProcedure(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            if (colCnt > i) {
                this.procedureCat = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_CAT", this.procedureCat));
            }
            if (colCnt > i) {
                this.procedureSchem = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_SCHEM", this.procedureSchem));
            }
            if (colCnt > i) {
                this.procedureName = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_NAME", this.procedureName));
            }
            if (colCnt > i) {
                ++i;
            }
            if (colCnt > i) {
                ++i;
            }
            if (colCnt > i) {
                ++i;
            }
            if (colCnt > i) {
                this.remarks = rs.getString(++i);
                this.properties.add(new DBObject.Property("REMARKS", this.remarks));
            }
            if (colCnt > i) {
                this.procedureType = rs.getShort(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_TYPE", this.getProcedureTypeName()));
            }
            if (colCnt > i) {
                this.specificName = rs.getString(++i);
                this.properties.add(new DBObject.Property("SPECIFIC_NAME", this.specificName));
            }
        }

        public DBObjectProcedure() {
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return new DBObjectProcedureColumns(this, dmd);
        }

        @Override
        public String getName() {
            return this.procedureName;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.PROCEDURE.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public String getSummary() {
            return String.valueOf(this.procedureName) + (this.duplicateCnt > 1 ? "  [*" + this.duplicateCnt + "]" : "") + " " + this.specificName;
        }

        @Override
        public boolean isPropertyEnable() {
            return true;
        }
    }
}

