/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.ReferenceColumnResult;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectCatalogs;
import jdbcacsess2.sqlService.dbobject.DBObjectSchemas;
import jdbcacsess2.sqlService.dbobject.DBObjectTableColumns;
import jdbcacsess2.sqlService.dbobject.DBObjectTableTypes;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.SchemaTableName;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectTables
extends DBObjects {
    private final ArrayList<DBObjectTable> tables = new ArrayList();
    private final boolean storesLowerCaseIdentifiers;
    private final boolean storesUpperCaseQuotedIdentifiers;
    private final DBObjectTableTypes.DBObjectTableType dbObTableType;

    public DBObjectTables(DBObjectCatalogs.DBObjectCatalog catalog, DBObjectSchemas.DBObjectSchema schema, DBObjectTableTypes.DBObjectTableType tableType, DatabaseMetaData dmd) throws SQLException {
        this.storesLowerCaseIdentifiers = dmd.storesLowerCaseIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = dmd.storesUpperCaseQuotedIdentifiers();
        this.dbObTableType = tableType;
        String[] type = new String[]{tableType.tableTypeName};
        String catalogName = null;
        if (catalog != null) {
            catalogName = catalog.catalogName;
        }
        String schemaName = null;
        if (schema != null) {
            schemaName = schema.schemaName;
        }
        ResultSet rs = dmd.getTables(catalogName, schemaName, null, type);
        while (rs.next()) {
            DBObjectTable e = new DBObjectTable(rs, dmd);
            this.tables.add(e);
        }
        rs.close();
    }

    public ArrayList<DBObjectTable> getDBObjects() {
        return this.tables;
    }

    @Override
    public String toString() {
        return "TABLE";
    }

    public class DBObjectTable
    extends DBObject {
        private final List<ReferenceColumnResult> exportedKey;
        public String tableCatalog;
        public String tableSchema;
        private String tableName;
        private String tableType;
        private String remarks;
        private String typeCatalog;
        private String typeSchema;
        private String typeName;
        private String selfReferencingColName;
        private String refGeneration;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        public List<ReferenceColumnResult> getExportedKey() {
            return this.exportedKey;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String getRemarks() {
            if (this.remarks == null) {
                return "";
            }
            return this.remarks;
        }

        public String getTypeCatalog() {
            return this.typeCatalog;
        }

        public String getTypeSchema() {
            return this.typeSchema;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getSelfReferencingColName() {
            return this.selfReferencingColName;
        }

        public String getRefGeneration() {
            return this.refGeneration;
        }

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectTable(ResultSet rs, DatabaseMetaData dmd) throws SQLException {
            ResultSet exportedKeys;
            List<ReferenceColumnResult> rcr;
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            if (colCnt > i) {
                this.tableCatalog = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_CAT", this.tableCatalog));
            }
            if (colCnt > i) {
                this.tableSchema = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_SCHEM", this.tableSchema));
            }
            if (colCnt > i) {
                this.tableName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_NAME", this.tableName));
            }
            if (colCnt > i) {
                this.tableType = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_TYPE", this.tableType));
            }
            if (colCnt > i) {
                this.remarks = rs.getString(++i);
                this.properties.add(new DBObject.Property("REMARKS", this.remarks));
            }
            if (colCnt > i) {
                this.typeCatalog = rs.getString(++i);
                this.properties.add(new DBObject.Property("TYPE_CAT", this.typeCatalog));
            }
            if (colCnt > i) {
                this.typeSchema = rs.getString(++i);
                this.properties.add(new DBObject.Property("TYPE_SCHEM", this.typeSchema));
            }
            if (colCnt > i) {
                this.typeName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TYPE_NAME", this.typeName));
            }
            if (colCnt > i) {
                this.selfReferencingColName = rs.getString(++i);
                this.properties.add(new DBObject.Property("SELF_REFERENCING_COL_NAME", this.selfReferencingColName));
            }
            if (colCnt > i) {
                this.refGeneration = rs.getString(++i);
                this.properties.add(new DBObject.Property("REF_GENERATION", this.refGeneration));
            }
            if ((rcr = ReferenceColumnResult.convReferenceColumnResult(exportedKeys = dmd.getExportedKeys(this.tableCatalog, this.tableSchema, this.tableName))).size() != 0) {
                Jdbcacsess2.logger.fine(rcr.toString());
            }
            exportedKeys.close();
            this.exportedKey = rcr;
        }

        public String toString() {
            return this.tableName;
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return new DBObjectTableColumns(this, dmd);
        }

        @Override
        public SchemaTableName getSchemaTableName() throws SQLException {
            return new SchemaTableName(DBObjectTables.this.storesLowerCaseIdentifiers, DBObjectTables.this.storesUpperCaseQuotedIdentifiers, this.tableSchema, this.tableName);
        }

        @Override
        public String getName() {
            return this.tableName;
        }

        @Override
        public Icon getIconImage() {
            if (((DBObjectTables)DBObjectTables.this).dbObTableType.tableTypeName.indexOf("TABLE") != -1 || ((DBObjectTables)DBObjectTables.this).dbObTableType.tableTypeName.indexOf("table") != -1) {
                return DbObjectIconImage.TABLE.getValue();
            }
            if (((DBObjectTables)DBObjectTables.this).dbObTableType.tableTypeName.equals("VIEW")) {
                return DbObjectIconImage.VIEW.getValue();
            }
            return DbObjectIconImage.TABLETYPE.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public String getSummary() {
            return this.getName();
        }

        @Override
        public String getProperty1() {
            return this.getRemarks();
        }

        @Override
        public String getProperty2() {
            return this.getSelfReferencingColName();
        }

        @Override
        public String getProperty3() {
            return this.getRefGeneration();
        }

        @Override
        public boolean isPropertyEnable() {
            return true;
        }
    }
}

