/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.history;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jdbcacsess2.main.Config;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.sqlService.history.ExecHistory;
import net.java.ao.EntityManager;
import net.java.ao.Query;

public class HistryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7447463865535694333L;
    public static final int FILTERCLOUMN = 6;
    private final EntityManager entityManager;
    private final List<ExecHistory> historyList = new ArrayList<ExecHistory>();
    private final List<String> startDate = new ArrayList<String>();
    private final SimpleDateFormat timeFormat;
    private final SimpleDateFormat dateFormat;
    private final String[] header = new String[]{"start", "elaps", "command", "status", "cnt", "text", "connect"};

    public HistryTableModel(Config config) {
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        this.timeFormat = new SimpleDateFormat("m:ss.SSS");
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.entityManager = config.getEntityManager();
        this.initialize();
    }

    private synchronized void initialize() {
        new Thread(){

            @Override
            public void run() {
                try {
                    ExecHistory[] execHistoryArray = (ExecHistory[])HistryTableModel.this.entityManager.find(ExecHistory.class, Query.select().order("startdate"));
                    int n = execHistoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExecHistory o = execHistoryArray[n2];
                        HistryTableModel.this.historyList.add(o);
                        HistryTableModel.this.startDate.add(HistryTableModel.this.dateFormat.format(o.getStartDate()));
                        ++n2;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistryTableModel.this.fireTableDataChanged();
                        }
                    });
                    Jdbcacsess2.logger.info("history load end");
                }
                catch (SQLException e) {
                    ShowDialog.errorMessage(e);
                }
            }
        }.start();
    }

    public synchronized int add(ExecHistory execHistory) {
        this.historyList.add(execHistory);
        this.startDate.add(this.dateFormat.format(execHistory.getStartDate()));
        return this.historyList.size() - 1;
    }

    @Override
    public int getRowCount() {
        return this.historyList.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.header[column];
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExecHistory eh = this.historyList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.startDate.get(rowIndex);
            }
            case 1: {
                if (eh.getEndDate() == null) {
                    return null;
                }
                return this.timeFormat.format(new Date(eh.getEndDate().getTime() - eh.getStartDate().getTime()));
            }
            case 2: {
                return eh.getSqlCommand();
            }
            case 3: {
                return eh.getResultStatus();
            }
            case 4: {
                return eh.getResultCnt();
            }
            case 5: {
                return eh.getSqlText();
            }
            case 6: {
                return eh.getConnectName();
            }
        }
        return null;
    }
}

