/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.suites;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.store.AccessTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public final class EncryptionSuite
extends BaseJDBCTestCase {
    public EncryptionSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Encrpytion Suite");
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest(Decorator.encryptedDatabase(EncryptionSuite.baseSuite("default")));
            suite.addTest(EncryptionSuite.encryptedSuite("AES/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DES/ECB/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DESede/CFB/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("DES/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("Blowfish/CBC/NoPadding"));
            suite.addTest(EncryptionSuite.encryptedSuite("AES/OFB/NoPadding"));
        }
        return suite;
    }

    private static Test encryptedSuite(String algorithm) {
        return Decorator.encryptedDatabase(EncryptionSuite.baseSuite(algorithm), algorithm);
    }

    private static Test baseSuite(String algorithm) {
        TestSuite suite = new TestSuite("Encryption Algorithm: " + algorithm);
        suite.addTestSuite(EncryptionSuite.class);
        Properties sysProps = new Properties();
        sysProps.put("derby.optimizer.optimizeJoinOrder", "false");
        sysProps.put("derby.optimizer.ruleBasedOptimization", "true");
        sysProps.put("derby.optimizer.noTimeout", "true");
        suite.addTestSuite(AccessTest.class);
        return suite;
    }

    protected void setUp() {
        try {
            Connection conn = this.getConnection();
            Statement s = this.createStatement();
            s.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
            s.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        Statement st = this.createStatement();
        super.tearDown();
        try {
            st.executeUpdate("DROP FUNCTION PADSTRING");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testEncryptedDBConnection() throws SQLException {
        this.getConnection().close();
    }
}

