/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClosedObjectTest
extends BaseJDBCTestCase {
    private final Method method_;
    private final ObjectDecorator decorator_;
    private String name_;
    static /* synthetic */ Class class$java$util$Properties;

    public ClosedObjectTest(Method method, ObjectDecorator decorator) {
        super("testClosedObjects");
        this.method_ = method;
        this.decorator_ = decorator;
        this.name_ = method.getDeclaringClass().getName() + "." + method.getName();
    }

    public String getName() {
        return this.name_;
    }

    public void testClosedObjects() throws Throwable {
        try {
            Object object = this.decorator_.getClosedObject();
            this.name_ = object.getClass() + "." + this.method_.getName();
            this.method_.invoke(object, ClosedObjectTest.getNullArguments(this.method_.getParameterTypes()));
            if (!"public abstract void java.sql.Connection.abort(java.util.concurrent.Executor) throws java.sql.SQLException".equals(this.method_.toString())) {
                ClosedObjectTest.assertFalse((String)("No exception was thrown for method " + this.method_), (boolean)this.decorator_.expectsException(this.method_));
            }
        }
        catch (InvocationTargetException ite) {
            try {
                throw ite.getCause();
            }
            catch (SQLException sqle) {
                this.decorator_.checkException(this.method_, sqle);
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ClosedObjectTest suite");
        suite.addTest(ClosedObjectTest.baseSuite("ClosedObjectTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ClosedObjectTest.baseSuite("ClosedObjectTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite topSuite = new TestSuite(name);
        TestSuite dsSuite = new TestSuite("ClosedObjectTest DataSource");
        DataSourceDecorator dsDecorator = new DataSourceDecorator((Test)dsSuite);
        topSuite.addTest((Test)dsDecorator);
        ClosedObjectTest.fillDataSourceSuite(dsSuite, dsDecorator);
        if (JDBC.vmSupportsJDBC3()) {
            TestSuite poolSuite = new TestSuite("ClosedObjectTest ConnectionPoolDataSource");
            PoolDataSourceDecorator poolDecorator = new PoolDataSourceDecorator((Test)poolSuite);
            topSuite.addTest((Test)poolDecorator);
            ClosedObjectTest.fillDataSourceSuite(poolSuite, poolDecorator);
            TestSuite xaSuite = new TestSuite("ClosedObjectTest XA");
            XADataSourceDecorator xaDecorator = new XADataSourceDecorator((Test)xaSuite);
            topSuite.addTest((Test)xaDecorator);
            ClosedObjectTest.fillDataSourceSuite(xaSuite, xaDecorator);
        }
        return topSuite;
    }

    private static void fillDataSourceSuite(TestSuite suite, DataSourceDecorator dsDecorator) {
        TestSuite rsSuite = new TestSuite("Closed ResultSet");
        ResultSetObjectDecorator rsDecorator = new ResultSetObjectDecorator((Test)rsSuite, dsDecorator);
        suite.addTest((Test)rsDecorator);
        ClosedObjectTest.fillObjectSuite(rsSuite, rsDecorator, ResultSet.class);
        TestSuite stmtSuite = new TestSuite("Closed Statement");
        StatementObjectDecorator stmtDecorator = new StatementObjectDecorator((Test)stmtSuite, dsDecorator);
        suite.addTest((Test)stmtDecorator);
        ClosedObjectTest.fillObjectSuite(stmtSuite, stmtDecorator, Statement.class);
        TestSuite psSuite = new TestSuite("Closed PreparedStatement");
        PreparedStatementObjectDecorator psDecorator = new PreparedStatementObjectDecorator((Test)psSuite, dsDecorator);
        suite.addTest((Test)psDecorator);
        ClosedObjectTest.fillObjectSuite(psSuite, psDecorator, PreparedStatement.class);
        TestSuite csSuite = new TestSuite("Closed CallableStatement");
        CallableStatementObjectDecorator csDecorator = new CallableStatementObjectDecorator((Test)csSuite, dsDecorator);
        suite.addTest((Test)csDecorator);
        ClosedObjectTest.fillObjectSuite(csSuite, csDecorator, CallableStatement.class);
        TestSuite connSuite = new TestSuite("Closed Connection");
        ConnectionObjectDecorator connDecorator = new ConnectionObjectDecorator((Test)connSuite, dsDecorator);
        suite.addTest((Test)connDecorator);
        ClosedObjectTest.fillObjectSuite(connSuite, connDecorator, Connection.class);
    }

    private static void fillObjectSuite(TestSuite suite, ObjectDecorator decorator, Class iface) {
        Method[] methods = iface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ClosedObjectTest cot = new ClosedObjectTest(methods[i], decorator);
            suite.addTest((Test)cot);
        }
    }

    private static Object[] getNullArguments(Class[] params) {
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = ClosedObjectTest.getNullValueForType(params[i]);
        }
        return args;
    }

    private static Object getNullValueForType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        ClosedObjectTest.fail((String)("Don't know how to handle type " + type));
        return null;
    }

    private static class XADataSourceDecorator
    extends DataSourceDecorator {
        public XADataSourceDecorator(Test test) {
            super(test);
        }

        protected Connection newConnection_() throws SQLException {
            XADataSource ds = J2EEDataSource.getXADataSource();
            XAConnection xac = ds.getXAConnection();
            return xac.getConnection();
        }
    }

    private static class PoolDataSourceDecorator
    extends DataSourceDecorator {
        public PoolDataSourceDecorator(Test test) {
            super(test);
        }

        protected Connection newConnection_() throws SQLException {
            ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
            PooledConnection pc = ds.getPooledConnection();
            return pc.getConnection();
        }
    }

    private static class DataSourceDecorator
    extends TestSetup {
        private Connection connection_;

        public DataSourceDecorator(Test test) {
            super(test);
        }

        public final void setUp() throws SQLException {
            this.connection_ = this.newConnection();
        }

        public final Connection getConnection() {
            return this.connection_;
        }

        public final Connection newConnection() throws SQLException {
            Connection conn = this.newConnection_();
            conn.setAutoCommit(false);
            return conn;
        }

        public final void tearDown() throws SQLException {
            this.connection_.rollback();
            this.connection_.close();
            this.connection_ = null;
        }

        protected Connection newConnection_() throws SQLException {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "create=true");
            return ds.getConnection();
        }
    }

    private static class ConnectionObjectDecorator
    extends ObjectDecorator {
        public ConnectionObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            Connection conn = this.createConnection();
            conn.rollback();
            conn.close();
            this.object_ = conn;
        }

        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            if (method.getName().equals("setClientInfo") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == (class$java$util$Properties == null ? (class$java$util$Properties = ClosedObjectTest.class$("java.util.Properties")) : class$java$util$Properties)) {
                if (!sqle.getClass().getName().equals("java.sql.SQLClientInfoException")) {
                    throw sqle;
                }
            } else if (!sqle.getSQLState().equals("08003")) {
                throw sqle;
            }
        }
    }

    private static class CallableStatementObjectDecorator
    extends PreparedStatementObjectDecorator {
        public CallableStatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            cs.close();
            this.object_ = cs;
        }
    }

    private static class PreparedStatementObjectDecorator
    extends StatementObjectDecorator {
        public PreparedStatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            PreparedStatement ps = this.prepareStatement("VALUES(1)");
            ps.close();
            this.object_ = ps;
        }

        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            if (method.getDeclaringClass() != (class$java$sql$Statement == null ? (class$java$sql$Statement = ClosedObjectTest.class$("java.sql.Statement")) : class$java$sql$Statement) || !sqle.getSQLState().equals("XJ016")) {
                super.checkSQLState(method, sqle);
            }
        }
    }

    private static class StatementObjectDecorator
    extends ObjectDecorator {
        public StatementObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            Statement stmt = this.createStatement();
            stmt.close();
            this.object_ = stmt;
        }

        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            String sqlState = sqle.getSQLState();
            if (!sqlState.equals("XJ012")) {
                throw sqle;
            }
        }
    }

    private static class ResultSetObjectDecorator
    extends ObjectDecorator {
        private Statement stmt_;

        public ResultSetObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test, decorator);
        }

        public void setUp() throws SQLException {
            this.stmt_ = this.createStatement();
            ResultSet rs = this.stmt_.executeQuery("VALUES(1)");
            rs.close();
            this.object_ = rs;
        }

        public void tearDown() throws Exception {
            this.stmt_.close();
            this.stmt_ = null;
            super.tearDown();
        }

        protected void checkSQLState(Method method, SQLException sqle) throws SQLException {
            String methodString;
            if (sqle.getSQLState().equals("XCL16")) {
                methodString = method.getName();
                if (methodString.indexOf("(") > 1) {
                    methodString = methodString.substring(0, methodString.length() - 2);
                }
            } else {
                throw sqle;
            }
            ResultSetObjectDecorator.assertTrue((String)("method = " + method.toString() + ", but message: " + sqle.getMessage()), (sqle.getMessage().indexOf(methodString) > 0 ? 1 : 0) != 0);
        }
    }

    private static abstract class ObjectDecorator
    extends TestSetup {
        private final DataSourceDecorator decorator_;
        protected Object object_;

        public ObjectDecorator(Test test, DataSourceDecorator decorator) {
            super(test);
            this.decorator_ = decorator;
        }

        protected void tearDown() throws Exception {
            this.object_ = null;
        }

        public Object getClosedObject() {
            return this.object_;
        }

        public boolean expectsException(Method method) {
            String name = method.getName();
            return !name.equals("close") && !name.equals("isClosed") && !name.equals("isValid");
        }

        public final void checkException(Method method, SQLException sqle) throws SQLException {
            if (!this.expectsException(method)) {
                throw sqle;
            }
            if (sqle.getSQLState().startsWith("0A")) {
                return;
            }
            this.checkSQLState(method, sqle);
        }

        protected abstract void checkSQLState(Method var1, SQLException var2) throws SQLException;

        protected Connection createConnection() throws SQLException {
            return this.decorator_.newConnection();
        }

        protected Statement createStatement() throws SQLException {
            return this.decorator_.getConnection().createStatement();
        }

        protected PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.decorator_.getConnection().prepareStatement(sql);
        }

        protected CallableStatement prepareCall(String call) throws SQLException {
            return this.decorator_.getConnection().prepareCall(call);
        }
    }
}

