/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PoolXADSCreateShutdownDBTest
extends BaseJDBCTestCase {
    static final String[] ADDITIONAL_DBS = new String[]{"dscreateconatdb1", "dscreateshutdowndb1", "dscreateshutdowndb2", "conflict1", "conflict2", "conflict3", "conflict4", "conflict5", "conflict6", "conflict7"};
    static String DBNotFoundState;
    private String ShutdownState = "08006";

    public PoolXADSCreateShutdownDBTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PoolXADSCreateShutdownTest");
        Test test = TestConfiguration.defaultSuite(PoolXADSCreateShutdownDBTest.class);
        suite.addTest(test);
        TestSetup setup = TestConfiguration.singleUseDatabaseDecorator((Test)suite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, "emb" + ADDITIONAL_DBS[i]);
            setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, "srv" + ADDITIONAL_DBS[i]);
        }
        return suite;
    }

    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
                    this.removeDatabase("emb" + ADDITIONAL_DBS[i]);
                    this.removeDatabase("srv" + ADDITIONAL_DBS[i]);
                }
                return null;
            }

            void removeDatabase(String dbName) {
                dbName = dbName.replace('/', File.separatorChar);
                String dsh = PoolXADSCreateShutdownDBTest.getSystemProperty("derby.system.home");
                if (dsh == null) {
                    Assert.fail((String)"not implemented");
                } else {
                    dbName = dsh + File.separator + dbName;
                }
                this.removeDirectory(dbName);
            }

            void removeDirectory(String path) {
                File dir = new File(path);
                this.removeDir(dir);
            }

            private void removeDir(File dir) {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(dir, list[i]);
                        if (entry.isDirectory()) {
                            this.removeDir(entry);
                            continue;
                        }
                        entry.delete();
                    }
                }
                dir.delete();
            }
        });
        super.tearDown();
    }

    public void testPoolDS() throws SQLException {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        this.doCreateAndShutdown(ds);
    }

    public void testXADS() throws SQLException {
        XADataSource ds = J2EEDataSource.getXADataSource();
        this.doCreateAndShutdown(ds);
    }

    public void doCreateAndShutdown(Object ds) throws SQLException {
        DBNotFoundState = PoolXADSCreateShutdownDBTest.usingEmbedded() ? "XJ004" : "08004";
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        PoolXADSCreateShutdownDBTest.assertUpdateCount(this.createStatement(), 0, "set schema APP");
        this.assertGetNull(ds, dbName);
        this.assertSetAndGet(ds, dbName, "shutdownDatabase", "shutdown");
        this.assertSetAndGet(ds, dbName, "createDatabase", "create");
        this.assertNotSetAndGet(ds, dbName, "shutdownDatabase", "boo");
        this.assertNotSetAndGet(ds, dbName, "createDatabase", "boo");
        this.assertNotSetAndGet(ds, dbName, "shutdownDatabase", "false");
        this.assertNotSetAndGet(ds, dbName, "createDatabase", "false");
        this.assertReset(ds, dbName);
        this.clearBeanProperties(ds);
        this.assertCreateUsingConnAttrsOK(ds, this.composeDatabaseName(ADDITIONAL_DBS[0]));
        this.clearBeanProperties(ds);
        this.assertShutdownUsingConnAttrsOK(ds, dbName);
        this.clearBeanProperties(ds);
        dbName = this.composeDatabaseName(ADDITIONAL_DBS[1]);
        this.assertNoDB(ds, dbName);
        this.clearBeanProperties(ds);
        this.assertPositive(ds, dbName);
        this.clearBeanProperties(ds);
        dbName = this.composeDatabaseName(ADDITIONAL_DBS[2]);
        this.assertNoDB(ds, dbName);
        this.clearBeanProperties(ds);
        this.assertTwiceOK(ds, dbName);
        this.clearBeanProperties(ds);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, ds, this.composeDatabaseName(ADDITIONAL_DBS[3]), "shutdown=true;create=true");
        this.clearBeanProperties(ds);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, ds, this.composeDatabaseName(ADDITIONAL_DBS[4]), "create=true;shutdown=true");
        this.clearBeanProperties(ds);
        this.assertConflictedSettersOK(ds, this.composeDatabaseName(ADDITIONAL_DBS[5]));
        this.clearBeanProperties(ds);
        this.assertConflictedSetterConnAttrOK(ds);
    }

    protected String composeDatabaseName(String dbName) {
        if (PoolXADSCreateShutdownDBTest.usingEmbedded()) {
            return "emb" + dbName;
        }
        return "srv" + dbName;
    }

    protected void assertGetNull(Object ds, String dbName) throws SQLException {
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
    }

    protected void assertSetAndGet(Object ds, String dbName, String propertyString, String setValue) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, propertyString, setValue);
        PoolXADSCreateShutdownDBTest.assertEquals((String)setValue, (String)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, propertyString).toString());
    }

    protected void assertNotSetAndGet(Object ds, String dbName, String propertyString, String setValue) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, propertyString, setValue);
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, propertyString));
    }

    protected void assertReset(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "boo");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "false");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        try {
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "boo");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "false");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        try {
            JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getBeanProperty(Object ds, String propertyString) {
        String getterName = PoolXADSCreateShutdownDBTest.getGetterName(propertyString);
        Object retObject = null;
        try {
            Method getter = ds.getClass().getMethod(getterName, null);
            retObject = getter.invoke(ds, null);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return retObject;
    }

    private static String getGetterName(String attribute) {
        return "get" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    protected void assertShutdownUsingSetOK(Object ds, String dbName, boolean connAttr) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        if (connAttr) {
            JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        }
        this.assertDSConnectionFailed(this.ShutdownState, ds);
    }

    protected void assertCreateUsingConnAttrsOK(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "create=true");
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        this.assertUpdateCount(ds);
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(ds, dbName, false);
    }

    protected void assertShutdownUsingConnAttrsOK(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        this.assertDSConnectionFailed(this.ShutdownState, ds);
    }

    protected void assertShutdownAndCreateConnAttr(String expectedSQLState, Object ds, String dbName, String twoPropertyString) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", twoPropertyString);
        this.assertDSConnectionFailed(expectedSQLState, ds);
    }

    protected void assertDSConnectionFailed(String expectedSQLState, Object ds) throws SQLException {
        try {
            if (ds instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)ds).getPooledConnection();
            } else {
                ((XADataSource)ds).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + expectedSQLState));
        }
        catch (SQLException sqle) {
            PoolXADSCreateShutdownDBTest.assertSQLState(expectedSQLState, sqle);
        }
    }

    protected void assertNoDB(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        this.assertDSConnectionFailed(DBNotFoundState, ds);
    }

    protected void assertPositive(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        this.assertUpdateCount(ds);
        this.clearBeanProperties(ds);
        this.assertShutdownUsingSetOK(ds, dbName, false);
    }

    protected void assertTwiceOK(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "create=true");
        this.assertUpdateCount(ds);
        this.clearBeanProperties(ds);
        this.assertShutdownUsingSetOK(ds, dbName, true);
    }

    protected void assertConflictedSettersOK(Object ds, String dbName) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            if (ds instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)ds).getPooledConnection();
            } else {
                ((XADataSource)ds).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + DBNotFoundState));
        }
        catch (SQLException se) {
            PoolXADSCreateShutdownDBTest.assertSQLState(DBNotFoundState, se);
        }
    }

    protected void assertConflictedSetterConnAttrOK(Object ds) throws SQLException {
        this.assertConSetOK(ds, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[6]), "shutdown=true", "CreateDatabase", "create");
        this.assertConSetOK(ds, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[7]), "create=true", "ShutdownDatabase", "shutdown");
        this.assertSetConOK(ds, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[8]), "shutdown=true", "CreateDatabase", "create");
        this.assertSetConOK(ds, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[9]), "create=true", "ShutdownDatabase", "shutdown");
    }

    protected void assertConSetOK(Object ds, String expectedSQLState, String dbName, String connAttrValue, String setter, String setValue) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, setter, setValue);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", connAttrValue);
        try {
            if (ds instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)ds).getPooledConnection();
            } else {
                ((XADataSource)ds).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + expectedSQLState));
        }
        catch (SQLException se) {
            PoolXADSCreateShutdownDBTest.assertSQLState(expectedSQLState, se);
        }
        JDBCDataSource.clearStringBeanProperty(ds, setter);
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
    }

    protected void assertSetConOK(Object ds, String expectedSQLState, String dbName, String connAttrValue, String setter, String setValue) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", connAttrValue);
        JDBCDataSource.setBeanProperty(ds, setter, setValue);
        try {
            if (ds instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)ds).getPooledConnection();
            } else {
                ((XADataSource)ds).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + expectedSQLState));
        }
        catch (SQLException se) {
            PoolXADSCreateShutdownDBTest.assertSQLState(expectedSQLState, se);
        }
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
        JDBCDataSource.clearStringBeanProperty(ds, setter);
    }

    protected void assertUpdateCount(Object ds) throws SQLException {
        if (ds instanceof ConnectionPoolDataSource) {
            PoolXADSCreateShutdownDBTest.assertUpdateCount(((ConnectionPoolDataSource)ds).getPooledConnection().getConnection().createStatement(), 0, "set schema APP");
        } else {
            PoolXADSCreateShutdownDBTest.assertUpdateCount(((XADataSource)ds).getXAConnection().getConnection().createStatement(), 0, "set schema APP");
        }
    }

    private void clearBeanProperties(Object ds) throws SQLException {
        JDBCDataSource.clearStringBeanProperty(ds, "createDatabase");
        JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
        JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
    }
}

