/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.junitTests.compatibility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseTestCase;

public class CompatibilityCombinations
extends BaseTestCase {
    private static final String COMPATIBILITYTEST_PROPFILE = "compatibilitytest.properties";
    private static String securityProperty = "";
    private static String[] derbyVersionNames = null;
    private static String[] derbyVerLibs = null;
    private static boolean[] derbySecurityEnabled = null;
    private static String[] vmNames = null;
    private static String[] VM_Ids = null;
    private static final int DERBY_JAR = 0;
    private static final int DERBYCLIENT_JAR = 1;
    private static final int DERBYNET_JAR = 2;
    private static final int DERBYTESTING_JAR = 3;
    private static final int DERBYMAX_JAR = 3;
    private static String[][] derbyLib = null;
    private static String db2jcc_lib = null;
    private static String CLIENT_DB2JCC = null;
    private static String junit_jar = null;
    private static String jce_jar = null;
    private static String jdbc2_0_stdext_jar = null;
    private static String test_jars = null;
    private static String serverHost = "localhost";
    private static int serverPort = 1527;
    private static String compatibilityTestSuite = null;
    private static final String embeddedDriver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String networkServerControl = "org.apache.derby.drda.NetworkServerControl";
    private static String specialTestingJar = null;
    private static String singleClient = null;
    private static String singleClientVM = null;
    private static String singleServer = null;
    private static String singleServerVM = null;
    private static final String PS = File.separator;
    private static final String JVMloc = PS + ".." + PS + "bin" + PS + "java";
    private static boolean runEmbedded = true;
    private static boolean runSrvrClnt = false;
    private static boolean printDebug = false;
    private static boolean showSysinfo = false;
    private static boolean includeUpgrade = false;
    private static long SLEEP_TIME_MILLIS = 5000L;
    private Process serverProc;

    public CompatibilityCombinations(String testcaseName) {
        super(testcaseName);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTestSuite(CompatibilityCombinations.class);
        return testSuite;
    }

    public void testEmbeddedTrunk() throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ testEmbeddedTrunk");
        this.initEnvironment();
        boolean debugVal = true;
        String testName = compatibilityTestSuite;
        String databaseName = "wombat";
        if (!runEmbedded) {
            CompatibilityCombinations.DEBUG("--- testEmbeddedTrunk ignored");
            return;
        }
        String workingDirName = System.getProperty("user.dir");
        PrintWriter summaryFile = new PrintWriter(new FileWriter(workingDirName + PS + "Embedded_" + databaseName + "_summary.log"));
        PrintWriter failFile = new PrintWriter(new FileWriter(workingDirName + PS + "Embedded_" + databaseName + "_failed"));
        int currentTestVersion = derbyVerLibs.length - 1;
        int noOfCombinations = 0;
        int successFullTests = 0;
        String derbyTestingJar = derbyLib[currentTestVersion][3];
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        long startTime = System.currentTimeMillis();
        int trunkVersion = derbyLib.length - 1;
        int serverVmLow = 0;
        int serverVmHigh = VM_Ids.length - 1;
        if (singleServerVM != null) {
            serverVmHigh = serverVmLow = Integer.parseInt(singleServerVM);
        }
        for (int serverVM = serverVmLow; serverVM <= serverVmHigh; ++serverVM) {
            String creatorJvm = VM_Ids[serverVM] + JVMloc;
            String derbyCreatorJar = derbyLib[trunkVersion][0] + ":" + derbyLib[trunkVersion][2];
            CompatibilityCombinations.DEBUG("derbyCreatorJar: " + derbyCreatorJar);
            String creatorClassPath = derbyCreatorJar + ":" + derbyTestingJar + ":" + junit_jar + ":" + jce_jar;
            this.recreateDB(trunkVersion, creatorJvm, creatorClassPath, true, databaseName, true);
            int clientVmLow = 0;
            int clientVmHigh = VM_Ids.length - 1;
            if (singleClientVM != null) {
                clientVmHigh = clientVmLow = Integer.parseInt(singleClientVM);
            }
            for (int clientVM = clientVmLow; clientVM <= clientVmHigh; ++clientVM) {
                for (int clientVersion = derbyLib.length - 1; clientVersion < derbyLib.length; ++clientVersion) {
                    ++noOfCombinations;
                    String clientName = derbyVersionNames[clientVersion];
                    String derbyClientJar = derbyCreatorJar;
                    if (derbyVersionNames[clientVersion].equalsIgnoreCase("10.0.2.1")) {
                        derbyClientJar = CLIENT_DB2JCC;
                        clientName = "10.0.DB2JCC";
                    }
                    CompatibilityCombinations.DEBUG("derbyClientJar: " + derbyClientJar);
                    String clientJvm = VM_Ids[clientVM] + JVMloc;
                    String clientClassPath = derbyClientJar + ":" + derbyTestingJar + ":" + junit_jar + ":" + jce_jar + ":" + jdbc2_0_stdext_jar;
                    String combinationName = "Embedded_" + derbyVersionNames[trunkVersion] + "VM" + vmNames[serverVM] + "_vs_" + "ClientVM-" + vmNames[clientVM] + "_client" + clientName;
                    if (showSysinfo) {
                        this.sysinfoEmbedded(clientVM, clientVersion, combinationName);
                    }
                    CompatibilityCombinations.DEBUG("**************** oneTest(" + combinationName + ")");
                    try {
                        boolean OK = this.oneTest(clientJvm, clientClassPath, debugVal, testName, embeddedDriver, databaseName, combinationName, summaryFile);
                        if (OK) {
                            ++successFullTests;
                            continue;
                        }
                        System.out.println("************ " + combinationName + " failed!");
                        failFile.println(combinationName);
                        failFile.flush();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        long endTime = System.currentTimeMillis();
        float timeUsed = (endTime - startTime) / 1000L;
        String summary = "Attempted 'embedded vs. network client' tests: " + noOfCombinations + ", OK: " + successFullTests + ", Failed: " + (noOfCombinations - successFullTests) + ", Time: " + timeUsed + " seconds";
        summaryFile.println();
        summaryFile.println(summary);
        summaryFile.close();
        failFile.close();
        System.out.println(summary);
        CompatibilityCombinations.DEBUG("--- testEmbeddedTrunk");
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.assertTrue((String)summary, (noOfCombinations - successFullTests == 0 ? 1 : 0) != 0);
    }

    public void testLoopThruAllCombinations() throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ testLoopThruAllCombinations");
        this.initEnvironment();
        boolean debugVal = true;
        String testName = compatibilityTestSuite;
        String databaseName = "wombat";
        if (!runSrvrClnt) {
            CompatibilityCombinations.DEBUG("--- testLoopThruAllCombinations ignored");
            return;
        }
        String workingDirName = System.getProperty("user.dir");
        PrintWriter summaryFile = new PrintWriter(new FileWriter(workingDirName + PS + "ServerClient_" + databaseName + "_summary.log"));
        PrintWriter failFile = new PrintWriter(new FileWriter(workingDirName + PS + "ServerClient_" + databaseName + "_failed"));
        int currentTestVersion = derbyVerLibs.length - 1;
        int noOfCombinations = 0;
        int successFullTests = 0;
        String derbyTestingJar = derbyLib[currentTestVersion][3];
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        int serverVmLow = 0;
        int serverVmHigh = VM_Ids.length - 1;
        if (singleServerVM != null) {
            serverVmHigh = serverVmLow = Integer.parseInt(singleServerVM);
        }
        long startTime = System.currentTimeMillis();
        for (int serverVM = serverVmLow; serverVM <= serverVmHigh; ++serverVM) {
            int serverVersionLow = 0;
            int serverVersionHigh = derbyLib.length - 1;
            if (singleServer != null) {
                serverVersionHigh = serverVersionLow = Integer.parseInt(singleServer);
            }
            for (int serverVersion = serverVersionLow; serverVersion <= serverVersionHigh; ++serverVersion) {
                boolean deleteDatabaseFiles;
                this.startServer(serverVM, serverVersion);
                String creatorJvm = VM_Ids[serverVM] + JVMloc;
                String derbyCreatorJar = derbyLib[0][1];
                if (derbyVersionNames[0].equalsIgnoreCase("10.0.2.1")) {
                    derbyCreatorJar = CLIENT_DB2JCC;
                }
                CompatibilityCombinations.DEBUG("derbyCreatorJar: " + derbyCreatorJar);
                String creatorClassPath = derbyCreatorJar + ":" + derbyTestingJar + ":" + junit_jar + ":" + jce_jar;
                boolean bl = deleteDatabaseFiles = !includeUpgrade;
                if (serverVersion == 0) {
                    deleteDatabaseFiles = true;
                }
                this.recreateDB(serverVersion, creatorJvm, creatorClassPath, true, databaseName, deleteDatabaseFiles);
                int clientVmLow = 0;
                int clientVmHigh = VM_Ids.length - 1;
                if (singleClientVM != null) {
                    clientVmHigh = clientVmLow = Integer.parseInt(singleClientVM);
                }
                for (int clientVM = clientVmLow; clientVM <= clientVmHigh; ++clientVM) {
                    int clientVersionLow = 0;
                    int clientVersionHigh = derbyLib.length - 1;
                    if (singleClient != null) {
                        clientVersionHigh = clientVersionLow = Integer.parseInt(singleClient);
                    }
                    for (int clientVersion = clientVersionLow; clientVersion <= clientVersionHigh; ++clientVersion) {
                        ++noOfCombinations;
                        String clientName = derbyVersionNames[clientVersion];
                        String derbyClientJar = derbyLib[clientVersion][1];
                        if (derbyVersionNames[clientVersion].equalsIgnoreCase("10.0.2.1")) {
                            derbyClientJar = CLIENT_DB2JCC;
                            clientName = "10.0.DB2JCC";
                        }
                        CompatibilityCombinations.DEBUG("derbyClientJar: " + derbyClientJar);
                        String clientJvm = VM_Ids[clientVM] + JVMloc;
                        String clientClassPath = derbyClientJar + ":" + derbyTestingJar + ":" + junit_jar + ":" + jce_jar + ":" + jdbc2_0_stdext_jar;
                        String combinationName = "ServerVM-" + vmNames[serverVM] + "_server" + derbyVersionNames[serverVersion] + "_vs_" + "ClientVM-" + vmNames[clientVM] + "_client" + clientName;
                        if (showSysinfo) {
                            this.sysinfoServerFromClient(clientVM, clientVersion, combinationName);
                        }
                        CompatibilityCombinations.DEBUG("**************** oneTest(" + combinationName + ")");
                        try {
                            boolean OK = this.oneTest(clientJvm, clientClassPath, debugVal, testName, null, databaseName, combinationName, summaryFile);
                            if (OK) {
                                ++successFullTests;
                                continue;
                            }
                            System.out.println("************ " + combinationName + " failed!");
                            failFile.println(combinationName);
                            failFile.flush();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.stopServer(serverVM, serverVersion);
            }
        }
        long endTime = System.currentTimeMillis();
        float timeUsed = (endTime - startTime) / 1000L;
        String summary = "Attempted 'server - network client' tests: " + noOfCombinations + ", OK: " + successFullTests + ", Failed: " + (noOfCombinations - successFullTests) + ", Time: " + timeUsed + " seconds";
        summaryFile.println();
        summaryFile.println(summary);
        summaryFile.close();
        failFile.close();
        System.out.println(summary);
        CompatibilityCombinations.DEBUG("--- testLoopThruAllCombinations");
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.assertTrue((String)summary, (noOfCombinations - successFullTests == 0 ? 1 : 0) != 0);
    }

    private boolean oneTest(String clientJvm, String clientClassPath, boolean debug, String testName, String driverName, String databaseName, String combinationName, PrintWriter summaryFile) throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ oneTest: " + combinationName + " ++++++++++++++++++++++++++++++++++++++");
        CompatibilityCombinations.DEBUG("clientJvm:       " + clientJvm);
        CompatibilityCombinations.DEBUG("clientClassPath: " + clientClassPath);
        CompatibilityCombinations.DEBUG("debug:           " + debug);
        CompatibilityCombinations.DEBUG("testName:        " + testName);
        CompatibilityCombinations.DEBUG("driverName:      " + driverName);
        CompatibilityCombinations.DEBUG("databaseName:    " + databaseName);
        CompatibilityCombinations.DEBUG("combinationName: " + combinationName);
        boolean testOK = false;
        int port = serverPort;
        if (driverName == null) {
            driverName = "";
        }
        String[] commandElements = new String[]{clientJvm, " -Ddrb.tests.debug=true", " -Dderby.tests.trace=true", " -cp ", clientClassPath, " " + testName, " " + databaseName, " " + driverName};
        String[] envElements = new String[]{"CLASS_PATH=" + clientClassPath};
        String workingDirName = System.getProperty("user.dir");
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        CompatibilityCombinations.DEBUG("commandElements: " + tmp);
        String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp);
        File workingDir = new File(workingDirName);
        CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(fullCmd,envElements,workingDir);");
        try {
            Process proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
            PrintWriter out = new PrintWriter(new FileWriter(workingDirName + PS + combinationName));
            String result = CompatibilityCombinations.testOutput(proc, out);
            proc.waitFor();
            if (result.indexOf(" OK ") != -1) {
                testOK = true;
            }
            result = combinationName + ":" + result;
            summaryFile.println(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        summaryFile.flush();
        CompatibilityCombinations.DEBUG("--- oneTest: " + combinationName + " --------------------------------------");
        CompatibilityCombinations.DEBUG("");
        return testOK;
    }

    private static String testOutput(Process proc, PrintWriter out) throws IOException {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(isr);
        String line = null;
        String result = "";
        boolean foundTime = false;
        boolean foundOK = false;
        boolean foundFail = false;
        while ((line = bir.readLine()) != null) {
            out.println(line);
            if (!foundTime && line.indexOf("Time:", 0) != -1) {
                foundTime = true;
                result = result + " " + line;
                continue;
            }
            if (!foundOK && !foundFail && line.indexOf("OK ", 0) != -1) {
                foundOK = true;
                result = result + " " + line;
                continue;
            }
            if (foundFail || foundFail || line.indexOf("Failures:", 0) == -1) continue;
            foundFail = true;
            result = result + " " + line;
        }
        out.close();
        return result;
    }

    private void initEnvironment() throws IOException {
        int v;
        int vm;
        System.out.println("*** Properties -----------------------------------------");
        String userDir = System.getProperty("user.dir");
        System.out.println("user.dir:          " + userDir);
        System.out.println("derby.system.home: " + System.getProperty("derby.system.home"));
        String realPropertyFile = COMPATIBILITYTEST_PROPFILE;
        System.out.println("realPropertyFile: " + realPropertyFile);
        FileInputStream isCp = new FileInputStream(userDir + PS + realPropertyFile);
        Properties cp = new Properties();
        cp.load(isCp);
        printDebug = cp.getProperty("test.printDebug", "false").equalsIgnoreCase("true");
        System.out.println("printDebug: " + printDebug);
        showSysinfo = cp.getProperty("test.showSysinfo", "false").equalsIgnoreCase("true");
        System.out.println("showSysinfo: " + showSysinfo);
        serverPort = Integer.parseInt(cp.getProperty("test.serverPort", "1527"));
        System.out.println("serverPort: " + serverPort);
        compatibilityTestSuite = cp.getProperty("test.testSuite", "org.apache.derbyTesting.functionTests.tests.junitTests.compatibility.CompatibilitySuite");
        System.out.println("testSuite: " + compatibilityTestSuite);
        runEmbedded = cp.getProperty("test.runEmbedded", "true").equalsIgnoreCase("true");
        System.out.println("runEmbedded: " + runEmbedded);
        runSrvrClnt = cp.getProperty("test.runServerClient", "true").equalsIgnoreCase("true");
        System.out.println("runSrvrClnt: " + runSrvrClnt);
        includeUpgrade = cp.getProperty("test.includeUpgrade", "false").equalsIgnoreCase("true");
        System.out.println("includeUpgrade: " + includeUpgrade);
        singleClient = cp.getProperty("test.singleClient", null);
        System.out.println("singleClient: " + singleClient);
        singleClientVM = cp.getProperty("test.singleClientVM", null);
        System.out.println("singleClientVM: " + singleClientVM);
        singleServer = cp.getProperty("test.singleServer", null);
        System.out.println("singleServer: " + singleServer);
        singleServerVM = cp.getProperty("test.singleServerVM", null);
        System.out.println("singleServerVM: " + singleServerVM);
        specialTestingJar = cp.getProperty("test.derbyTestingJar", null);
        System.out.println("specialTestingJar: " + specialTestingJar);
        securityProperty = cp.getProperty("test.securityOption");
        System.out.println("securityProperty: " + securityProperty);
        int jvmVersions = Integer.parseInt(cp.getProperty("jvm.versions"));
        vmNames = new String[jvmVersions];
        VM_Ids = new String[jvmVersions];
        for (vm = 0; vm < jvmVersions; ++vm) {
            CompatibilityCombinations.vmNames[vm] = cp.getProperty("jvm." + vm);
            System.out.println(vm + ": " + vmNames[vm]);
        }
        for (vm = 0; vm < jvmVersions; ++vm) {
            CompatibilityCombinations.VM_Ids[vm] = cp.getProperty(vmNames[vm]);
            System.out.println(vmNames[vm] + ": " + VM_Ids[vm]);
        }
        int derbyVersions = Integer.parseInt(cp.getProperty("derby.versions"));
        derbyVersionNames = new String[derbyVersions];
        for (v = 0; v < derbyVersions; ++v) {
            CompatibilityCombinations.derbyVersionNames[v] = cp.getProperty("derby.version" + v);
        }
        derbyVerLibs = new String[derbyVersions];
        derbySecurityEnabled = new boolean[derbyVersions];
        for (v = 0; v < derbyVersions; ++v) {
            CompatibilityCombinations.derbyVerLibs[v] = cp.getProperty(derbyVersionNames[v]);
            CompatibilityCombinations.derbySecurityEnabled[v] = cp.getProperty(derbyVersionNames[v] + "_SA").equalsIgnoreCase("true");
            System.out.println(derbyVersionNames[v] + ": " + derbyVerLibs[v] + " " + derbySecurityEnabled[v]);
        }
        derbyLib = new String[derbyVersions][4];
        for (int drbV = 0; drbV < derbyVersions; ++drbV) {
            CompatibilityCombinations.derbyLib[drbV][0] = derbyVerLibs[drbV] + PS + "derby.jar";
            CompatibilityCombinations.derbyLib[drbV][1] = derbyVerLibs[drbV] + PS + "derbyclient.jar";
            CompatibilityCombinations.derbyLib[drbV][3] = derbyVerLibs[drbV] + PS + "derbyTesting.jar";
            CompatibilityCombinations.derbyLib[drbV][2] = derbyVerLibs[drbV] + PS + "derbynet.jar";
        }
        db2jcc_lib = cp.getProperty("db2jcc_lib");
        System.out.println("db2jcc_lib: " + db2jcc_lib);
        CLIENT_DB2JCC = db2jcc_lib + PS + "db2jcc.jar" + ":" + db2jcc_lib + PS + "db2jcc_license_c.jar";
        junit_jar = cp.getProperty("junit_jar");
        System.out.println("junit_jar: " + junit_jar);
        jce_jar = cp.getProperty("jce_jar");
        System.out.println("jce_jar: " + jce_jar);
        jdbc2_0_stdext_jar = cp.getProperty("jdbc2_0_stdext_jar");
        System.out.println("jdbc2_0_stdext_jar: " + jdbc2_0_stdext_jar);
        int currentTestVersion = derbyVerLibs.length - 1;
        String derbyTestingJar = derbyVerLibs[currentTestVersion] + PS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        test_jars = derbyTestingJar + ":" + junit_jar + ":" + jce_jar;
        System.out.println("test_jars: " + test_jars);
        System.out.println("--------------------------------------------------------");
    }

    private void startServer(int serverVM, int serverVersion) throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ StartServer");
        CompatibilityCombinations.DEBUG("startServer: " + serverVersion + " / " + serverVM);
        CompatibilityCombinations.DEBUG("startServer: " + derbyVersionNames[serverVersion] + " on " + VM_Ids[serverVM]);
        String serverJvm = VM_Ids[serverVM] + JVMloc;
        String serverClassPath = derbyVerLibs[serverVersion] + PS + "derby.jar" + ":" + derbyVerLibs[serverVersion] + PS + "derbynet.jar" + ":" + test_jars;
        String command = "start";
        String allowedClients = "0.0.0.0";
        String securityOption = "";
        if (securityProperty.length() != 0 && derbySecurityEnabled[serverVersion]) {
            securityOption = "-" + securityProperty;
        }
        String[] commandElements = new String[]{serverJvm, " -Dderby.infolog.append=true", " -cp ", serverClassPath, " org.apache.derby.drda.NetworkServerControl", " " + command, " -h ", allowedClients, " -p ", serverPort + "", " " + securityOption};
        final String[] envElements = new String[]{"CLASS_PATH=" + serverClassPath, "PATH=" + VM_Ids[serverVM] + PS + ".." + PS + "bin"};
        String workingDirName = System.getProperty("user.dir");
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        CompatibilityCombinations.DEBUG("commandElements: " + tmp);
        final String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp);
        final File workingDir = new File(workingDirName);
        if (!serverHost.equalsIgnoreCase("localhost")) {
            throw new UnsupportedOperationException("Starting server on non-local host Not yet implemented");
        }
        CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(commandElements,envElements,workingDir);");
        Thread serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    CompatibilityCombinations.DEBUG("************** In run().");
                    CompatibilityCombinations.this.serverProc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
                    CompatibilityCombinations.DEBUG("************** Done exec().");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        CompatibilityCombinations.DEBUG("************** Do .start().");
        serverThread.start();
        this.pingServer(1, envElements);
        serverThread.join();
        CompatibilityCombinations.DEBUG("************** Done .join().");
        CompatibilityCombinations.DEBUG("--- StartServer");
        CompatibilityCombinations.DEBUG("");
    }

    private void recreateDB(int serverVersion, String clientJvm, String clientClassPath, boolean debug, String databaseName, boolean removeDBfiles) {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ recreateDB");
        String creator = compatibilityTestSuite + "$Creator";
        String securityOption = "";
        if (securityProperty.length() != 0 && derbySecurityEnabled[serverVersion]) {
            securityOption = "-" + securityProperty;
        }
        String[] commandElements = new String[]{clientJvm, " -Ddrb.tests.debug=true", " -Dderby.tests.trace=true", " -cp ", clientClassPath, " " + creator, " " + databaseName, " " + securityOption};
        String[] envElements = new String[]{"CLASS_PATH=" + clientClassPath};
        String workingDirName = System.getProperty("user.dir");
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName);
        String fullPath = workingDirName + PS + databaseName;
        if (removeDBfiles) {
            CompatibilityCombinations.DEBUG("Deleting database dir '" + fullPath + "'");
            BaseTestCase.removeDirectory(fullPath);
        } else {
            CompatibilityCombinations.DEBUG("Keeping database dir '" + fullPath + "'");
        }
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        String fullCmd = tmp;
        CompatibilityCombinations.DEBUG("commandElements: " + fullCmd);
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp);
        File workingDir = new File(workingDirName);
        CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(fullCmd,envElements,workingDir);");
        try {
            Process proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
            CompatibilityCombinations.processDEBUGOutput(proc);
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CompatibilityCombinations.DEBUG("--- recreateDB");
        CompatibilityCombinations.DEBUG("");
    }

    private void pingServer(int iterations, String[] serverEnvironment) throws Exception {
        CompatibilityCombinations.DEBUG("+++ pingServer");
        this.ping(new NetworkServerControl(), iterations, serverEnvironment);
        CompatibilityCombinations.DEBUG("--- pingServer");
    }

    private void ping(NetworkServerControl controller, int iterations, String[] serverEnvironment) throws Exception {
        Object finalException = null;
        for (int i = 0; i < iterations; ++i) {
            Thread.sleep(SLEEP_TIME_MILLIS);
        }
    }

    private void stopServer(int serverVM, int serverVersion) {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ stopServer");
        CompatibilityCombinations.DEBUG("stopServer: " + serverVersion + " / " + serverVM);
        CompatibilityCombinations.DEBUG("stopServer: " + derbyVersionNames[serverVersion] + " on " + VM_Ids[serverVM]);
        String serverJvm = VM_Ids[serverVM] + JVMloc;
        String serverClassPath = derbyVerLibs[serverVersion] + PS + "derby.jar" + ":" + derbyVerLibs[serverVersion] + PS + "derbynet.jar" + ":" + test_jars;
        String command = "shutdown";
        int port = serverPort;
        String[] commandElements = new String[]{serverJvm, " -Dderby.infolog.append=true", " -cp ", serverClassPath, " org.apache.derby.drda.NetworkServerControl", " " + command, " -p ", serverPort + ""};
        String[] envElements = new String[]{"CLASS_PATH=" + serverClassPath, "PATH=" + VM_Ids[serverVM] + PS + ".." + PS + "bin"};
        String workingDirName = System.getProperty("user.dir");
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        CompatibilityCombinations.DEBUG("commandElements: " + tmp);
        String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp);
        File workingDir = new File(workingDirName);
        if (serverHost.equalsIgnoreCase("localhost")) {
            CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(fullCmd,envElements,workingDir);");
            try {
                Process proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
                CompatibilityCombinations.processDEBUGOutput(proc);
                proc.waitFor();
                this.serverProc.waitFor();
                this.serverProc = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            throw new UnsupportedOperationException("Starting server on non-local host Not yet implemented");
        }
        CompatibilityCombinations.DEBUG("--- stopServer");
        CompatibilityCombinations.DEBUG("");
    }

    private void sysinfoServerFromClient(int clientVM, int clientVersion, String combinationName) throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ sysinfoServerFromClient ++++++++++++++++++++++++++++++++++++++");
        CompatibilityCombinations.DEBUG("    sysinfoServerFromClient: " + clientVersion + " / " + clientVM);
        CompatibilityCombinations.DEBUG("    sysinfoServerFromClient: " + derbyVersionNames[clientVersion] + " on " + VM_Ids[clientVM]);
        String clientJvm = VM_Ids[clientVM] + JVMloc;
        String clientClassPath = derbyVerLibs[clientVersion] + PS + "derby.jar" + ":" + derbyVerLibs[clientVersion] + PS + "derbynet.jar" + ":" + test_jars;
        String command = "sysinfo";
        int port = serverPort;
        String[] commandElements = new String[]{clientJvm, " -Dderby.infolog.append=true", " -cp ", clientClassPath, " org.apache.derby.drda.NetworkServerControl", " " + command, " -h ", serverHost, " -p ", serverPort + ""};
        String[] envElements = new String[]{"CLASS_PATH=" + clientClassPath, "PATH=" + VM_Ids[clientVM] + PS + ".." + PS + "bin"};
        String workingDirName = System.getProperty("user.dir");
        PrintWriter out = new PrintWriter(new FileWriter(workingDirName + PS + combinationName + ".sys"));
        CompatibilityCombinations.DEBUG(combinationName + " sys:", out);
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName, out);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        CompatibilityCombinations.DEBUG("commandElements: " + tmp, out);
        String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp, out);
        File workingDir = new File(workingDirName);
        CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(fullCmd,envElements,workingDir);");
        try {
            Process proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
            CompatibilityCombinations.processOutput(proc, out);
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.close();
        CompatibilityCombinations.DEBUG("--- sysinfoServerFromClient --------------------------------------");
        CompatibilityCombinations.DEBUG("");
    }

    private void sysinfoEmbedded(int clientVM, int clientVersion, String combinationName) throws Exception {
        CompatibilityCombinations.DEBUG("");
        CompatibilityCombinations.DEBUG("+++ sysinfoEmbedded ++++++++++++++++++++++++++++++++++++++");
        CompatibilityCombinations.DEBUG("    sysinfoEmbedded: " + clientVersion + " / " + clientVM);
        CompatibilityCombinations.DEBUG("    sysinfoEmbedded: " + derbyVersionNames[clientVersion] + " on " + VM_Ids[clientVM]);
        String clientJvm = VM_Ids[clientVM] + JVMloc;
        String clientClassPath = derbyVerLibs[clientVersion] + PS + "derby.jar" + ":" + derbyVerLibs[clientVersion] + PS + "derbynet.jar";
        String[] commandElements = new String[]{clientJvm, " -Dderby.infolog.append=true", " -cp ", clientClassPath, " org.apache.derby.tools.sysinfo"};
        String[] envElements = new String[]{"CLASS_PATH=" + clientClassPath, "PATH=" + VM_Ids[clientVM] + PS + ".." + PS + "bin"};
        String workingDirName = System.getProperty("user.dir");
        PrintWriter out = new PrintWriter(new FileWriter(workingDirName + PS + combinationName + ".sys"));
        CompatibilityCombinations.DEBUG(combinationName + " sys:", out);
        CompatibilityCombinations.DEBUG("user.dir: " + workingDirName, out);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        CompatibilityCombinations.DEBUG("commandElements: " + tmp, out);
        String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        CompatibilityCombinations.DEBUG("envElements: " + tmp, out);
        File workingDir = new File(workingDirName);
        CompatibilityCombinations.DEBUG("proc = Runtime.getRuntime().exec(fullCmd,envElements,workingDir);");
        try {
            Process proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
            CompatibilityCombinations.processOutput(proc, out);
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.close();
        CompatibilityCombinations.DEBUG("+++ sysinfoEmbedded ++++++++++++++++++++++++++++++++++++++");
        CompatibilityCombinations.DEBUG("");
    }

    private static void processOutput(Process proc, PrintWriter out) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        CompatibilityCombinations.DEBUG("---- out:", out);
        while ((line = bir.readLine()) != null) {
            out.println(line);
        }
        CompatibilityCombinations.DEBUG("---- err:", out);
        while ((line = ber.readLine()) != null) {
            out.println(line);
        }
    }

    private static void processDEBUGOutput(Process proc) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        CompatibilityCombinations.DEBUG("---- out:");
        while ((line = bir.readLine()) != null) {
            CompatibilityCombinations.DEBUG(line);
        }
        CompatibilityCombinations.DEBUG("---- err:");
        while ((line = ber.readLine()) != null) {
            CompatibilityCombinations.DEBUG(line);
        }
    }

    private static void DEBUG(String s) {
        if (printDebug) {
            System.out.println(s);
        }
    }

    private static void DEBUG(String s, PrintWriter out) {
        if (printDebug) {
            out.println(s);
        }
    }
}

