/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.Connection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DBOAccessTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};
    private static final String TEST_LOG_FILE = "sys_vti_test_derby.tstlog";

    public DBOAccessTest(String name) {
        super(name);
    }

    public boolean authorizationIsOn() {
        return true;
    }

    public static Test suite() {
        String[] testFiles = new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"};
        Object authorizedRun = TestConfiguration.embeddedSuite(DBOAccessTest.class);
        authorizedRun = DatabasePropertyTestSetup.builtinAuthentication(authorizedRun, LEGAL_USERS, "authorizationOnDBOAccessTest");
        authorizedRun = new SupportFilesSetup((Test)authorizedRun, testFiles);
        authorizedRun = TestConfiguration.sqlAuthorizationDecorator(authorizedRun);
        Object unauthorizedRun = TestConfiguration.embeddedSuite(NoAuthorization.class);
        unauthorizedRun = new SupportFilesSetup((Test)unauthorizedRun, testFiles);
        TestSuite suite = new TestSuite();
        suite.addTest(authorizedRun);
        suite.addTest(unauthorizedRun);
        return suite;
    }

    public void test_5395() throws Exception {
        DBOAccessTest.println("authorizationIsOn() = " + this.authorizationIsOn());
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.minion_5395(dboConnection, true);
        this.minion_5395(janetConnection, !this.authorizationIsOn());
    }

    private void minion_5395(Connection conn, boolean shouldSucceed) throws Exception {
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.statement_cache");
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.transaction_table");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration() ) s");
        URL logURL = SupportFilesSetup.getReadOnlyURL(TEST_LOG_FILE);
        String vtiArg = "'" + logURL.getFile() + "'";
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( " + vtiArg + " ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration( " + vtiArg + " ) ) s");
    }

    private void vet_5395(Connection conn, boolean shouldSucceed, String query) throws Exception {
        if (shouldSucceed) {
            this.goodStatement(conn, query);
        } else {
            this.expectCompilationError(conn, "4251D", query);
        }
    }

    public static final class NoAuthorization
    extends DBOAccessTest {
        public NoAuthorization(String name) {
            super(name);
        }

        public boolean authorizationIsOn() {
            return false;
        }
    }
}

