/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeclareGlobalTempTableJavaTest
extends BaseJDBCTestCase {
    public DeclareGlobalTempTableJavaTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(DeclareGlobalTempTableJavaTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dropSchemaTables();
        this.getConnection().setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDerby1706() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("drop schema SESSION restrict");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42Y07", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "set schema SESSION");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "create table DERBY1706(c11 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop table DERBY1706");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "set schema APP");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop schema SESSION restrict");
    }

    public void testGTTSchemaName() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "set schema APP");
        DeclareGlobalTempTableJavaTest.assertStatementError("428EK", s, "DECLARE GLOBAL TEMPORARY TABLE APP.t2(c21 int) on commit delete rows not logged");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "insert into APP.t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "insert into t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", s, "drop table t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop table SESSION.t2");
    }

    public void testPositiveGrammars() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tA(c1 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tB(c1 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tC(c1 int) not logged on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tD(c1 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tE(c1 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tF(c1 int) on rollback delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tG(c1 int) not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tH(c1 int) on commit preserve rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tI(c1 int) not logged on commit preserve rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tJ(c1 int) not logged on rollback delete rows on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tK(c1 int) on commit delete rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tL(c1 int) not logged on commit delete rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE tM(c1 int) not logged on rollback delete rows on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tA");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tB");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tC");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tD");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tE");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tF");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tG");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tH");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tI");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tJ");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tK");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tL");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.tM");
    }

    public void testNegativeGrammars() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X01", s, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", s, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED NOT LOGGED");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", s, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED ON COMMIT PRESERVE ROWS ON COMMIT DELETE ROWS");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", s, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED ON ROLLBACK DELETE ROWS ON ROLLBACK DELETE ROWS");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X01", s, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) ON ROLLBACK DELETE ROWS ON COMMIT PRESERVE ROWS");
    }

    public void testFeaturesNotAllowedOnGTTs() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "ALTER TABLE SESSION.t2 add column c22 int");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "LOCK TABLE SESSION.t2 IN SHARE MODE");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "RENAME TABLE SESSION.t2 TO t3");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "CREATE index t2i1 on SESSION.t2 (c21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("XCL51", s, "CREATE VIEW t2v1 as select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int generated always as identity) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 blob(3k)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 clob(3k)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 long varchar) on commit delete rows not logged");
        s.executeUpdate("DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", s, "DROP TABLE SESSION.t1");
    }

    public void testFeaturesAllowedOnPhysicalTablesOfSESSIONSchema() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE SESSION.t2(c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "ALTER TABLE SESSION.t2 add column c22 int");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "LOCK TABLE SESSION.t2 IN EXCLUSIVE MODE");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "RENAME TABLE SESSION.t2 TO t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "RENAME COLUMN SESSION.t3.c21 TO c23");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE SESSION.t2 (c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE index t2i1 on SESSION.t2 (c21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("XCL51", s, "CREATE VIEW t2v1 as select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t3");
    }

    public void testConstraintsNotAllowedOnGTTs() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int not null, constraint pk primary key (c21)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int not null unique) on commit delete rows not logged");
        s.executeUpdate("CREATE TABLE t1(c11 int not null unique)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int references t1(c11)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int check (c21 > 0)) on commit delete rows not logged");
        s.executeUpdate("DROP TABLE t1");
    }

    public void testConstraintsAllowedOnSESSIONPhysicalTables() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        s.executeUpdate("CREATE TABLE SESSION.t1(c21 int not null, constraint pk primary key (c21))");
        s.executeUpdate("CREATE TABLE SESSION.t2(c21 int not null unique)");
        s.executeUpdate("CREATE TABLE SESSION.t3(c21 int check (c21 > 0))");
        s.executeUpdate("CREATE TABLE t4(c11 int not null unique)");
        s.executeUpdate("CREATE TABLE SESSION.t5(c21 int references t4(c11))");
        s.executeUpdate("DROP TABLE SESSION.t1");
        s.executeUpdate("DROP TABLE SESSION.t2");
        s.executeUpdate("DROP TABLE SESSION.t3");
        s.executeUpdate("DROP TABLE SESSION.t5");
        s.executeUpdate("DROP TABLE t4");
    }

    public void testOnCommiDeleteRowsWithAndWithoutOpenCursors() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(22, 22)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(23, 23)");
        ResultSet rs2 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs2, "2");
        rs2 = s.executeQuery("select * from SESSION.t2");
        rs2.next();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t3 values(32, 32)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t3 values(33, 33)");
        ResultSet rs3 = s.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(rs3, "2");
        this.commit();
        rs2 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs2, "0");
        rs3 = s.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(rs3, "0");
        s.executeUpdate("DROP TABLE SESSION.t2");
        s.executeUpdate("DROP TABLE SESSION.t3");
    }

    public void testOnCommitPreserveRowsWithAndWithoutOpenCursors() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.t2 values(22, 22)");
        s.executeUpdate("insert into SESSION.t2 values(23, 23)");
        ResultSet rs2 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs2, "2");
        rs2 = s.executeQuery("select * from SESSION.t2");
        rs2.next();
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.t3 values(32, 32)");
        s.executeUpdate("insert into SESSION.t3 values(33, 33)");
        ResultSet rs3 = s.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(rs3, "2");
        this.commit();
        rs2 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs2, "2");
        rs3 = s.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(rs3, "2");
        s.executeUpdate("DROP TABLE SESSION.t2");
        s.executeUpdate("DROP TABLE SESSION.t3");
    }

    public void testDuplicateAndNullGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("X0Y32", s, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", s, "DROP TABLE SESSION.t2");
    }

    public void testInsertOnGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 char(2)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values (1, 'aa')");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 3, "insert into SESSION.t2 values (2, 'bb'),(3, 'cc'),(4, null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE t1(c11 int, c22 char(2))");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 3, "insert into t1 values (5, null),(6, null),(7, 'gg')");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 3, "insert into SESSION.t2 (select * from t1 where c11>4)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 7, "insert into SESSION.t2 select * from SESSION.t2");
        ResultSet rs1 = s.executeQuery("select sum(c21) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "56");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c21 int, c22 char(2) not null) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t3 values (1, 'aa')");
        DeclareGlobalTempTableJavaTest.assertStatementError("23502", s, "insert into SESSION.t3 values (2, null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c21 int, c22 char(2) default 'aa', c23 varchar(20) default user ) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t4 values (1, 'aa', null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t4(c21) values (2)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t4");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE t1");
    }

    public void testDeleteOnGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 decimal) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(1, 1.1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(2, 2.2)");
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 2, "DELETE FROM SESSION.t2 where c21 > 0");
        rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testUpdateOnGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(1, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(2, 1)");
        ResultSet rs2 = s.executeQuery("select count(*) from SESSION.t2 where c22 = 1");
        JDBC.assertSingleValueResultSet(rs2, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 2, "UPDATE SESSION.t2 SET c22 = 2 where c21>0");
        rs2 = s.executeQuery("select count(*) from SESSION.t2 where c22 = 1");
        JDBC.assertSingleValueResultSet(rs2, "0");
        rs2 = s.executeQuery("select count(*) from SESSION.t2 where c22 = 2");
        JDBC.assertSingleValueResultSet(rs2, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testSESSIONschema() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP SCHEMA SESSION restrict");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y07", s, "DROP SCHEMA SESSION restrict");
    }

    public void testCreateView() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE t2 (c28 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 2, "INSERT INTO t2 VALUES (280),(281)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE VIEW SESSION.t2v1 as select * from t2");
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2v1");
        JDBC.assertSingleValueResultSet(rs1, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP VIEW SESSION.t2v1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE t2");
    }

    public void testStatementCaching() throws SQLException {
        Statement s = this.createStatement();
        this.getConnection().setAutoCommit(true);
        try {
            s.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE SESSION.t2 (c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "INSERT into SESSION.t2 values(21)");
        this.getConnection().setAutoCommit(false);
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "INSERT into SESSION.t2 values(22, 22)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "INSERT into SESSION.t2 values(23, 23)");
        rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop schema SESSION restrict");
    }

    public void testSESSIONQualifier() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(21, 21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "insert into t2 values(23, 23)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(22, 22)");
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        try {
            s.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        s.executeUpdate("SET SCHEMA SESSION");
        rs1 = s.executeQuery("select count(*) from t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "SET SCHEMA APP");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop schema SESSION restrict");
    }

    public void testOneGTTInConnection() throws SQLException {
        Statement s1 = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s1, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s1, 1, "insert into SESSION.t2 values(22, 22)");
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s2, "select count(*) from SESSION.t2");
        s2.close();
        con2.close();
    }

    public void testSameGTTNameForTwoConnections() throws SQLException {
        Statement s1 = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s1, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s1, 1, "insert into SESSION.t2 values(22, 22)");
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s2, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s2, 1, "insert into SESSION.t2 values(99)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s1, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s2, 0, "DROP TABLE SESSION.t2");
        s2.close();
        con2.close();
    }

    public void testPreparedStatement1() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmt.setInt(1, 21);
        pStmt.setInt(2, 1);
        pStmt.execute();
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        try {
            pStmt.setInt(1, 22);
            pStmt.setInt(2, 2);
            pStmt.execute();
            DeclareGlobalTempTableJavaTest.fail((String)" Table/View 'SESSION.T2' does not exist:");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42X05", e);
        }
    }

    public void testPreparedStatement2() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmt.setInt(1, 21);
        pStmt.setInt(2, 1);
        pStmt.execute();
        pStmt.close();
        ResultSet rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        ResultSetMetaData rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rsmd.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int) not logged");
        pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ? , ?)");
        pStmt.setInt(1, 22);
        pStmt.setInt(2, 2);
        pStmt.setNull(3, 4);
        pStmt.execute();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)3, (int)rsmd.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int, c24 int not null) not logged");
        pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ? , ? , ?)");
        try {
            pStmt.setInt(1, 22);
            pStmt.setInt(2, 2);
            pStmt.setNull(3, 4);
            pStmt.setNull(4, 4);
            pStmt.execute();
            DeclareGlobalTempTableJavaTest.fail((String)"trying to Insert a null value into non null column:");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("23502", e);
        }
    }

    public void testTempTableDDLRollbackbehaviour1() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        s.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t1");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t1");
    }

    public void testTempTableDDLRollbackbehaviour2() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        this.commit();
        s.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t1");
        this.rollback();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
    }

    public void testTempTableDDLRollbackbehaviour3() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        this.commit();
        s.executeUpdate("drop table SESSION.t1");
        this.commit();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t1");
    }

    public void testTempTableDDLRollbackbehaviour4() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t1");
    }

    public void testRollbackBehavior1() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmt.setInt(1, 21);
        pStmt.setInt(2, 1);
        pStmt.execute();
        pStmt.close();
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "1");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t2");
    }

    public void testRollbackBehavior2() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmt.setInt(1, 21);
        pStmt.setInt(2, 1);
        pStmt.execute();
        pStmt.close();
        this.commit();
        s.executeUpdate("DROP TABLE SESSION.t2");
        this.rollback();
        ResultSet rs2 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs2, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        this.commit();
    }

    public void testRollbackBehavior3() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into session.t2 values(1,1,1)");
        ResultSet rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        ResultSetMetaData rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)3, (int)rsmd.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into session.t2 values(1,1)");
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rsmd.getColumnCount());
        this.commit();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into session.t2 values(1)");
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rsmd.getColumnCount());
        rs1.close();
        this.rollback();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        rsmd = rs1.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rsmd.getColumnCount());
        rs1.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testRollbackBehavior4() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) not logged on commit preserve rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) not logged on rollback delete rows on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t5(c51 int, c52 int) on commit preserve rows not logged");
        s.executeUpdate("insert into session.t2 values(21,1)");
        s.executeUpdate("insert into session.t2 values(22,2)");
        s.executeUpdate("insert into session.t2 values(23,3)");
        s.executeUpdate("insert into session.t3 values(31,1)");
        s.executeUpdate("insert into session.t3 values(32,2)");
        s.executeUpdate("insert into session.t3 values(33,3)");
        s.executeUpdate("insert into session.t4 values(41,1)");
        s.executeUpdate("insert into session.t4 values(42,2)");
        s.executeUpdate("insert into session.t4 values(43,3)");
        s.executeUpdate("insert into session.t5 values(51,1)");
        s.executeUpdate("insert into session.t5 values(52,2)");
        s.executeUpdate("insert into session.t5 values(53,3)");
        this.commit();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t6(c61 int, c62 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("insert into session.t6 values(61,1)");
        s.executeUpdate("insert into session.t6 values(62,2)");
        s.executeUpdate("insert into session.t6 values(63,3)");
        s.executeUpdate("DELETE FROM session.t2 WHERE c22> (select c52 from session.t5 where c52=2)");
        s.executeUpdate("DELETE FROM session.t3 WHERE c32>3");
        this.rollback();
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "0");
        rs1 = s.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(rs1, "0");
        rs1 = s.executeQuery("select count(*) from SESSION.t4");
        JDBC.assertSingleValueResultSet(rs1, "3");
        rs1 = s.executeQuery("select count(*) from SESSION.t5");
        JDBC.assertSingleValueResultSet(rs1, "3");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", s, "select * from SESSION.t6");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t4");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t5");
    }

    public void testEntryForSESSIONTablesToSysCatalog() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        ResultSet rs1 = s.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) like 'T2'");
        JDBC.assertSingleValueResultSet(rs1, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        try {
            s.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE SESSION.t2(c21 int, c22 int)");
        rs1 = s.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) like 'T2'");
        JDBC.assertSingleValueResultSet(rs1, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop schema SESSION restrict");
    }

    public void testEntryForSEESSIONtoSysCatalog() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("drop schema SESSION restrict");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42Y07", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        ResultSet rs1 = s.executeQuery("select count(schemaname) from sys.sysschemas where CAST(schemaname AS VARCHAR(128)) like 'SESSION'");
        JDBC.assertSingleValueResultSet(rs1, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testDatabaseMetadata() throws SQLException {
        Statement s = this.createStatement();
        int count = 0;
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        try {
            s.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", e);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "CREATE TABLE SESSION.t3(c31 int, c32 int)");
        ResultSet rs1 = databaseMetaData.getTables("", null, "%", null);
        while (rs1.next()) {
            if ("T2" == rs1.getString(3) && "SESSION" == rs1.getString(2)) {
                DeclareGlobalTempTableJavaTest.fail((String)"Temporary table Found");
            }
            ++count;
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "drop schema SESSION restrict");
    }

    public void testDeleteWhereCurrentOfOnGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(21, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(22, 1)");
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        PreparedStatement pStmt1 = this.prepareStatement("select c21 from session.t2 for update");
        ResultSet rs2 = pStmt1.executeQuery();
        rs2.next();
        PreparedStatement pStmt2 = this.prepareStatement("delete from session.t2 where current of " + rs2.getCursorName());
        pStmt2.executeUpdate();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rs1.getInt(2));
        rs2.next();
        pStmt2.executeUpdate();
        rs1 = s.executeQuery("select count(*) from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)0, (int)rs1.getInt(1));
        rs2.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void UpdateWhereCurrentOfOnGTT() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(21, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "insert into SESSION.t2 values(22, 1)");
        ResultSet rs1 = s.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(rs1, "2");
        PreparedStatement pStmt1 = this.prepareStatement("select c21 from session.t2 for update");
        ResultSet rs2 = pStmt1.executeQuery();
        rs2.next();
        PreparedStatement pStmt2 = this.prepareStatement("update session.t2 set c22 = 2 where current of " + rs2.getCursorName());
        pStmt2.executeUpdate();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rs1.getInt(2));
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rs1.getInt(2));
        rs2.next();
        pStmt2.executeUpdate();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rs1.getInt(2));
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)rs1.getInt(2));
        rs2.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testDMLRollback1() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmt.setInt(1, 21);
        pStmt.setInt(2, 1);
        pStmt.execute();
        this.commit();
        ResultSet rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rs1.getInt(2));
        pStmt.setInt(1, 22);
        pStmt.setInt(2, 2);
        pStmt.execute();
        this.rollback();
        rs1 = s.executeQuery("select count(*) from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)0, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void testDMLRollback2() throws SQLException {
        Statement s = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 1, "INSERT INTO SESSION.t2 VALUES(21, 1)");
        this.commit();
        ResultSet rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rs1.getInt(2));
        this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        this.rollback();
        rs1 = s.executeQuery("select * from SESSION.t2");
        rs1.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)rs1.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)rs1.getInt(2));
        DeclareGlobalTempTableJavaTest.assertUpdateCount(s, 0, "DROP TABLE SESSION.t2");
    }

    public void dropSchemaTables() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("DROP TABLE SESSION.t1");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("DROP TABLE SESSION.t2");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("DROP TABLE SESSION.t3");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("DROP TABLE SESSION.t4");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("DROP TABLE SESSION.t5");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

