/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TruncateTableTest
extends BaseJDBCTestCase {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "RUTH", "ALICE"};
    private static final String UNAUTHORIZED_OPERATION = "42507";

    public TruncateTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test cleanTest = TestConfiguration.defaultSuite(TruncateTableTest.class);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication(cleanTest, LEGAL_USERS, "");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void testTruncateWithIndex() throws SQLException {
        Connection aliceConnection = this.openUserConnection(ALICE);
        Statement st = aliceConnection.createStatement();
        st.executeUpdate("create table t1(a int not null generated always as identity primary key, b varchar(100))");
        st.executeUpdate("insert into t1(b) values('one'),('two'),('three'),('four'),('five')");
        ResultSet rs = st.executeQuery("select * from t1 order by a");
        String[][] expRS = new String[][]{{"1", "one"}, {"2", "two"}, {"3", "three"}, {"4", "four"}, {"5", "five"}};
        JDBC.assertFullResultSet(rs, expRS);
        st.executeUpdate("truncate table t1");
        JDBC.assertEmpty(st.executeQuery("select * from t1"));
        st.executeUpdate("insert into t1(b) values('six'),('seven')");
        rs = st.executeQuery("select * from t1 order by a");
        expRS = new String[][]{{"6", "six"}, {"7", "seven"}};
        JDBC.assertFullResultSet(rs, expRS);
        st.close();
        aliceConnection.close();
    }

    public void testTruncateWithDeleteTrigger() throws Exception {
        Connection aliceConnection = this.openUserConnection(ALICE);
        Statement s = aliceConnection.createStatement();
        s.execute("create table deltriggertest_t1(x int)");
        s.execute("create table deltriggertest_t2(y int)");
        s.execute("create trigger deltriggertest_tr after delete on deltriggertest_t1 referencing old as old for each row insert into deltriggertest_t2 values old.x");
        PreparedStatement checkDest = aliceConnection.prepareStatement("select count(*) from deltriggertest_t2");
        s.execute("insert into deltriggertest_t1 values 1,2,3");
        JDBC.assertSingleValueResultSet(checkDest.executeQuery(), "0");
        TruncateTableTest.assertUpdateCount(s, 3, "delete from deltriggertest_t1");
        JDBC.assertSingleValueResultSet(checkDest.executeQuery(), "3");
        s.execute("insert into deltriggertest_t1 values 4,5");
        TruncateTableTest.assertStatementError("XCL49", s, "truncate table deltriggertest_t1");
        JDBC.assertSingleValueResultSet(checkDest.executeQuery(), "3");
    }

    public void testTruncateWithForeignKey() throws SQLException {
        Connection aliceConnection = this.openUserConnection(ALICE);
        Statement s = aliceConnection.createStatement();
        s.execute("create table foreignkey_t1(x int primary key)");
        s.execute("create table foreignkey_t2(y int references foreignkey_t1)");
        s.execute("insert into foreignkey_t1 values 1,2");
        s.execute("insert into foreignkey_t2 values 2");
        TruncateTableTest.assertStatementError("XCL48", s, "truncate table foreignkey_t1");
        s.execute("truncate table foreignkey_t2");
        JDBC.assertEmpty(s.executeQuery("select * from foreignkey_t2"));
    }

    public void testSelfReferencing() throws SQLException {
        Connection aliceConnection = this.openUserConnection(ALICE);
        Statement s = aliceConnection.createStatement();
        try {
            s.execute("CREATE SCHEMA ALICE");
        }
        catch (SQLException sqle) {
            TruncateTableTest.assertSQLState("X0Y68", sqle);
        }
        s.execute("create table self_referencing_t1(x int primary key, y int references self_referencing_t1)");
        s.execute("insert into self_referencing_t1 values (1, null), (2, 1)");
        s.execute("truncate table self_referencing_t1");
        JDBC.assertEmpty(s.executeQuery("select * from self_referencing_t1"));
    }

    public void testPerms() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection aliceConnection = this.openUserConnection(ALICE);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Statement dboStatement = dboConnection.createStatement();
        Statement aliceStatement = aliceConnection.createStatement();
        Statement ruthStatement = ruthConnection.createStatement();
        aliceStatement.execute("create table t_perm( a int )");
        aliceStatement.execute("grant delete on t_perm to public");
        aliceStatement.execute("grant select on t_perm to public");
        aliceStatement.execute("insert into t_perm( a ) values ( 1 )");
        aliceStatement.execute("truncate table t_perm");
        JDBC.assertEmpty(aliceStatement.executeQuery("select * from t_perm"));
        aliceStatement.execute("insert into t_perm( a ) values ( 2 )");
        TruncateTableTest.assertStatementError(UNAUTHORIZED_OPERATION, ruthStatement, "truncate table alice.t_perm");
        JDBC.assertFullResultSet(ruthStatement.executeQuery("select * from alice.t_perm"), new String[][]{{"2"}});
        ruthStatement.execute("delete from alice.t_perm");
        JDBC.assertEmpty(ruthStatement.executeQuery("select * from alice.t_perm"));
        aliceStatement.execute("insert into t_perm( a ) values ( 3 )");
        JDBC.assertFullResultSet(aliceStatement.executeQuery("select * from alice.t_perm"), new String[][]{{"3"}});
        dboStatement.execute("truncate table alice.t_perm");
        JDBC.assertEmpty(dboStatement.executeQuery("select * from alice.t_perm"));
        dboStatement.close();
        aliceStatement.close();
        ruthStatement.close();
        dboConnection.close();
        aliceConnection.close();
        ruthConnection.close();
    }

    public void testCursor() throws Exception {
        Connection cursorConnection = this.openUserConnection(ALICE);
        Connection truncatorConnection = this.openUserConnection(ALICE);
        cursorConnection.setAutoCommit(false);
        truncatorConnection.setAutoCommit(false);
        this.cursorMinion(cursorConnection, truncatorConnection, "truncateTab", "truncate table ");
        this.cursorMinion(cursorConnection, truncatorConnection, "dropTab", "drop table ");
        cursorConnection.close();
    }

    private void cursorMinion(Connection cursorConnection, Connection truncatorConnection, String tableName, String truncationStub) throws Exception {
        Statement ddlStatement = cursorConnection.createStatement();
        Statement truncatorStatement = truncatorConnection.createStatement();
        ddlStatement.execute("create table " + tableName + "( a int )");
        ddlStatement.execute("insert into " + tableName + "( a ) values ( 1 ), ( 2 )");
        ddlStatement.close();
        cursorConnection.commit();
        Statement cursorStatement = cursorConnection.createStatement(1005, 1007, 1);
        ResultSet cursor = cursorStatement.executeQuery("select * from " + tableName);
        cursor.next();
        TruncateTableTest.assertEquals((int)1, (int)cursor.getInt(1));
        cursorConnection.commit();
        truncatorStatement.execute(truncationStub + tableName);
        truncatorConnection.commit();
        cursor.next();
        TruncateTableTest.assertEquals((int)2, (int)cursor.getInt(1));
        TruncateTableTest.assertFalse((boolean)cursor.next());
        cursor.close();
        cursorConnection.commit();
        cursorStatement.close();
        truncatorStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInvalidation() throws Exception {
        Statement s = this.createStatement();
        s.execute("create table d4275(x int)");
        final List<Boolean> stop = Collections.synchronizedList(new ArrayList());
        final Throwable[] error = new Throwable[1];
        Connection c2 = this.openDefaultConnection();
        final PreparedStatement ps = c2.prepareStatement("select * from d4275");
        Thread t = new Thread(){

            public void run() {
                try {
                    while (stop.isEmpty()) {
                        JDBC.assertEmpty(ps.executeQuery());
                    }
                }
                catch (Throwable t) {
                    error[0] = t;
                }
            }
        };
        t.start();
        try {
            for (int i = 0; i < 100; ++i) {
                s.execute("truncate table d4275");
            }
        }
        finally {
            stop.add(Boolean.TRUE);
        }
        t.join();
        if (error[0] != null) {
            TruncateTableTest.fail("Helper thread failed", error[0]);
        }
        ps.close();
        c2.close();
    }
}

