/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.IndexStatsUtil;

public class AutomaticIndexStatisticsMultiTest
extends BaseJDBCTestCase {
    private static final String TAB = "MTSEL";
    private static final int _100K = 100000;

    public AutomaticIndexStatisticsMultiTest(String name) {
        super(name);
    }

    public void testMTSelect() throws Exception {
        int i;
        this.prepareTable(true);
        int threadCount = 5;
        long runTime = 10000L;
        MTCompileThread[] compileThreads = new MTCompileThread[threadCount];
        for (int i2 = 0; i2 < threadCount; ++i2) {
            compileThreads[i2] = new MTCompileThread(this.openDefaultConnection(), runTime);
        }
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(compileThreads[i]);
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join(600000L);
        }
        int total = 0;
        int totalError = 0;
        for (int i3 = 0; i3 < threadCount; ++i3) {
            int count = compileThreads[i3].getCount();
            int errors = compileThreads[i3].getErrorCount();
            total += count;
            totalError += errors;
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + total + " (of which " + totalError + " errors)");
        AutomaticIndexStatisticsMultiTest.assertEquals((int)0, (int)totalError);
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void testMTSelectWithDDL() throws Exception {
        int i;
        this.prepareTable(true);
        int threadCount = 5;
        long runTime = 10000L;
        MTCompileThread[] compileThreads = new MTCompileThread[threadCount];
        for (int i2 = 0; i2 < threadCount; ++i2) {
            compileThreads[i2] = new MTCompileThread(this.openDefaultConnection(), runTime);
        }
        MTCreateDropThread createThread = new MTCreateDropThread(this.openDefaultConnection(), runTime);
        Thread[] threads = new Thread[threadCount + 1];
        threads[0] = new Thread(createThread);
        threads[0].start();
        for (i = 0; i < threadCount; ++i) {
            threads[i + 1] = new Thread(compileThreads[i]);
            threads[i + 1].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join(600000L);
        }
        int total = 0;
        int totalError = 0;
        for (int i3 = 0; i3 < threadCount; ++i3) {
            int count = compileThreads[i3].getCount();
            int errors = compileThreads[i3].getErrorCount();
            total += count;
            totalError += errors;
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + total + " (of which " + totalError + " errors) CREATES = " + createThread.getCreates());
        AutomaticIndexStatisticsMultiTest.assertEquals((int)0, (int)totalError);
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    private void verifyStatistics() throws SQLException {
        IndexStatsUtil stats = new IndexStatsUtil(this.getConnection(), 5000L);
        IndexStatsUtil.IdxStats[] myStats = stats.getStatsTable(TAB, 2);
        block4: for (int i = 0; i < myStats.length; ++i) {
            IndexStatsUtil.IdxStats s = myStats[i];
            AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)s.rows);
            switch (s.lcols) {
                case 1: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)10L, (long)s.card);
                    continue block4;
                }
                case 2: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)s.card);
                    continue block4;
                }
                default: {
                    AutomaticIndexStatisticsMultiTest.fail((String)("unexpected number of leading columns: " + s.lcols));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareTable(boolean dropIfExists) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = this.getConnection().getMetaData().getTables(null, null, TAB, null);
        if (rs.next()) {
            AutomaticIndexStatisticsMultiTest.assertFalse((boolean)rs.next());
            rs.close();
            if (!dropIfExists) {
                AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, reusing");
                return;
            }
            AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, dropping");
            stmt.executeUpdate("drop table MTSEL");
        } else {
            rs.close();
        }
        stmt.executeUpdate("create table MTSEL (val1 int, val2 int)");
        stmt.executeUpdate("create index mtsel_idx on MTSEL (val1, val2)");
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into MTSEL values (?,?)");
        int blockCount = 10;
        int blockSize = 10000;
        int i = 0;
        while (true) {
            if (i >= blockCount) {
                this.setAutoCommit(true);
                return;
            }
            ps.setInt(1, i);
            for (int j = 0; j < blockSize; ++j) {
                ps.setInt(2, j);
                ps.addBatch();
            }
            ps.executeBatch();
            this.commit();
            AutomaticIndexStatisticsMultiTest.println("inserted block " + (i + 1) + "/" + blockCount);
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(AutomaticIndexStatisticsMultiTest.class);
    }

    private static class MTCreateDropThread
    implements Runnable {
        private final Connection con;
        private final long runTime;
        private long creates;

        public MTCreateDropThread(Connection con, long runTime) throws SQLException {
            this.con = con;
            this.runTime = runTime;
        }

        public void run() {
            long started = System.currentTimeMillis();
            try {
                ResultSet rs = this.con.getMetaData().getTables(null, null, "TMPTABLE", null);
                boolean lastWasCreate = rs.next();
                rs.close();
                Statement stmt = this.con.createStatement();
                while (System.currentTimeMillis() - started < this.runTime) {
                    if (lastWasCreate) {
                        stmt.executeUpdate("drop table TMPTABLE");
                    } else {
                        stmt.executeUpdate("create table TMPTABLE(i int primary key, v varchar(30), b blob)");
                        ++this.creates;
                    }
                    lastWasCreate = !lastWasCreate;
                }
            }
            catch (SQLException sqle) {
                Assert.fail((String)("create drop thread crashed: " + sqle.getMessage()));
            }
        }

        public long getCreates() {
            return this.creates;
        }
    }

    private static class MTCompileThread
    implements Runnable {
        private final Random rand = new Random();
        private final Connection con;
        private final long runTime;
        private int count;
        private int errorCount;

        public MTCompileThread(Connection con, long runTime) throws SQLException {
            this.con = con;
            this.runTime = runTime;
        }

        public void run() {
            long started = System.currentTimeMillis();
            int counter = 0;
            while (System.currentTimeMillis() - started < this.runTime) {
                try {
                    this.con.prepareStatement("select * from mtsel where " + ++counter + " = " + counter + " AND val2 = " + (1 + this.rand.nextInt(10)));
                }
                catch (SQLException sqle) {
                    ++this.errorCount;
                }
                ++this.count;
            }
        }

        public int getCount() {
            return this.count;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

