/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedConnection30;
import org.apache.derby.jdbc.Driver30;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RollBackWrappingWhenFailOnImportTest
extends BaseJDBCTestCase {
    private String nonexistentFileName = "test/test.dat";

    public RollBackWrappingWhenFailOnImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RollBackWrappingWhenFailOnImportTest");
        if (!JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(RollBackWrappingWhenFailOnImportTest.class));
        suite.addTest((Test)test);
        return suite;
    }

    protected void setUp() throws Exception {
        this.openDefaultConnection();
        MockInternalDriver dvr = new MockInternalDriver();
        dvr.boot(false, null);
        SupportFilesSetup.deleteFile(this.nonexistentFileName);
    }

    protected void tearDown() throws Exception {
        try {
            this.getTestConfiguration().shutdownEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testRollBackWhenFailOnImportTable() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP', '" + this.nonexistentFileName + "test/test.dat" + "' , null, null, null, 0) ";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportTableLobsFromEXTFile() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'IET1' , '" + this.nonexistentFileName + "', null, null, null, 0)";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportData() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP', null, null, '" + this.nonexistentFileName + "', null, null, null, 1) ";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportDataLobsFromExtFile() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'IET1', null, null, '" + this.nonexistentFileName + "', null, null, null, 1)";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realTestRollBackWhenImportOnNonexistentFile(String importSentence) throws SQLException {
        CallableStatement cSt = this.prepareCall(importSentence);
        try {
            cSt.executeUpdate();
            RollBackWrappingWhenFailOnImportTest.fail((String)"a SQLException should be thrown as we import data from a nonexistent file");
        }
        catch (SQLException e) {
            RollBackWrappingWhenFailOnImportTest.assertSQLState("XIE0M", e);
            RollBackWrappingWhenFailOnImportTest.assertSQLState("XJ058", e.getNextException());
        }
        finally {
            cSt.close();
        }
    }

    class MockInternalDriver
    extends Driver30 {
        MockInternalDriver() {
        }

        public Connection connect(String url, Properties info) {
            Connection conn = null;
            try {
                conn = super.connect(url, info);
            }
            catch (Exception e) {
                // empty catch block
            }
            return new MockConnectionFailWhenRollBack(conn);
        }

        public class MockConnectionFailWhenRollBack
        extends EmbedConnection30 {
            public MockConnectionFailWhenRollBack(Connection connection) {
                super((EmbedConnection)connection);
            }

            public void rollback() throws SQLException {
                throw new SQLException("error in roll back", "XJ058");
            }
        }
    }
}

