/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_5
extends UpgradeChange {
    private static final String BAD_SYNTAX = "42X01";

    public Changes10_5(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade test for 10.5");
        suite.addTestSuite(Changes10_5.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testUpdateStatisticsProcdure() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement s = this.createStatement();
                s.execute("CREATE TABLE DERBY_269(c11 int, c12 char(20))");
                s.execute("INSERT INTO DERBY_269 VALUES(1, 'DERBY-269')");
                s.execute("CREATE INDEX I1 ON DERBY_269(c12)");
                s.close();
                break;
            }
            case 1: 
            case 2: {
                Statement s = this.createStatement();
                Changes10_5.assertStatementError("42Y03", s, "call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', null)");
                Changes10_5.assertStatementError("42Y03", s, "call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', 'I1')");
                s.close();
                break;
            }
            case 3: {
                Statement s = this.createStatement();
                s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', null)");
                s.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', 'I1')");
                s.close();
            }
        }
    }

    public void testDeterminismKeyword() throws SQLException {
        String sqlstate = null;
        switch (this.getPhase()) {
            case 1: {
                sqlstate = "XCL47";
                break;
            }
            case 2: {
                sqlstate = BAD_SYNTAX;
                break;
            }
            case 3: {
                sqlstate = null;
                break;
            }
            default: {
                return;
            }
        }
        this.possibleError(sqlstate, "create function f_3570_12()\nreturns int\nlanguage java\nparameter style java\ndeterministic\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.possibleError(sqlstate, "create procedure p_3570_13()\nlanguage java\nnot deterministic\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
    }

    public void testGenerationClauses() throws SQLException {
        String sqlstate = null;
        switch (this.getPhase()) {
            case 1: {
                sqlstate = "XCL47";
                break;
            }
            case 2: {
                sqlstate = BAD_SYNTAX;
                break;
            }
            case 3: {
                sqlstate = null;
                break;
            }
            default: {
                return;
            }
        }
        this.possibleError(sqlstate, "create table t_genCol_2( a int, b int generated always as ( -a ), c int )");
    }

    private void possibleError(String sqlstate, String text) throws SQLException {
        if (sqlstate != null) {
            this.assertCompileError(sqlstate, text);
        } else {
            Statement s = this.createStatement();
            s.execute(text);
            s.close();
        }
    }

    public void testSQLRolesBasic() throws SQLException {
        Statement s = this.createStatement();
        String createRoleText = "create role foo";
        if (this.getOldMajor() == 10 && this.getOldMinor() == 4) {
            switch (this.getPhase()) {
                case 0: {
                    Changes10_5.assertStatementError("0A000", s, createRoleText);
                    break;
                }
                case 1: {
                    Changes10_5.assertStatementError("XCL47", s, createRoleText);
                    break;
                }
                case 2: {
                    Changes10_5.assertStatementError("0A000", s, createRoleText);
                    break;
                }
                case 3: {
                    Changes10_5.assertStatementError("42Z60", s, createRoleText);
                }
            }
        } else {
            switch (this.getPhase()) {
                case 0: {
                    Changes10_5.assertStatementError(BAD_SYNTAX, s, createRoleText);
                    break;
                }
                case 1: {
                    Changes10_5.assertStatementError("XCL47", s, createRoleText);
                    break;
                }
                case 2: {
                    Changes10_5.assertStatementError(BAD_SYNTAX, s, createRoleText);
                    break;
                }
                case 3: {
                    Changes10_5.assertStatementError("42Z60", s, createRoleText);
                }
            }
        }
        s.close();
    }

    public void testSQLRoles() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical("ROLES_10_5");
        Connection conn = null;
        Statement s = null;
        boolean supportSqlAuthorization = this.oldAtLeast(10, 2);
        JDBCDataSource.setBeanProperty(ds, "user", "garfield");
        JDBCDataSource.setBeanProperty(ds, "password", "theCat");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                conn = ds.getConnection();
                CallableStatement cs = conn.prepareCall("call syscs_util.syscs_set_database_property(?,?)");
                cs.setString(1, "derby.connection.requireAuthentication");
                cs.setString(2, "true");
                cs.execute();
                cs.setString(1, "derby.authentication.provider");
                cs.setString(2, "BUILTIN");
                cs.execute();
                cs.setString(1, "derby.database.sqlAuthorization");
                cs.setString(2, "true");
                cs.execute();
                cs.setString(1, "derby.database.propertiesOnly");
                cs.setString(2, "true");
                cs.execute();
                cs.setString(1, "derby.user.garfield");
                cs.setString(2, "theCat");
                cs.execute();
                cs.setString(1, "derby.user.jon");
                cs.setString(2, "theOwner");
                cs.execute();
                conn.close();
                JDBCDataSource.shutdownDatabase(ds);
                break;
            }
            case 1: {
                if (!this.oldAtLeast(10, 2)) break;
                conn = ds.getConnection();
                s = conn.createStatement();
                Changes10_5.assertStatementError("XCL47", s, "create role foo");
                conn.close();
                JDBCDataSource.shutdownDatabase(ds);
                break;
            }
            case 2: {
                conn = ds.getConnection();
                s = conn.createStatement();
                if (this.getOldMajor() == 10 && this.getOldMinor() == 4) {
                    Changes10_5.assertStatementError("0A000", s, "create role foo");
                } else {
                    Changes10_5.assertStatementError(BAD_SYNTAX, s, "create role foo");
                }
                conn.close();
                JDBCDataSource.shutdownDatabase(ds);
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true");
                conn = ds.getConnection();
                s = conn.createStatement();
                s.execute("create role foo");
                s.execute("create table cats(specie varchar(30))");
                s.execute("insert into cats values 'lynx', 'tiger', 'persian', 'garfield'");
                s.execute("grant select on cats to foo");
                s.execute("grant foo to jon");
                JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
                JDBCDataSource.setBeanProperty(ds, "user", "jon");
                JDBCDataSource.setBeanProperty(ds, "password", "theOwner");
                Connection jon = ds.getConnection();
                Statement jonStm = jon.createStatement();
                Changes10_5.assertStatementError("42502", jonStm, "select * from garfield.cats");
                jonStm.execute("set role foo");
                jonStm.execute("select * from garfield.cats");
                jonStm.close();
                jon.close();
                s.execute("drop table cats");
                s.execute("drop role foo");
                conn.close();
                Changes10_5.println("Roles work after hard upgrade");
                JDBCDataSource.setBeanProperty(ds, "user", "garfield");
                JDBCDataSource.setBeanProperty(ds, "password", "theCat");
                JDBCDataSource.shutdownDatabase(ds);
            }
        }
    }
}

