/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

final class PhaseChanger
extends BaseTestSetup {
    private final int phase;
    private final int[] version;
    private ClassLoader loader;
    private ClassLoader previousLoader;
    private boolean trace = false;
    private String upgradeAttributes = "upgrade=true";

    public PhaseChanger(Test test, int phase, ClassLoader loader, int[] version, boolean useCreateOnUpgrade) {
        super(test);
        this.phase = phase;
        this.loader = loader;
        this.version = version;
        if (useCreateOnUpgrade) {
            this.upgradeAttributes = this.upgradeAttributes + ";create=true";
        }
    }

    protected void setUp() throws SQLException {
        UpgradeChange.phase.set(new Integer(this.phase));
        UpgradeChange.oldVersion.set(this.version);
        TestConfiguration config = TestConfiguration.getCurrent();
        this.trace = config.doTrace();
        if (this.trace) {
            String versStr = ((int[])UpgradeChange.oldVersion.get())[0] + "." + ((int[])UpgradeChange.oldVersion.get())[1] + "." + ((int[])UpgradeChange.oldVersion.get())[2] + "." + ((int[])UpgradeChange.oldVersion.get())[3];
            BaseTestCase.traceit("Test upgrade from: " + versStr + ", phase: " + UpgradeChange.PHASES[this.phase]);
            if (UpgradeChange.PHASES[this.phase].equals("UPGRADE")) {
                BaseTestCase.traceit("Upgrade attributes = " + this.upgradeAttributes);
            }
        }
        if (this.loader != null) {
            this.previousLoader = Thread.currentThread().getContextClassLoader();
            UpgradeClassLoader.setThreadLoader(this.loader);
        }
        DataSource ds = JDBCDataSource.getDataSource();
        switch (this.phase) {
            case 4: {
                return;
            }
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", this.upgradeAttributes);
                break;
            }
        }
        ds.getConnection().close();
    }

    protected void tearDown() throws InterruptedException {
        if (this.trace) {
            BaseTestCase.traceit(" Test upgrade done.");
        }
        if (this.phase != 4) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.shutdownDatabase(ds);
            for (int i = 0; i < UpgradeRun.ADDITIONAL_DBS.length; ++i) {
                boolean shutdown2;
                block6: {
                    ds = JDBCDataSource.getDataSourceLogical(UpgradeRun.ADDITIONAL_DBS[i].logicalName);
                    if (!UpgradeRun.ADDITIONAL_DBS[i].shutDown) continue;
                    shutdown2 = true;
                    try {
                        ds.getConnection().close();
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        if (!"XJ004".equals(sqlState) && !"XJ040".equals(sqlState)) break block6;
                        shutdown2 = false;
                    }
                }
                if (!shutdown2) continue;
                JDBCDataSource.shutdownDatabase(ds);
            }
        }
        if (this.loader != null) {
            UpgradeClassLoader.setThreadLoader(this.previousLoader);
        }
        this.loader = null;
        this.previousLoader = null;
        UpgradeChange.phase.set(null);
        UpgradeChange.oldVersion.set(null);
    }
}

