/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;

public class UpgradeClassLoader {
    private static final String[] jarFiles = new String[]{"derby.jar"};
    static final String oldVersionsPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("derbyTesting.oldVersionsPath");
        }
    });
    static final String jarPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("derbyTesting.oldReleasePath");
        }
    });

    protected static String getTextVersion(int[] iv) {
        String version = iv[0] + "." + iv[1] + "." + iv[2] + "." + iv[3];
        return version;
    }

    public static ClassLoader makeClassLoader(final int[] version) {
        ClassLoader oldLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return UpgradeClassLoader.createClassLoader(version);
            }
        });
        if (oldLoader == null) {
            BaseTestCase.traceit("Empty: Skip upgrade Tests (no jars) for " + UpgradeClassLoader.getTextVersion(version));
        }
        return oldLoader;
    }

    public static void setThreadLoader(final ClassLoader which) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(which);
                return null;
            }
        });
    }

    public static ClassLoader getThreadLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static String getOldJarLocation(int[] oldVersion) {
        if (jarPath == null || jarPath.length() == 0) {
            return null;
        }
        String version = UpgradeClassLoader.getTextVersion(oldVersion);
        String jarLocation = jarPath + File.separator + version;
        return jarLocation;
    }

    private static String getOldJarURLLocation(int[] oldVersion) {
        String oldJarUrl = "http://svn.apache.org/repos/asf/db/derby/jars";
        String version = UpgradeClassLoader.getTextVersion(oldVersion);
        String jarLocation = oldJarUrl + "/" + version;
        return jarLocation;
    }

    private static ClassLoader createClassLoader(int[] version) {
        URL[] url = new URL[jarFiles.length];
        String jarLocation = UpgradeClassLoader.getOldJarLocation(version);
        if (jarLocation != null) {
            File lib = new File(jarLocation);
            if (!lib.exists()) {
                BaseTestCase.alarm("Non-existing location for jar files: '" + jarLocation + "'. Upgrade tests can NOT be run!");
                return null;
            }
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new File(lib, jarFiles[i]).toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                }
            }
        } else {
            String oldURLJarLocation = UpgradeClassLoader.getOldJarURLLocation(version);
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new URL(oldURLJarLocation + "/" + jarFiles[i]);
                    Object dummy = url[i].getContent();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                    continue;
                }
                catch (IOException e) {
                    BaseTestCase.alarm("IOException msg: '" + e.getMessage() + "'." + " Upgrade tests can NOT be run!");
                    return null;
                }
            }
        }
        return new URLClassLoader(url, null);
    }
}

