/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public final class SecurityManagerSetup
extends TestSetup {
    public static final boolean JVM_HAS_SUBJECT_AUTHORIZATION = JDBC.haveClass("javax.security.auth.Subject");
    private static final Properties classPathSet = new Properties();
    static boolean isJars;
    private static final boolean externalSecurityManagerInstalled;
    private final String decoratorPolicyResource;

    public SecurityManagerSetup(Test test, String policyResource) {
        super(test);
        this.decoratorPolicyResource = policyResource;
    }

    public static Test noSecurityManager(Test test) {
        if (externalSecurityManagerInstalled) {
            return new TestSuite("skipped due to external security manager " + test.toString());
        }
        return new SecurityManagerSetup(test, "<NONE>");
    }

    static void noSecurityManager() {
        SecurityManagerSetup.installSecurityManager("<NONE>");
    }

    protected void setUp() {
        SecurityManagerSetup.installSecurityManager(this.decoratorPolicyResource);
    }

    protected void tearDown() throws Exception {
        if ("<NONE>".equals(this.decoratorPolicyResource)) {
            BaseTestCase.setSystemProperty("java.security.policy", "");
        } else if (!externalSecurityManagerInstalled) {
            SecurityManagerSetup.uninstallSecurityManager();
        }
    }

    public static String getDefaultPolicy() {
        return "org/apache/derbyTesting/functionTests/util/derby_tests.policy";
    }

    static void installSecurityManager() {
        SecurityManagerSetup.installSecurityManager(SecurityManagerSetup.getDefaultPolicy());
    }

    private static void installSecurityManager(String policyFile) {
        if (externalSecurityManagerInstalled) {
            return;
        }
        Properties set = new Properties(classPathSet);
        SecurityManagerSetup.setSecurityPolicy(set, policyFile);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String oldPolicyProperty;
            String newPolicyProperty = set.getProperty("java.security.policy");
            if (newPolicyProperty == null) {
                newPolicyProperty = "";
            }
            if ((oldPolicyProperty = BaseTestCase.getSystemProperty("java.security.policy")) == null) {
                oldPolicyProperty = "";
            }
            if (newPolicyProperty.equals(oldPolicyProperty)) {
                return;
            }
            SecurityManagerSetup.uninstallSecurityManager();
        }
        Enumeration<?> e = set.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            BaseTestCase.setSystemProperty(key, set.getProperty(key));
        }
        if ("<NONE>".equals(set.getProperty("java.security.policy"))) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager sm = new SecurityManager();
                System.setSecurityManager(sm);
                Policy.getPolicy().refresh();
                return null;
            }
        });
    }

    private static void setSecurityPolicy(Properties set, String policyResource) {
        if ("<NONE>".equals(policyResource)) {
            set.setProperty("java.security.policy", policyResource);
            return;
        }
        URL policyURL = BaseTestCase.getTestResource(policyResource);
        if (policyURL == null) {
            try {
                policyURL = new URL(policyResource);
            }
            catch (Exception e) {
                System.out.println("Unreadable url: " + policyResource);
            }
        }
        if (policyURL != null) {
            set.setProperty("java.security.policy", policyURL.toExternalForm());
        }
    }

    private static boolean determineClasspath() {
        URL client;
        boolean isClasspath;
        String jaxp;
        URL emma;
        URL antjunit;
        if (System.getSecurityManager() != null) {
            return true;
        }
        URL junit = SecurityManagerSetup.getURL(Test.class);
        if (junit != null) {
            classPathSet.setProperty("derbyTesting.junit", junit.toExternalForm());
        }
        if ((antjunit = SecurityManagerSetup.getURL("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner")) != null) {
            classPathSet.setProperty("derbyTesting.antjunit", antjunit.toExternalForm());
        }
        if ((emma = SecurityManagerSetup.getURL("com.vladium.emma.EMMAException")) != null) {
            classPathSet.setProperty("emma.active", "");
            classPathSet.setProperty("derbyTesting.emma", emma.toExternalForm());
        }
        if ((jaxp = XML.getJAXPParserLocation()) != null) {
            classPathSet.setProperty("derbyTesting.jaxpjar", jaxp);
        }
        URL testing = SecurityManagerSetup.getURL(SecurityManagerSetup.class);
        URL ppTesting = null;
        if (BaseTestCase.getClassVersionMajor() >= 49) {
            ppTesting = SecurityManagerSetup.getURL("org.apache.derby.PackagePrivateTestSuite");
        }
        if (isClasspath = testing.toExternalForm().endsWith("/")) {
            classPathSet.setProperty("derbyTesting.codeclasses", testing.toExternalForm());
            if (ppTesting != null) {
                classPathSet.setProperty("derbyTesting.ppcodeclasses", ppTesting.toExternalForm());
            }
            isJars = false;
            return false;
        }
        classPathSet.setProperty("derbyTesting.testjar", SecurityManagerSetup.stripJar(testing));
        if (testing.getProtocol().equals("file")) {
            File f = new File(testing.getPath());
            classPathSet.setProperty("derbyTesting.testjarpath", f.getAbsolutePath());
        }
        isJars = true;
        URL derby = SecurityManagerSetup.getURL("org.apache.derby.jdbc.EmbeddedSimpleDataSource");
        if (derby != null) {
            classPathSet.setProperty("derbyTesting.codejar", SecurityManagerSetup.stripJar(derby));
        }
        if (!JDBC.vmSupportsJSR169() && (client = SecurityManagerSetup.getURL("org.apache.derby.jdbc.ClientDataSource")) != null) {
            classPathSet.setProperty("derbyTesting.clientjar", SecurityManagerSetup.stripJar(client));
        }
        return false;
    }

    public static Properties getPolicyFilePropertiesForOldHarness() {
        return classPathSet;
    }

    private static String stripJar(URL url) {
        String ef = url.toExternalForm();
        return ef.substring(0, ef.lastIndexOf(47) + 1);
    }

    public static URL getURL(String className) {
        try {
            return SecurityManagerSetup.getURL(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static URL getURL(final Class cl) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (cl.getProtectionDomain().getCodeSource() == null) {
                    return null;
                }
                return cl.getProtectionDomain().getCodeSource().getLocation();
            }
        });
    }

    private static void uninstallSecurityManager() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setSecurityManager(null);
                return null;
            }
        });
    }

    static {
        externalSecurityManagerInstalled = SecurityManagerSetup.determineClasspath();
    }
}

