/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortInfo;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_ColumnOrderingImpl;
import org.apache.derbyTesting.unitTests.store.T_DummySortObserver;
import org.apache.derbyTesting.unitTests.store.T_DuplicateEliminator;
import org.apache.derbyTesting.unitTests.store.T_SumForIntCol;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_SortController
extends T_Generic {
    private static final String testService = "sortTest";
    protected boolean verbose = false;

    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    private void setSortBufferSize(final String buf_length) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("derby.storage.sortBufferMax", buf_length);
                return null;
            }
        });
    }

    protected void runTests() throws T_Fail {
        AccessFactory store4;
        int failcount = 0;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.REPORT("(unitTestMain) Testing sortTest with default sort buffer size 1024");
            AccessFactory store1024 = null;
            failcount = this.runEachTest(store1024, "1024");
            this.setSortBufferSize("4");
            this.REPORT("(unitTestMain) Testing sortTest with minimum sort buffer size 4");
            store4 = null;
        }
        catch (StandardException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = ((Object)((Object)e)).getClass().getName();
            }
            this.REPORT("(unitTestMain) unexpected exception: " + msg);
            throw T_Fail.exceptionFail(e);
        }
        if ((failcount += this.runEachTest(store4, "4")) != 0) {
            throw T_Fail.testFailMsg("(unitTestMain)" + failcount + " cases failed.");
        }
        this.REPORT("(unitTestMain) succeeded");
    }

    protected int runEachTest(AccessFactory store, String tail) throws T_Fail, StandardException {
        TransactionController tc = null;
        int failcount = 0;
        try {
            store = (AccessFactory)Monitor.createPersistentService((String)this.getModuleToTestProtocolName(), (String)(testService + tail), (Properties)this.startParams);
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        tc = store.getTransaction(ContextService.getFactory().getCurrentContextManager());
        if (!this.sortExample(tc)) {
            ++failcount;
        }
        if (!this.sortBufferCoverage(tc)) {
            ++failcount;
        }
        if (!this.sortBoundaries(tc)) {
            ++failcount;
        }
        if (!this.sortAllDuplicates(tc)) {
            ++failcount;
        }
        if (!this.sortDescending(tc)) {
            ++failcount;
        }
        tc.commit();
        tc.destroy();
        return failcount;
    }

    boolean sortExample(TransactionController tc) throws StandardException {
        this.REPORT("(sortExample)");
        T_AccessRow[] row = new T_AccessRow[]{new T_AccessRow(18, 1, 2), new T_AccessRow(6, 1, 18), new T_AccessRow(18, 1, 2), new T_AccessRow(8, 14, 3)};
        Properties implParameters = null;
        T_AccessRow template = row[0];
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(1, true), new T_ColumnOrderingImpl(2, true)};
        boolean alreadyInOrder = false;
        long estimatedRows = 10L;
        int estimatedRowSize = 12;
        long sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DuplicateEliminator(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        T_AccessRow[] expectedRow = new T_AccessRow[]{new T_AccessRow(18, 1, 2), new T_AccessRow(6, 1, 18), new T_AccessRow(8, 14, 3)};
        return this.testSort(tc, row, expectedRow, sortid);
    }

    boolean sortBufferCoverage(TransactionController tc) throws StandardException {
        this.REPORT("(sortBufferCoverage)");
        T_AccessRow[] row = new T_AccessRow[]{new T_AccessRow(2, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(6, 0, 0)};
        Properties implParameters = null;
        T_AccessRow template = row[0];
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true)};
        boolean alreadyInOrder = false;
        long estimatedRows = 20L;
        int estimatedRowSize = 12;
        long sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        T_AccessRow[] expectedRow = new T_AccessRow[]{new T_AccessRow(1, 0, 0), new T_AccessRow(1, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(2, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(3, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(4, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(5, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(6, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(7, 0, 0), new T_AccessRow(8, 0, 0), new T_AccessRow(8, 0, 0)};
        return this.testSort(tc, row, expectedRow, sortid);
    }

    boolean sortBoundaries(TransactionController tc) throws StandardException {
        int failcount = 0;
        Properties implParameters = null;
        T_AccessRow template = new T_AccessRow(1, 1, 1);
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true)};
        long estimatedRows = 10L;
        int estimatedRowSize = 12;
        this.REPORT("(sortBoundaries) Sorting no rows");
        T_AccessRow[] input = new T_AccessRow[]{};
        T_AccessRow[] expected = new T_AccessRow[]{};
        boolean alreadyInOrder = false;
        long sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortBoundaries) Sorting no rows - \"already in order\"");
        input = new T_AccessRow[]{};
        expected = new T_AccessRow[]{};
        alreadyInOrder = true;
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortBoundaries) Sorting a single row");
        input = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        expected = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        alreadyInOrder = false;
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortBoundaries) Sorting a single row - \"already in order\"");
        input = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        expected = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        alreadyInOrder = true;
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortBoundaries) Sorting a single row - \"eliminate duplicates\"");
        input = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        expected = new T_AccessRow[]{new T_AccessRow(99, 88, 77)};
        alreadyInOrder = false;
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DuplicateEliminator(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        return failcount == 0;
    }

    boolean sortAllDuplicates(TransactionController tc) throws StandardException {
        int failcount = 0;
        Properties implParameters = null;
        T_AccessRow template = new T_AccessRow(1, 1, 1);
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true), new T_ColumnOrderingImpl(1, true)};
        boolean alreadyInOrder = false;
        long estimatedRows = 10L;
        int estimatedRowSize = 12;
        T_AccessRow[] input = new T_AccessRow[]{new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1)};
        this.REPORT("(sortAllDuplicates) no aggregation");
        T_AccessRow[] expected = new T_AccessRow[]{new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(1, 1, 1)};
        long sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortAllDuplicates) eliminate duplicates");
        expected = new T_AccessRow[]{new T_AccessRow(1, 1, 1)};
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DuplicateEliminator(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortAllDuplicates) sum aggregate");
        expected = new T_AccessRow[]{new T_AccessRow(1, 1, 5)};
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_SumForIntCol(2), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, input, expected, sortid)) {
            ++failcount;
        }
        return failcount == 0;
    }

    boolean sortDescending(TransactionController tc) throws StandardException {
        int failcount = 0;
        Properties implParameters = null;
        T_AccessRow template = new T_AccessRow(1, 1, 1);
        boolean alreadyInOrder = false;
        long estimatedRows = 10L;
        int estimatedRowSize = 12;
        this.REPORT("(sortDescending) no aggregation");
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false)};
        T_AccessRow[] expected = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(1, 1, 1)};
        long sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DummySortObserver(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, this.getSortDescendingInput(), expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortDescending) eliminate duplicates");
        order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false)};
        expected = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(1, 1, 1)};
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DuplicateEliminator(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, this.getSortDescendingInput(), expected, sortid)) {
            ++failcount;
        }
        this.REPORT("(sortDescending) descending/ascending - eliminate duplicates");
        order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, true)};
        expected = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 8, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(1, 1, 1)};
        sortid = tc.createSort(implParameters, template.getRowArray(), order, (SortObserver)new T_DuplicateEliminator(template), alreadyInOrder, estimatedRows, estimatedRowSize);
        if (!this.testSort(tc, this.getSortDescendingInput(), expected, sortid)) {
            ++failcount;
        }
        return failcount == 0;
    }

    private T_AccessRow[] getSortDescendingInput() {
        T_AccessRow[] input = new T_AccessRow[]{new T_AccessRow(8, 1, 1), new T_AccessRow(1, 1, 1), new T_AccessRow(3, 5, 1), new T_AccessRow(4, 1, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 8, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(3, 3, 1), new T_AccessRow(4, 2, 1), new T_AccessRow(4, 8, 1)};
        return input;
    }

    boolean testSort(TransactionController tc, T_AccessRow[] in, T_AccessRow[] outrow, long sortid) throws StandardException {
        SortController sort = tc.openSort(sortid);
        for (int i = 0; i < in.length; ++i) {
            if (this.verbose) {
                this.REPORT("(testSort) in: " + in[i]);
            }
            sort.insert(in[i].getRowArray());
        }
        sort.completedInserts();
        SortInfo sort_info = sort.getSortInfo();
        Properties sortprop = sort_info.getAllSortInfo(null);
        String sortType = sortprop.getProperty(MessageService.getTextMessage((String)"XSAJ8.U"));
        int numRowsInput = Integer.parseInt(sortprop.getProperty(MessageService.getTextMessage((String)"XSAJA.U")));
        int numRowsOutput = Integer.parseInt(sortprop.getProperty(MessageService.getTextMessage((String)"XSAJB.U")));
        String external = MessageService.getTextMessage((String)"XSAJI.U");
        String internal = MessageService.getTextMessage((String)"XSAJJ.U");
        if (sortType.compareTo(internal) != 0 && sortType.compareTo(external) != 0) {
            this.FAIL("(testSort) unknown sortType.  Expected internal or external, got " + sortType);
        }
        if (numRowsInput != in.length) {
            this.FAIL("(testSort) SortInfo.numRowsInput (value: " + numRowsInput + ") is not equal to in.length (value: " + in.length + ")");
        }
        if (numRowsOutput != outrow.length) {
            this.FAIL("(testSort) SortInfo.numRowsOutput (value: " + numRowsOutput + ") is not equal to outrow.length (value: " + outrow.length + ")");
        }
        if (sortType.equals(external)) {
            int numMergeRuns = Integer.parseInt(sortprop.getProperty(MessageService.getTextMessage((String)"XSAJC.U")));
            Vector<Integer> mergeRuns = new Vector<Integer>();
            StringTokenizer st = new StringTokenizer(sortprop.getProperty(MessageService.getTextMessage((String)"XSAJD.U")), "[],", false);
            while (st.hasMoreTokens()) {
                mergeRuns.addElement(Integer.valueOf(st.nextToken().trim()));
            }
            if (mergeRuns.size() != numMergeRuns) {
                this.FAIL("(testSort) the number of elements in vector SortInfo.mergeRunsSize (value: " + mergeRuns.size() + " ) is not equal to SortInfo.numMergeRuns (value: " + numMergeRuns + " )");
            }
            int totRunSize = 0;
            for (int i = 0; i < mergeRuns.size(); ++i) {
                totRunSize += ((Integer)mergeRuns.elementAt(i)).intValue();
            }
            if (totRunSize != numRowsInput) {
                this.FAIL("(testSort) the sum of the elements of the vector SortInfo.mergeRunsSize (value: " + totRunSize + " ) is not equal to SortInfo.numRowsInput (value: " + numRowsInput + " )");
            }
        }
        sort = null;
        ScanController scan = tc.openSortScan(sortid, false);
        boolean mismatch = false;
        boolean toofew = false;
        boolean toomany = false;
        T_AccessRow result = new T_AccessRow(3);
        for (int i = 0; i < outrow.length; ++i) {
            if (!scan.next()) {
                toofew = true;
                this.FAIL("(testSort) Too few rows in sort output");
                break;
            }
            scan.fetch(result.getRowArray());
            if (this.verbose) {
                this.REPORT("(testSort) out: " + result);
            }
            if (result.equals(outrow[i])) continue;
            mismatch = true;
            this.FAIL("(testSort) row " + result + " != " + outrow[i]);
        }
        while (scan.next()) {
            scan.fetch(result.getRowArray());
            if (this.verbose) {
                this.REPORT("(testSort) out: " + result);
            }
            toomany = true;
            this.FAIL("(testSort) Extra row");
        }
        ScanInfo scan_info = scan.getScanInfo();
        Properties prop = scan_info.getAllScanInfo(null);
        if (prop.getProperty(MessageService.getTextMessage((String)"XSAJ0.U")).compareTo(MessageService.getTextMessage((String)"XSAJH.U")) != 0) {
            this.FAIL("(testSort) wrong scanType.  Expected sort, got " + prop.getProperty(MessageService.getTextMessage((String)"XSAJ0.U")));
        }
        if (tc.countOpens(3) != 1) {
            this.FAIL("(testSort) sort count before close is wrong: " + tc.countOpens(3));
        }
        scan.close();
        scan = null;
        if (tc.countOpens(3) != 1) {
            this.FAIL("(testSort) sort count after close is wrong: " + tc.countOpens(3));
        }
        tc.dropSort(sortid);
        if (tc.countOpens(3) > 0) {
            this.FAIL("(testSort) a sort is still open.");
        }
        return !mismatch && !toofew && !toomany;
    }
}

