/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLinenFormatter extends Formatter {

	private final SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

	@Override
	public synchronized String format(LogRecord record) {

		final StringBuffer message = new StringBuffer();

		message.append(sdFormat.format(new Date(record.getMillis())));

		message.append(' ').append(record.getLevel().toString());

		String className = record.getSourceClassName();
		message.append(' ').append(className != null ? className : record.getLoggerName());

		String methodName = record.getSourceMethodName();
		message.append(" [").append(methodName != null ? methodName : "N/A").append("] ");

		message.append(formatMessage(record)).append('\n');

		Throwable throwable = record.getThrown();
		if (throwable != null) {
			message.append(throwable.toString()).append('\n');
			for (StackTraceElement trace : throwable.getStackTrace()) {
				message.append('\t').append(trace.toString()).append('\n');
			}
		}
		return message.toString();
	}

}
