/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

import javax.swing.DefaultListModel;

public class CodeAssistModel extends DefaultListModel<CodeAssistItem> {

    private static final long serialVersionUID = 2306739329634957717L;
    
	private int maxLengh;

	/**
	 * @return maxLengh
	 */
	public int getMaxLengh() {
		return maxLengh;
	}

	public CodeAssistModel(){
		clear();
		addItem("SELECT *\nFROM \n");
		addItem("SELECT *\nFROM \nWHERE \n");
		addItem("SELECT *\nFROM \nORDER BY \n");
		addItem("SELECT *\nFROM \nWHERE \nORDER BY \n");
		addItem("UPDATE \nSET\nWHERE \n");
		addItem("INSERT INTO \nVALUES()\n");
		addItem("DELETE FROM \nWHERE \n");
	}

	private void addItem(String item){
		int length = item.length();
		if (maxLengh < length) {
			maxLengh = length;
		}
		addElement(new CodeAssistItem(item));
	}
}
