/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService;

import java.sql.Clob;
import java.sql.SQLException;


/**
 * 検索結果
 * 
 * @author sima
 * 
 */
public class Result {

	private final Object data;
	private final Class<?> cls;
	private String cache;

	public boolean num;
	public boolean error;
	public final boolean nulldata;


	public Result(ColumnAttributeResult columnAttributeResult,Object data) {
		this.data = data;
		nulldata = (data == null);
		cls = columnAttributeResult.getColumnClass();

		if (nulldata) {
			cache = "#null#";
			return;
		}

		if (java.lang.String.class.isAssignableFrom(cls)) {
			cache = data.toString();
			return;
		}
		if (java.util.Date.class.isAssignableFrom(cls)) {
			cache = data.toString();
			return;
		}
		if (java.lang.Number.class.isAssignableFrom(cls)) {
			num = true;
			cache = data.toString();
			return;
		}
		if (Clob.class.isAssignableFrom(cls)) {
			try {
				cache = ((Clob) data).getSubString(0, (int) ((Clob) data).length());
			} catch (SQLException e) {
				error = true;
				cache = "";
			}
			return;
		}
		cache = "#unknown#";
		return;
	}

	@Override
	public String toString() {
		return cache;
	}

	public String toQoteString() {
		if (num) {
			return cache;
		}
		return '"' + cache + '"';
	}

}
