/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

/**
 * SQL実行タスクを外部から制御する為のインタフェース <li>タスク再開</li> <li>タスク中断</li> <li>タスク待ち合わせ</li>
 * 等の制御を可能にする。
 * 
 * @author sima
 * 
 */
public interface SqlExecuteTask {

	/**
	 * 実行予定SQL文の数
	 */
	public int getCnt();

	/**
	 * WAIT状態のタスクを再開する
	 */
	public void taskWakeUp();

	/**
	 * 実行状態のタスクを中止する。中止の監視は、検索結果を１行取得する毎に行われます。</br> DBMSで実行中のSQL文を強制中止は行いません。
	 */
	public void taskCancel();

	/**
	 * 非同期実行した場合に、終了を待ち合わせします。
	 */
	public void taskJoin(int timeoutSeconds);

	/**
	 * SQL実行スレッド処理時間を取得できます。スレッドが終了していない場合はゼロになります。
	 * 
	 * @return ミリ秒単位の処理時間
	 */
	public long getExecutionTime();
}
