/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Icon;

import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

/**
 * CATALOGの一覧
 * 
 * @author sima
 * 
 */
public class DBObjectCatalogs extends DBObjects {


	private final ArrayList<DBObject> catalogs = new ArrayList<DBObject>();

	/**
	 * コンストラクタ
	 * 
	 * @param dmd
	 * @throws SQLException
	 */
	public DBObjectCatalogs(DatabaseMetaData dmd) throws SQLException {
		ResultSet rs = dmd.getCatalogs();
		while (rs.next()) {
			catalogs.add(new DBObjectCatalog(rs));
		}
		rs.close();
	}

	@Override
	public ArrayList<DBObject> getDBObjects() {
		return catalogs;
	}

	@Override
	public String toString() {
		return "CATALOG";
	}
	/**
	 * CATALOGのプロパティ
	 * 
	 * @author sima
	 * 
	 */
	public static class DBObjectCatalog extends DBObject {

		/**
		 * カタログ名 {@link DatabaseMetaData#getCatalogs()} の第１要素
		 */
		public String catalogName;

		private final List<Property> properties = new ArrayList<Property>();

		@Override
		public List<Property> getProperties() {
			return properties;
		}
		/**
		 * コンストラクタ
		 * 
		 * @param rs
		 * @throws SQLException
		 */
		public DBObjectCatalog(ResultSet rs) throws SQLException {
			int colCnt = rs.getMetaData().getColumnCount();
			int i = 0;
			if (colCnt > i) {
				catalogName = rs.getString(++i);
				properties.add(new Property("TABLE_CAT", catalogName));
			}
		}


		/*
		 * (非 Javadoc)
		 * 
		 * @seejdbcacsess2.sqlService.dbobject.DBObject#getChildren(java.sql.
		 * DatabaseMetaData)
		 */
		@Override
		public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
			DBObjects dbObjects = new DBObjectSchemas(this, dmd);

			if (dbObjects.getDBObjects().size() == 0) {
				dbObjects = new DBObjectTableTypes(this, null, dmd);
			}

			return dbObjects;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getName()
		 */
		@Override
		public String getName() {
			return catalogName;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getIconImage()
		 */
		@Override
		public Icon getIconImage() {
			return DbObjectIconImage.CATALOG.getValue();
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isStrong()
		 */
		@Override
		public boolean isStrong() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isBottom()
		 */
		@Override
		public boolean isBottom() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getSummary()
		 */
		@Override
		public String getSummary() {
			if (catalogName == null) {
				return "(無し)";
			}
			return catalogName;
		}

		@Override
		public boolean isPropertyEnable() {
			return false;
		}

	}

}
