/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.parse;


/**
 * SQL文を解析した結果の字句要素を通知するリスナーです。
 * 
 * @author sima
 * 
 */
public interface SqlSentenceListener {

	/**
	 * 処理開始
	 * 
	 * @param sqlSentence
	 *            解析対象のSQL文
	 */
	public void started(String sqlSentence);

	/**
	 * コメント
	 * 
	 * @param comment
	 *            コメント文字列
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangeComment(String comment, int beginPosition, int endPosition);

	/**
	 * SQL句と要素
	 * 
	 * @param phrase
	 *            SQL句と要素文字列
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangePhrase(String phrase, int beginPosition, int endPosition);

	/**
	 * SQL句と要素
	 * 
	 * @param input
	 *            SQL句と要素文字列
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangeInput(String input, int beginPosition, int endPosition);

	/**
	 * 定数
	 * 
	 * @param constant
	 *            定数
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangeConstant(String constant, int beginPosition, int endPosition);

	/**
	 * デリミタ
	 * 
	 * @param delimiter
	 *            デリミタ文字列
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangeDelimiter(String delimiter, int beginPosition, int endPosition);

	/**
	 * 記号
	 * 
	 * @param symbol
	 *            記号文字
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 */
	public void rangeSymbol(String symbol, int beginPosition, int endPosition);

	/**
	 * 終了
	 * 
	 * @param separateSentence
	 *            １SQLに分解されたSQL文
	 * @param command
	 *            SQL命令種類(SELECT,INSERT,DELETE,UPDATE,CREATE,ALTER,...)
	 */
	public void finished(String separateSentence, String command);

}
