/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.connect;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jdbcacsess2.connect.ConfigConnect;
import jdbcacsess2.main.Config;
import net.java.ao.RawEntity;

public final class ConnectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6824005336951869877L;
    private static final String[] header = new String[]{"name", "user", "server", "DBname", "last connect"};
    private List<ConfigConnect> connectList;
    private Config config;

    public ConnectTableModel(Config config) throws SQLException {
        this.config = config;
        this.connectList = new ArrayList<ConfigConnect>(Arrays.asList(config.getConfigConnect()));
    }

    @Override
    public String getColumnName(int column) {
        return header[column];
    }

    @Override
    public int getColumnCount() {
        return header.length;
    }

    @Override
    public int getRowCount() {
        return this.connectList.size();
    }

    public ConfigConnect getRow(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        return this.connectList.get(rowIndex);
    }

    public int getRowIndex(ConfigConnect configConnect) throws SQLException {
        String connectName = configConnect.getConnectName();
        if (connectName == null) {
            connectName = "";
        }
        int i = 0;
        while (i < this.connectList.size()) {
            int val = this.connectList.get(i).getConnectName().compareTo(connectName);
            if (val == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rtn = null;
        switch (columnIndex) {
            case 0: {
                rtn = this.connectList.get(rowIndex).getConnectName();
                break;
            }
            case 1: {
                rtn = this.connectList.get(rowIndex).getConnectUser();
                break;
            }
            case 2: {
                rtn = this.connectList.get(rowIndex).getHostName();
                break;
            }
            case 3: {
                rtn = this.connectList.get(rowIndex).getDatabaseName();
                break;
            }
            case 4: {
                rtn = this.connectList.get(rowIndex).getLastConnectdate();
                break;
            }
        }
        return rtn;
    }

    public void update(ConfigConnect newConfigConnect) {
        int i = 0;
        while (i < this.connectList.size()) {
            if (this.connectList.get(i).getConnectName().equals(newConfigConnect.getConnectName())) {
                this.fireTableRowsUpdated(i, i);
                newConfigConnect.save();
                return;
            }
            ++i;
        }
    }

    public void append(ConfigConnect newConfigConnect) throws AlreadyExistsException {
        int i = 0;
        while (i < this.connectList.size()) {
            if (this.connectList.get(i).getConnectName().equals(newConfigConnect.getConnectName())) {
                throw new AlreadyExistsException(String.valueOf(newConfigConnect.getConnectName()) + " is exists");
            }
            ++i;
        }
        this.connectList.add(newConfigConnect);
        this.fireTableRowsInserted(i, i);
        newConfigConnect.save();
    }

    public void save(ConfigConnect configConnect) {
        int i = 0;
        while (i < this.connectList.size()) {
            if (this.connectList.get(i).getConnectName().equals(configConnect.getConnectName())) {
                this.connectList.set(i, configConnect);
                this.fireTableRowsUpdated(i, i);
                configConnect.save();
                return;
            }
            ++i;
        }
        this.connectList.add(configConnect);
        this.fireTableRowsInserted(i, i);
        configConnect.save();
    }

    public void remove(ConfigConnect oldConfigConnect) throws SQLException {
        int i = 0;
        while (i < this.connectList.size()) {
            if (this.connectList.get(i).getConnectName().equals(oldConfigConnect.getConnectName())) {
                this.connectList.remove(i);
                this.fireTableRowsDeleted(i, i);
                this.config.getEntityManager().delete(new RawEntity[]{oldConfigConnect});
                return;
            }
            ++i;
        }
    }

    public class AlreadyExistsException
    extends Exception {
        private static final long serialVersionUID = 1411153554815205565L;

        public AlreadyExistsException(String string) {
            super(string);
        }
    }
}

