/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jdbcacsess2.sqlService.ConstSqlTypes;

public class ColumnAttributeResult {
    private Class<?> columnClass;
    private String columnClassName;
    private int columnDisplaySize;
    private String columnLabel;
    private String columnName;
    private ConstSqlTypes columnType;
    private String columnTypeName;
    private int precision;
    private int scale;
    private boolean signed;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private boolean autoIncrement;
    private boolean caseSensitive;
    private boolean currency;
    private boolean definitelyWritable;
    private int nullable;
    private boolean readOnly;
    private boolean searchable;
    private boolean writable;

    public static List<ColumnAttributeResult> convColumnAttributeResult(ResultSetMetaData rsmd) throws SQLException, ClassNotFoundException {
        int cnt = rsmd.getColumnCount();
        ArrayList<ColumnAttributeResult> columnAttributeResultList = new ArrayList<ColumnAttributeResult>(cnt);
        int i = 1;
        while (i <= cnt) {
            columnAttributeResultList.add(new ColumnAttributeResult(rsmd, i));
            ++i;
        }
        return columnAttributeResultList;
    }

    public ColumnAttributeResult(ResultSetMetaData rsmd, int column) throws SQLException {
        this.columnClassName = rsmd.getColumnClassName(column);
        try {
            this.columnClass = Class.forName(this.columnClassName, true, rsmd.getClass().getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.columnDisplaySize = rsmd.getColumnDisplaySize(column);
        this.columnLabel = rsmd.getColumnLabel(column);
        this.columnName = rsmd.getColumnName(column);
        this.columnType = ConstSqlTypes.searchTypes(rsmd.getColumnType(column));
        this.columnTypeName = rsmd.getColumnTypeName(column);
        this.precision = rsmd.getPrecision(column);
        this.scale = rsmd.getScale(column);
        this.columnTypeName = rsmd.getColumnTypeName(column);
        this.catalogName = rsmd.getCatalogName(column);
        this.schemaName = rsmd.getSchemaName(column);
        this.tableName = rsmd.getTableName(column);
        this.autoIncrement = rsmd.isAutoIncrement(column);
        this.caseSensitive = rsmd.isCaseSensitive(column);
        this.currency = rsmd.isCurrency(column);
        this.definitelyWritable = rsmd.isDefinitelyWritable(column);
        this.nullable = rsmd.isNullable(column);
        this.readOnly = rsmd.isReadOnly(column);
        this.searchable = rsmd.isSearchable(column);
        this.writable = rsmd.isWritable(column);
    }

    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ConstSqlTypes getColumnType() {
        return this.columnType;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public int getNullable() {
        return this.nullable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isWritable() {
        return this.writable;
    }
}

