/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.history;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import jdbcacsess2.main.Config;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.sqlService.ColumnAttributeResult;
import jdbcacsess2.sqlService.SqlExecuteTask;
import jdbcacsess2.sqlService.SqlExecutedListener;
import jdbcacsess2.sqlService.history.ExecHistory;
import jdbcacsess2.sqlService.history.HistryTableModel;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;

public class Record
implements SqlExecutedListener {
    private final EntityManager entityManager;
    private ExecHistory execHistory;
    private int execHistoryIndex = -1;
    private final String connectName;
    private final String url;
    private final String user;
    private final HistryTableModel histryTableModel;

    public Record(Config config, String connectName, String url, String user, HistryTableModel histryTableModel) {
        this.entityManager = config.getEntityManager();
        this.connectName = connectName;
        this.url = url;
        this.user = user;
        this.histryTableModel = histryTableModel;
    }

    @Override
    public void taskAccept(SqlExecuteTask sqlExecuteTask) {
    }

    @Override
    public void executBegin(SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentence) {
        try {
            this.execHistory = (ExecHistory)this.entityManager.create(ExecHistory.class, new DBParam[]{new DBParam("connectname", (Object)this.connectName), new DBParam("startdate", (Object)new Date()), new DBParam("url", (Object)this.url), new DBParam("connectuser", (Object)this.user)});
            this.execHistory.setSqlCommand(sqlExecuteSentence.getSqlCommand());
            this.execHistory.setSqlText(sqlExecuteSentence.getSqlSentence());
            this.execHistory.setResultStatus(ExecHistory.ResultStatus.ACCEPT);
            this.execHistoryIndex = this.histryTableModel.add(this.execHistory);
            this.saveLater(this.execHistory);
            SwingUtilities.invokeLater(new Fire(this.execHistoryIndex, FireType.INSERT));
        }
        catch (SQLException e) {
            ShowDialog.errorMessage(e);
        }
    }

    @Override
    public void executNormalFinish(int rowCnt) {
        if (this.execHistory == null) {
            return;
        }
        this.execHistory.setResultCnt(rowCnt);
        if (this.execHistory.getEndDate() == null) {
            this.execHistory.setEndDate(new Date());
        }
        this.execHistory.setResultStatus(ExecHistory.ResultStatus.NORMALEND);
        this.saveLater(this.execHistory);
        SwingUtilities.invokeLater(new Fire(this.execHistoryIndex, FireType.UPDATE));
    }

    @Override
    public void executeAllEnd() {
    }

    @Override
    public void executeException(Throwable t) {
        if (this.execHistory == null) {
            return;
        }
        if (this.execHistory.getEndDate() == null) {
            this.execHistory.setEndDate(new Date());
        }
        this.execHistory.setResultStatus(ExecHistory.ResultStatus.ABNORMALEND);
        this.saveLater(this.execHistory);
        SwingUtilities.invokeLater(new Fire(this.execHistoryIndex, FireType.UPDATE));
    }

    @Override
    public void resultDetail(int seq, List<Object> detail) {
    }

    @Override
    public void resultHeader(List<ColumnAttributeResult> header) {
        if (this.execHistory == null) {
            return;
        }
        this.execHistory.setEndDate(new Date());
        this.saveLater(this.execHistory);
        SwingUtilities.invokeLater(new Fire(this.execHistoryIndex, FireType.UPDATE));
    }

    @Override
    public void statusContinue(int seqNo) {
        if (this.execHistory == null) {
            return;
        }
        this.execHistory.setResultCnt(seqNo);
        if (this.execHistory.getEndDate() == null) {
            this.execHistory.setEndDate(new Date());
        }
        this.execHistory.setResultStatus(ExecHistory.ResultStatus.EXECUTING);
        this.saveLater(this.execHistory);
        SwingUtilities.invokeLater(new Fire(this.execHistoryIndex, FireType.UPDATE));
    }

    private void saveLater(final ExecHistory execHistory) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                execHistory.save();
            }
        };
        thread.start();
    }

    private class Fire
    implements Runnable {
        private final int index;
        private final FireType type;

        public Fire(int index, FireType type) {
            this.index = index;
            this.type = type;
        }

        @Override
        public void run() {
            switch (this.type) {
                case INSERT: {
                    Record.this.histryTableModel.fireTableRowsInserted(this.index, this.index);
                    break;
                }
                case UPDATE: {
                    Record.this.histryTableModel.fireTableRowsUpdated(this.index, this.index);
                    break;
                }
            }
        }
    }

    static enum FireType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

