/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.parse;

import java.util.ArrayList;
import java.util.regex.Pattern;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.parse.SqlInputParameter;
import jdbcacsess2.sqlService.parse.SqlSentenceListener;
import jdbcacsess2.sqlService.parse.SqlSentenceParse;
import jdbcacsess2.sqlService.parse.SqlSentenceSparateListener;

public class SqlExecuteSentencies {
    private int seq = 0;
    private final ArrayList<SqlExecuteSentence> sqlExecuteSentenceList = new ArrayList();

    public SqlExecuteSentencies(String sqlSentence, String sentenceSeparator) {
        final SqlSentenceParse sqlSentenceParse = new SqlSentenceParse();
        sqlSentenceParse.addSqlSentenceListener(new SqlExecuteSentence());
        sqlSentenceParse.registSeparatePattern(Pattern.compile(sentenceSeparator));
        sqlSentenceParse.registSeparateListener(new SqlSentenceSparateListener(){

            @Override
            public void rangeSeparate(String matchKeyword, int beginPosition, int endPosition, Pattern pattern) {
                sqlSentenceParse.removeAllSqlSentenceListener();
                sqlSentenceParse.addSqlSentenceListener(new SqlExecuteSentence());
            }
        });
        sqlSentenceParse.parse(sqlSentence);
        Jdbcacsess2.logger.info(this.sqlExecuteSentenceList.toString());
    }

    public ArrayList<SqlExecuteSentence> getSqlExecuteSentenceList() {
        return this.sqlExecuteSentenceList;
    }

    public class SqlExecuteSentence
    implements SqlSentenceListener {
        private String sqlSentence;
        private int sentenceCount;
        private final SqlInputParameter sqlInputParameter = new SqlInputParameter();
        private String sqlCommand;
        private boolean editable = false;
        private int phraseCnt = 0;
        private boolean checkEnd = false;
        private boolean select = false;
        private boolean from = false;

        public int getSentenceCount() {
            return this.sentenceCount;
        }

        public String getSqlSentence() {
            return this.sqlSentence;
        }

        public SqlInputParameter getSqlInputParameter() {
            return this.sqlInputParameter;
        }

        public String getSqlCommand() {
            return this.sqlCommand;
        }

        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public void started(String sqlSentence) {
            this.sqlSentence = sqlSentence;
        }

        @Override
        public void rangeInput(String phrase, int begin, int end) {
            this.sqlInputParameter.addInputItemName(phrase);
        }

        @Override
        public void rangePhrase(String phrase, int begin, int end) {
            if (this.checkEnd) {
                return;
            }
            String upperPhrase = phrase.toUpperCase();
            ++this.phraseCnt;
            if (this.phraseCnt == 1 && upperPhrase.equals("SELECT")) {
                this.select = true;
                return;
            }
            if (!this.select) {
                this.checkEnd = true;
                this.editable = false;
                return;
            }
            if (upperPhrase.equals("SELECT") || upperPhrase.equals("GROUP")) {
                this.checkEnd = true;
                this.editable = false;
                return;
            }
            if (upperPhrase.equals("FROM")) {
                this.editable = true;
                this.from = true;
                return;
            }
            if (upperPhrase.equals("WHERE")) {
                this.from = false;
                return;
            }
        }

        @Override
        public void rangeSymbol(String symbol, int begin, int end) {
            if (this.checkEnd) {
                return;
            }
            if (this.from && symbol.equals(",")) {
                this.checkEnd = true;
                this.editable = false;
                return;
            }
        }

        @Override
        public void finished(String sentence, String command) {
            this.sqlSentence = sentence;
            this.sqlCommand = command;
            if (!this.sqlCommand.equals("")) {
                SqlExecuteSentencies sqlExecuteSentencies = SqlExecuteSentencies.this;
                int n = sqlExecuteSentencies.seq + 1;
                sqlExecuteSentencies.seq = n;
                this.sentenceCount = n;
                if (this.sqlCommand.equals("CREATE") || this.sqlCommand.equals("ALTER")) {
                    this.sqlInputParameter.clear();
                }
                SqlExecuteSentencies.this.sqlExecuteSentenceList.add(this);
            }
        }

        @Override
        public void rangeComment(String comment, int begin, int end) {
        }

        @Override
        public void rangeConstant(String constant, int begin, int end) {
        }

        @Override
        public void rangeDelimiter(String delimiter, int begin, int end) {
        }

        public String toString() {
            return "command:" + this.sqlCommand + " editable:" + this.editable + " inputItems:" + this.sqlInputParameter.getInputItemNames() + "[" + this.sqlSentence + "]";
        }
    }
}

