/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SysinfoTest
extends BaseJDBCTestCase {
    private static String TARGET_POLICY_FILE_NAME = "sysinfo.policy";
    private ArrayList OUTPUT;
    private static boolean useProperties = false;

    public SysinfoTest(String name) {
        super(name);
        ArrayList<String> OUTPUT1 = new ArrayList<String>();
        OUTPUT1.add("--------- Derby Network Server Information --------");
        OUTPUT1.add("derby.drda.maxThreads=0");
        OUTPUT1.add("derby.drda.sslMode=off");
        OUTPUT1.add("derby.drda.keepAlive=true");
        OUTPUT1.add("derby.drda.minThreads=0");
        OUTPUT1.add("derby.drda.portNumber=" + TestConfiguration.getCurrent().getPort());
        OUTPUT1.add("derby.drda.logConnections=false");
        OUTPUT1.add("derby.drda.timeSlice=0");
        OUTPUT1.add("derby.drda.startNetworkServer=false");
        OUTPUT1.add("derby.drda.traceAll=false");
        OUTPUT1.add("--------- Derby Information --------");
        OUTPUT1.add("------------------------------------------------------");
        OUTPUT1.add("----------------- Locale Information -----------------");
        OUTPUT1.add("------------------------------------------------------");
        ArrayList OUTPUT2 = (ArrayList)OUTPUT1.clone();
        OUTPUT2.add("--------- Derby Network Server Information --------");
        OUTPUT2.add("derby.drda.securityMechanism=USER_ONLY_SECURITY");
        this.OUTPUT = useProperties ? OUTPUT2 : OUTPUT1;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SysinfoTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        useProperties = false;
        if (!TestConfiguration.loadingFromJars()) {
            Properties propstmp = new Properties();
            propstmp.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
            suite.addTest((Test)new SystemPropertyTestSetup(SysinfoTest.decorateTest(), propstmp));
        } else {
            suite.addTest(SysinfoTest.decorateTest());
        }
        useProperties = true;
        Properties sysprops = new Properties();
        if (!TestConfiguration.loadingFromJars()) {
            sysprops.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
        }
        sysprops.put("derby.infolog.append", "true");
        sysprops.put("derby.language.logStatementText", "true");
        sysprops.put("derby.drda.securityMechanism", "USER_ONLY_SECURITY");
        TestSetup test = new SystemPropertyTestSetup(SysinfoTest.decorateTest(), sysprops);
        Properties prop = new Properties();
        prop.put("derby.locks.waitTimeout", "120");
        test = new DatabasePropertyTestSetup((Test)test, prop);
        suite.addTest((Test)test);
        return suite;
    }

    private String makePolicyName() {
        try {
            String userDir = SysinfoTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            SysinfoTest.fail((String)("Unexpected exception caught by makeServerPolicyName(): " + e));
            return null;
        }
    }

    private static Test decorateTest() {
        String policyName = new SysinfoTest("test").makePolicyName();
        Object test = TestConfiguration.clientServerSuite(SysinfoTest.class);
        test = TestConfiguration.singleUseDatabaseDecorator((Test)new SecurityManagerSetup((Test)test, policyName));
        String POLICY_FILE_NAME = "functionTests/tests/derbynet/SysinfoTest.policy";
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    public void testSysinfo() throws Exception {
        String[] SysInfoCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process p = SysinfoTest.execJavaCmd(SysInfoCmd);
        String s = SysinfoTest.readProcessOutput(p);
        this.print("testSysinfo", s);
        this.assertMatchingStringExists(s);
    }

    public void testSysinfoMethod() throws Exception {
        String s = NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getSysinfo();
        this.print("testSysinfoMethod", s);
        this.assertMatchingStringExists(s);
    }

    public void testSysinfoLocale() throws Exception {
        String[] SysInfoLocaleCmd = new String[]{"-Duser.language=de", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process p = SysinfoTest.execJavaCmd(SysInfoLocaleCmd);
        String s = SysinfoTest.readProcessOutput(p);
        this.print("testSysinfoLocale", s);
        this.assertMatchingStringExists(s);
    }

    private void print(String name, String s) {
        SysinfoTest.println("\n\n>>>" + name + ">>>");
        SysinfoTest.println(s);
        SysinfoTest.println("<<<" + name + "<<<\n\n");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        TARGET_POLICY_FILE_NAME = null;
        this.OUTPUT = null;
    }

    private static String findClassDir() {
        URL url = null;
        try {
            final Class<?> cl = Class.forName("org.apache.derbyTesting.functionTests.tests.derbynet.SysinfoTest");
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getProtectionDomain().getCodeSource().getLocation();
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return url.getPath();
    }

    private void assertMatchingStringExists(String actualOutput) {
        for (int i = 0; i < this.OUTPUT.size(); ++i) {
            String s = (String)this.OUTPUT.get(i);
            SysinfoTest.assertTrue((String)("cannot find " + s + " in actualOutput:" + actualOutput), (actualOutput.indexOf(s) >= 0 ? 1 : 0) != 0);
        }
    }
}

