/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.net.Utf8CcsidManager;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Utf8CcsidManagerClientTest
extends BaseTestCase {
    private Utf8CcsidManager ccsidManager = new Utf8CcsidManager();

    public Utf8CcsidManagerClientTest(String name) {
        super(name);
    }

    public void testConvertFromJavaString() throws Exception {
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] utf8Converted = this.ccsidManager.convertFromJavaString(ucs2String, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes", (boolean)Arrays.equals(utf8Bytes, utf8Converted));
    }

    public void testConvertFromJavaStringWithOffset() throws Exception {
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] additionalBytes = new String("\u53f0\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] buffer = new byte[additionalBytes.length];
        buffer[0] = additionalBytes[0];
        buffer[1] = additionalBytes[1];
        buffer[2] = additionalBytes[2];
        this.ccsidManager.convertFromJavaString(ucs2String, buffer, 3, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes (with buffer)", (boolean)Arrays.equals(additionalBytes, buffer));
    }

    public void testConvertToJavaString() throws Exception {
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        String offsetUcs2String = new String(new String("\u597d\u4e16").getBytes("UTF-16"), "UTF-16");
        String convertedString = this.ccsidManager.convertToJavaString(utf8Bytes);
        Utf8CcsidManagerClientTest.assertEquals((String)ucs2String, (String)convertedString);
        String convertedOffset = this.ccsidManager.convertToJavaString(utf8Bytes, 3, 6);
        Utf8CcsidManagerClientTest.assertEquals((String)offsetUcs2String, (String)convertedOffset);
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(Utf8CcsidManagerClientTest.class);
    }
}

