/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class LocalizedAttributeScriptTest
extends ScriptTestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LocalizedAttributeScriptTest.getSuite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("LocalizedScripts");
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        TestSuite localizedTests = new TestSuite("LocalizedScripts:embedded");
        localizedTests.addTest(LocalizedAttributeScriptTest.getSuite());
        TestSetup local = TestConfiguration.singleUseDatabaseDecoratorNoShutdown((Test)localizedTests);
        suite.addTest((Test)local);
        return suite;
    }

    private LocalizedAttributeScriptTest(String localizedTest) {
        super(localizedTest, "ISO-8859-1");
    }

    private static Test getSuite() {
        TestSuite suite = new TestSuite("localized scripts");
        Properties uiProps = new Properties();
        uiProps.put("derby.ui.locale", "de_DE");
        uiProps.put("derby.ui.codeset", "ISO-8859-1");
        suite.addTest((Test)new SystemPropertyTestSetup((Test)new LocalizedAttributeScriptTest("LocalizedConnectionAttribute"), uiProps));
        return LocalizedAttributeScriptTest.getIJConfig((Test)suite);
    }

    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                this.removeDatabase("detest");
                return null;
            }

            void removeDatabase(String dbName) {
                dbName = dbName.replace('/', File.separatorChar);
                String dsh = LocalizedAttributeScriptTest.getSystemProperty("derby.system.home");
                if (dsh == null) {
                    Assert.fail((String)"not implemented");
                } else {
                    dbName = dsh + File.separator + dbName;
                }
                this.removeDirectory(dbName);
            }

            void removeDirectory(String path) {
                File dir = new File(path);
                this.removeDir(dir);
            }

            private void removeDir(File dir) {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(dir, list[i]);
                        if (entry.isDirectory()) {
                            this.removeDir(entry);
                            continue;
                        }
                        entry.delete();
                    }
                }
                dir.delete();
            }
        });
        super.tearDown();
    }
}

