/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobStoredProcedureTest
extends BaseJDBCTestCase {
    final String testStr = "I am a simple derby test case";
    final long testStrLength = "I am a simple derby test case".length();

    public BlobStoredProcedureTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty: client not supported on JSR169; procs use DriverMgr");
        }
        return TestConfiguration.defaultSuite(BlobStoredProcedureTest.class);
    }

    protected void setUp() throws SQLException, UnsupportedEncodingException {
        byte[] strBytes = "I am a simple derby test case".getBytes("US-ASCII");
        int locator = -1;
        this.getConnection().setAutoCommit(false);
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setLong(2, 1L);
        cs.setInt(3, (int)this.testStrLength);
        cs.setBytes(4, strBytes);
        cs.execute();
        cs.close();
    }

    protected void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testBlobGetBytesSP() throws SQLException, UnsupportedEncodingException {
        String testSubStr = "I am a simple derby test case".substring(0, 10);
        byte[] testSubBytes = testSubStr.getBytes("US-ASCII");
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBGETBYTES(?,?,?)");
        cs.registerOutParameter(1, -3);
        cs.setInt(2, 1);
        cs.setLong(3, 1L);
        cs.setInt(4, 10);
        cs.executeUpdate();
        byte[] retVal = cs.getBytes(1);
        for (int i = 0; i < 10; ++i) {
            BlobStoredProcedureTest.assertEquals((String)"The Stored procedure SYSIBM.BLOBGETBYTES returns the wrong bytes", (byte)testSubBytes[i], (byte)retVal[i]);
        }
        cs.close();
    }

    public void testBlobCreateLocatorSP() throws SQLException {
        int locator = -1;
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        BlobStoredProcedureTest.assertEquals((String)"The locator values returned by SYSIBM.BLOBCREATELOCATOR() are incorrect", (int)2, (int)locator);
        cs.close();
    }

    public void testBlobReleaseLocatorSP() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.BLOBRELEASELOCATOR(?)");
        cs.setInt(1, 1);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        try {
            cs.executeUpdate();
        }
        catch (SQLException sqle) {
            return;
        }
        BlobStoredProcedureTest.fail((String)"Error the locator was not released by SYSIBM.BLOBRELEASELOCATOR");
        cs.close();
    }

    public void testBlobGetLengthSP() throws SQLException {
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETLENGTH returns the wrong value for the length of the Blob", (long)this.testStrLength, (long)cs.getLong(1));
        cs.close();
    }

    public void testBlobGetPositionFromBytesSP() throws Exception {
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBGETPOSITIONFROMBYTES(?,?,?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.setBytes(3, new String("simple").getBytes("US-ASCII"));
        cs.setLong(4, 1L);
        cs.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETPOSITIONFROMBYTES returns the wrong value for the position of the Blob", (long)8L, (long)cs.getLong(1));
        cs.close();
    }

    public void testBlobSetBytes() throws SQLException, UnsupportedEncodingException {
        String newString = "123456789012345";
        byte[] newBytes = newString.getBytes("US-ASCII");
        int locator = -1;
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setLong(2, 1L);
        cs.setInt(3, newString.length());
        cs.setBytes(4, newBytes);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.BLOBGETBYTES(?,?,?)");
        cs.registerOutParameter(1, -3);
        cs.setInt(2, locator);
        cs.setLong(3, 1L);
        cs.setInt(4, newString.length());
        cs.executeUpdate();
        byte[] retVal = cs.getBytes(1);
        for (int i = 0; i < newString.length(); ++i) {
            BlobStoredProcedureTest.assertEquals((String)"The Stored procedure SYSIBM.BLOBGETBYTES returns the wrong bytes", (byte)newBytes[i], (byte)retVal[i]);
        }
        cs.close();
    }

    public void testBlobTruncateSP() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.BLOBTRUNCATE(?,?)");
        cs.setInt(1, 1);
        cs.setLong(2, 10L);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETLENGTH returns the wrong value for the length of the Blob", (long)10L, (long)cs.getLong(1));
        cs.close();
    }

    public void testBlobGetPositionFromLocatorSP() throws SQLException, UnsupportedEncodingException {
        String newString = "simple";
        byte[] newBytes = newString.getBytes("US-ASCII");
        int locator = -1;
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setLong(2, 1L);
        cs.setInt(3, newString.length());
        cs.setBytes(4, newBytes);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.BLOBGETPOSITIONFROMLOCATOR(?,?,?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.setInt(3, locator);
        cs.setLong(4, 1L);
        cs.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETPOSITIONFROMLOCATOR returns the wrong value for the position of the Blob", (long)8L, (long)cs.getLong(1));
        cs.close();
    }
}

