/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class AlterTableTest
extends BaseJDBCTestCase {
    ResultSet rs = null;
    ResultSetMetaData rsmd;
    DatabaseMetaData dbmd;
    SQLWarning sqlWarn = null;
    PreparedStatement pSt;
    CallableStatement cSt;
    Connection conn;
    String[][] expRS;
    String[] expColNames;

    public AlterTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AlterTableTest Test");
        suite.addTest(TestConfiguration.defaultSuite(AlterTableTest.class));
        return TestConfiguration.sqlAuthorizationDecorator((Test)suite);
    }

    private void createTestObjects(Statement st) throws SQLException {
        this.conn = this.getConnection();
        this.conn.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(this.conn, false);
        st.executeUpdate("create table t0(c1 int not null constraint p1 primary key)");
        st.executeUpdate("create table t0_1(c1 int)");
        st.executeUpdate("create table t0_2(c1 int)");
        st.executeUpdate("create table t0_3(c1 int)");
        st.executeUpdate("create table t1(c1 int)");
        st.executeUpdate("create table t1_1(c1 int)");
        st.executeUpdate("create table t2(c1 int)");
        st.executeUpdate("create table t3(c1 int)");
        st.executeUpdate("create table t4(c1 int not null)");
        st.executeUpdate("create view v1 as select * from t2");
        st.executeUpdate("create view v2 as select c1 from t2");
        st.executeUpdate("create index i0_1 on t0_1(c1)");
        st.executeUpdate("create index i0_2 on t0_2(c1)");
        st.executeUpdate("insert into t1 values 1");
        st.executeUpdate("insert into t1_1 values 1");
        st.executeUpdate("insert into t2 values 1");
        st.executeUpdate("insert into t2 values 2");
        st.executeUpdate("insert into t3 values 1");
        st.executeUpdate("insert into t3 values 2");
        st.executeUpdate("insert into t3 values 3");
        st.executeUpdate("insert into t4 values 1, 2, 3, 1");
        st.executeUpdate("create schema emptyschema");
    }

    private void checkWarning(Statement st, String expectedWarning) throws Exception {
        if (this.sqlWarn == null && st != null) {
            this.sqlWarn = st.getWarnings();
        }
        if (this.sqlWarn == null) {
            this.sqlWarn = this.getConnection().getWarnings();
        }
        AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)this.sqlWarn);
        AlterTableTest.assertSQLState(expectedWarning, this.sqlWarn);
        this.sqlWarn = null;
    }

    public void testAddColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        this.conn.commit();
        AlterTableTest.assertStatementError("42Y55", st, "alter table notexists add column c1 int");
        AlterTableTest.assertStatementError("X0Y32", st, "alter table t0 add column c1 int");
        AlterTableTest.assertStatementError("42XA9", st, "alter table t0 add column y");
        AlterTableTest.assertStatementError("42X62", st, "alter table sys.systables add column c1 int");
        AlterTableTest.assertStatementError("42Y62", st, "alter table v2 add column c2 int");
        AlterTableTest.assertStatementError("X0Y58", st, "alter table t0 add column c2 int not null default 0 primary key");
        AlterTableTest.assertStatementError("23505", st, "alter table t3 add column c2 int not null default 0 unique");
        PreparedStatement ps_c1 = this.prepareStatement("select * from t1");
        ResultSet c1 = ps_c1.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", st, " alter table t1 add column c2 int");
        }
        c1.close();
        ps_c1.close();
        st.executeUpdate("alter table t1 add column c2 int not null default 0");
        st.executeUpdate("alter table t1 add column c3 int not null default 0 primary key");
        st.executeUpdate("alter table t1 add column c4 int check(c4 = 1)");
        this.rs = st.executeQuery("select * from v1");
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1"}, {"2"}});
        this.pSt = this.prepareStatement("select * from t2");
        this.rs = this.pSt.executeQuery();
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1"}, {"2"}});
        st.executeUpdate("alter table t2 add column c2 int");
        this.rs = st.executeQuery("select * from v1");
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1"}, {"2"}});
        if (AlterTableTest.usingEmbedded()) {
            this.rs = this.pSt.executeQuery();
            JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2"});
            JDBC.assertFullResultSet(this.rs, new String[][]{{"1", null}, {"2", null}});
        } else {
            this.rs = this.pSt.executeQuery();
            JDBC.assertColumnNames(this.rs, new String[]{"C1"});
            JDBC.assertFullResultSet(this.rs, new String[][]{{"1"}, {"2"}});
        }
        st.executeUpdate("alter table t0 add column c2 int not null default 0");
        st.executeUpdate("insert into t0 values (1, default)");
        this.rs = st.executeQuery("select * from t0");
        JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "0"}});
        st.executeUpdate("drop table t0");
        this.conn.rollback();
        this.rs = st.executeQuery(" select  * from t0");
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate("alter table t0_1 add column c2 int not null primary key default 0");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError("23505", st, "insert into t0_1 values (1, 1)");
        this.rs = st.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "1"}});
        this.conn.rollback();
        st.executeUpdate("alter table t0_1 add column c2 int not null unique  default 0");
        st.executeUpdate(" insert into t0_1 values (1, default)");
        AlterTableTest.assertStatementError("23505", st, " insert into t0_1 values (2, default)");
        st.executeUpdate("insert into t0_1 values (3, 1)");
        st.executeUpdate("drop table t1");
        st.executeUpdate("create table t1(c1 int)");
        st.executeUpdate(" alter table t1 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t1 values (2, 2)");
        st.executeUpdate("insert into t1 values (3, 1)");
        this.rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        this.expRS = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(this.rs, this.expRS, true);
        this.conn.rollback();
        st.executeUpdate(" create function countopens() returns varchar(128) language java parameter style java external name 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.countOpens'");
        this.conn.commit();
        this.rs = st.executeQuery("values countopens()");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"No open scans, etc."}});
    }

    public void testDropObjects() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table tab1 (c1 int, c2 int not null constraint tab1pk primary key, c3 double, c4 int)");
        st.executeUpdate("create index i11 on tab1 (c1)");
        st.executeUpdate("create unique index i12 on tab1 (c1)");
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        st.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        st.executeUpdate("insert into tab1 values (6, 5, 4.5, 90)");
        st.executeUpdate("insert into tab1 values (10, 3, 8.9, -5)");
        st.executeUpdate("insert into tab1 values (100, 15, 4.5, 9)");
        st.executeUpdate("insert into tab1 values (2, 8, 4.4, 8)");
        st.executeUpdate("insert into tab1 values (11, 9, 2.5, 88)");
        st.executeUpdate("insert into tab1 values(null,10, 3.5, 99)");
        st.executeUpdate("create view vw1 (col_sum, col_diff) as select c1+c4, c1-c4 from tab1");
        st.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        st.executeUpdate("create table tab2 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint c4_PK primary key, c5 int, constraint t2ck check (c2+c3<100.0))");
        st.executeUpdate("create table tab3 (c1 int, c2 int, c3 int, c4 int,constraint t3fk foreign key (c2) references tab2(c1), constraint t3ck check (c2-c3<80))");
        st.executeUpdate("create view vw3 (c1, c2) as select c5, tab3.c4 from tab2, tab3 where tab3.c1 > 0");
        st.executeUpdate(" create view vw4 (c1) as select c4 from tab3 where c2 > 8");
        st.executeUpdate("create table tab4 (c1 int, c2 int, c3 int, c4 int)");
        st.executeUpdate("create table tab5 (c1 int)");
        st.executeUpdate("insert into tab4 values (1,2,3,4)");
        st.executeUpdate("create trigger tr1 after update of c2, c3, c4 on tab4 for each row insert into tab5 values (1)");
        st.executeUpdate("create trigger tr2 after update of c3, c4 on tab4 for each row insert into tab5 values (2)");
        st.executeUpdate("drop trigger tr1");
        this.rs = st.executeQuery("select * from tab5");
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertDrainResults(this.rs, 0);
        AlterTableTest.assertUpdateCount(st, 1, "update tab4 set c3 = 33");
        AlterTableTest.assertUpdateCount(st, 1, " update tab4 set c4 = 44");
        this.rs = st.executeQuery("select * from tab5");
        JDBC.assertColumnNames(this.rs, new String[]{"C1"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"2"}, {"2"}});
        st.executeUpdate("drop trigger tr2");
        AlterTableTest.assertUpdateCount(st, 1, "update tab4 set c4 = 444");
        this.rs = st.executeQuery("select * from tab2");
        this.expColNames = new String[]{"C1", "C2", "C3", "C4", "C5"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate("drop view vw2");
        st.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        st.executeUpdate("drop view vw1");
        AlterTableTest.assertStatementError("42X05", st, "select * from vw1");
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        this.checkWarning(st, "01504");
        st.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        this.checkWarning(st, "01504");
        st.executeUpdate("create unique index i12 on tab1 (c1)");
        this.checkWarning(st, "01504");
        this.rs = st.executeQuery("select c2, c3, c4 from tab1 order by c3");
        this.expColNames = new String[]{"C2", "C3", "C4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"9", "2.5", "88"}, {"10", "3.5", "99"}, {"8", "4.4", "8"}, {"15", "4.5", "9"}, {"5", "4.5", "90"}, {"3", "8.9", "-5"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("drop index i12");
        st.executeUpdate("drop index i13");
        st.executeUpdate("drop index i14");
        st.executeUpdate("insert into tab1 (c2, c3, c4) values (22, 8.9, 5)");
        st.executeUpdate("insert into tab1 (c2, c3, c4) values (11, 4.5, 67)");
        this.rs = st.executeQuery("select c2 from tab1");
        this.expColNames = new String[]{"C2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"3"}, {"5"}, {"8"}, {"9"}, {"10"}, {"11"}, {"15"}, {"22"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("alter table tab1 add column c5 double");
        st.executeUpdate("drop view vw2");
        st.executeUpdate(" create view vw2 (c1) as select c5 from tab1 where c2 > 5");
        st.executeUpdate("drop view vw2");
        st.executeUpdate("alter table tab1 drop constraint tab1pk");
        this.rs = st.executeQuery("select c4 from tab1 order by 1");
        this.expRS = new String[][]{{"-5"}, {"5"}, {"8"}, {"9"}, {"67"}, {"88"}, {"90"}, {"99"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        st.executeUpdate("alter table tab2 drop constraint t2ck");
        st.executeUpdate("alter table tab3 drop constraint t3fk");
        st.executeUpdate("alter table tab2 drop constraint c4_PK");
        st.executeUpdate("insert into tab3 values (1,2,3,4)");
        st.executeUpdate("drop view vw3");
        st.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 1, 2)");
        st.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 2, 2)");
        st.executeUpdate("alter table tab3 drop constraint t3ck");
        st.executeUpdate("drop view vw4");
        st.executeUpdate("insert into tab3 (c2, c3) values (-82, 9)");
        st.executeUpdate(" create view vw4 (c1) as select c3 from tab3 where c3+5>c4");
        st.executeUpdate("drop view vw4");
        this.conn.rollback();
        st.executeUpdate("create table tt1(a int, b int not null constraint tt1uc unique)");
        st.executeUpdate(" create table reftt1(a int constraint reftt1rc references tt1(b))");
        this.rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(this.rs, "2");
        st.executeUpdate("alter table reftt1 drop constraint reftt1rc");
        st.executeUpdate("alter table tt1 drop constraint tt1uc");
        this.rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(this.rs, "1");
        this.conn.rollback();
    }

    public void testAddConstraint() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("alter table t0 add column c3 int");
        AlterTableTest.assertStatementError("42831", st, " alter table t0 add constraint cons1 primary key(c3)");
        AlterTableTest.assertStatementError("42831", st, " alter table t0 add primary key(c3)");
        AlterTableTest.assertStatementError("42X14", st, "alter table t4 add constraint t4pk primary key(\"c1\")");
        AlterTableTest.assertStatementError("42X14", st, " alter table t4 add constraint t4uq unique(\"c1\")");
        AlterTableTest.assertStatementError("42X14", st, " alter table t4 add constraint t4fk foreign key (\"c1\") references t0");
        AlterTableTest.assertStatementError("42X04", st, " alter table t4 add constraint t4ck check (\"c1\" <> 4)");
        AlterTableTest.assertStatementError("23505", st, "alter table t4 add primary key(c1)");
        st.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError("23505", st, "insert into t0_1 values (1, 1)");
        this.rs = st.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "1"}});
        st.executeUpdate("alter table t0_1 add column c3 int check(c3 != 3)");
        st.executeUpdate("insert into t0_1 values (1, 2, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_1 values (1, 3, 3)");
        st.executeUpdate("insert into t0_1 values (1, 4, 1)");
        this.rs = st.executeQuery("select c1,c3 from t0_1");
        JDBC.assertUnorderedResultSet(this.rs, new String[][]{{"1", null}, {"1", "1"}, {"1", "1"}});
        st.executeUpdate("alter table t0_1 add column c4 int");
        st.executeUpdate("delete from t0_1");
        st.executeUpdate("insert into t0_1 values (1, 5,1,1)");
        st.executeUpdate("insert into t0_1 values (2, 6,1,2)");
        st.executeUpdate(" alter table t0_1 add constraint ck1 check(c4 = c1)");
        this.rs = st.executeQuery("select c1,c4 from t0_1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "1"}, {"2", "2"}});
        AlterTableTest.assertStatementError("23513", st, "insert into t0_1(c1,c4) values (1, 3)");
        st.executeUpdate("drop table t0_1");
        st.executeUpdate("create table t0_1 (c1 int)");
        st.executeUpdate("alter table t0_1 add column c2 int");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (666, 2)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (3, 3)");
        st.executeUpdate("insert into t0_1 values (666, 3)");
        st.executeUpdate("insert into t0_1 values (666, 3)");
        st.executeUpdate("insert into t0_1 values (3, 3)");
        AlterTableTest.assertStatementError("X0Y59", st, " alter table t0_1 add constraint ck1 check(c2 = c1)");
        st.executeUpdate("insert into t0_1 values (1, 3)");
        this.rs = st.executeQuery(" select * from t0_1");
        this.expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"2", "2"}, {"666", "2"}, {"2", "2"}, {"3", "3"}, {"666", "3"}, {"666", "3"}, {"3", "3"}, {"1", "3"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("create table t0_4(c1 int)");
        st.executeUpdate("alter table t0_4 add column c2 int not null constraint p2 primary key default 0");
        st.executeUpdate("alter table t0_4 add check(c2 = c1)");
        st.executeUpdate("insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_4 values (1, 2)");
        AlterTableTest.assertStatementError("23505", st, "insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_4 values (2, 1)");
        st.executeUpdate("insert into t0_4 values (2, 2)");
        this.rs = st.executeQuery("select * from t0_4");
        JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2"});
        JDBC.assertUnorderedResultSet(this.rs, new String[][]{{"1", "1"}, {"2", "2"}});
        st.executeUpdate("drop table t0_4");
        st.executeUpdate("alter table t3 add column c3 int");
        st.executeUpdate("alter table t3 add unique(c3)");
        st.executeUpdate("alter table t0_2 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t0_2 values (1, default)");
        st.executeUpdate("insert into t0_2 values (1, 1)");
        AlterTableTest.assertUpdateCount(st, 1, " delete from t1_1");
        st.executeUpdate("alter table t1_1 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t1_1 values (1, 2)");
        AlterTableTest.assertStatementError("23505", st, " insert into t1_1 values (1, 2)");
        st.executeUpdate("insert into t1_1 values (1, 1)");
        st.executeUpdate("alter table t3 add unique(c1)");
        this.assertCompileError("42Y55", "alter table xxx add check(c2 = 1)");
        st.executeUpdate("create table xxx(c1 int, c2 int)");
        this.pSt = this.prepareStatement("alter table xxx add check(c2 = 1)");
        AlterTableTest.assertUpdateCount(this.pSt, 0);
        st.executeUpdate("drop table xxx");
        st.executeUpdate("create table xxx(c1 int)");
        AlterTableTest.assertStatementError("42X04", this.pSt);
        st.executeUpdate("alter table xxx add column c2 int");
        AlterTableTest.assertUpdateCount(this.pSt, 0);
        st.executeUpdate("drop table xxx");
        this.rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        this.expColNames = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(this.rs, this.expRS, true);
    }

    public void testDropConstraint() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        AlterTableTest.assertStatementError("42X86", st, "alter table t0 drop constraint notexists");
        AlterTableTest.assertStatementError("42X86", st, "alter table t1 drop constraint p1");
        AlterTableTest.assertStatementError("42831", st, "alter table t0_1 add constraint p2 primary key(c1)");
        AlterTableTest.assertStatementError("42X86", st, " alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        AlterTableTest.assertUpdateCount(st, 0, "delete from t0_1");
        st.executeUpdate("alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        st.executeUpdate("alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        st.executeUpdate("insert into t0_1 values (1,1)");
        AlterTableTest.assertStatementError("23505", st, "insert into t0_1 values (1,1)");
        this.rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T' and tablename = 'T0_1'");
        this.expColNames = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"T0_1", "1"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        this.pSt = this.prepareStatement("alter table t0_1 drop constraint p2");
        AlterTableTest.assertUpdateCount(this.pSt, 0);
        st.executeUpdate("drop table t0_1");
        st.executeUpdate(" create table t0_1 (c1 int, c2 int not null constraint p2 primary key)");
        AlterTableTest.assertUpdateCount(this.pSt, 0);
        this.rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where tabletype = 'S' and tablename != 'SYSDUMMY1'");
        this.expRS = new String[][]{{"SYSCONGLOMERATES", "1"}, {"SYSTABLES", "1"}, {"SYSCOLUMNS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSKEYS", "1"}, {"SYSDEPENDS", "1"}, {"SYSALIASES", "1"}, {"SYSVIEWS", "1"}, {"SYSCHECKS", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSFILES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSROLES", "1"}, {"SYSSEQUENCES", "1"}, {"SYSPERMS", "1"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        this.rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        this.expRS = new String[][]{{"T0", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}, {"T0_1", "1"}};
        JDBC.assertUnorderedResultSet(this.rs, this.expRS, true);
        st.executeUpdate("create table b793 (pn1 int not null constraint named_primary primary key, pn2 int constraint named_pn2 check (pn2 > 3))");
        st.executeUpdate("alter table b793 drop constraint named_primary");
        st.executeUpdate("drop table b793");
        st.executeUpdate("drop table t1");
        st.executeUpdate(" create table t1(a int not null constraint t1_pri primary key)");
        st.executeUpdate(" create table reft1(a int constraint t1_ref references t1(a))");
        this.rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(this.rs, "2");
        st.executeUpdate("alter table reft1 drop constraint t1_ref");
        st.executeUpdate("alter table t1 drop constraint t1_pri");
        this.rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(this.rs, "1");
        st.executeUpdate("drop table reft1");
        st.executeUpdate("drop view v2");
        st.executeUpdate("drop view v1");
        st.executeUpdate("drop table t0");
        st.executeUpdate("drop table t0_1");
        st.executeUpdate("drop table t0_2");
        st.executeUpdate("drop table t0_3");
        st.executeUpdate("drop table t1");
        st.executeUpdate("drop table t1_1");
        st.executeUpdate("drop table t3");
        st.executeUpdate("drop table t4");
    }

    public void testWithSchema() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create schema newschema");
        AlterTableTest.assertStatementError("42Y55", st, "drop table x");
        st.executeUpdate("create table x (x int not null, y int not null)");
        st.executeUpdate("alter table x add constraint NEWCONS primary key (x)");
        this.rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError("23505", st, " insert into x values (1,1),(1,1)");
        st.executeUpdate(" alter table x drop constraint TEST_DBO.newcons");
        st.executeUpdate(" alter table x add constraint newcons primary key (x)");
        this.rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError("42Y07", st, "alter table x drop constraint badschema.newcons");
        AlterTableTest.assertStatementError("42X86", st, "alter table x drop constraint newschema.newcons");
        st.executeUpdate("alter table x drop constraint TEST_DBO.newcons");
        AlterTableTest.assertStatementError("42X85", st, "alter table x add constraint badschema.newcons primary key (x)");
        st.executeUpdate("drop table x");
        st.executeUpdate("create table x (x int not null, y int not null)");
        st.executeUpdate("alter table x add constraint con check (x > 1)");
        AlterTableTest.assertStatementError("42X85", st, " alter table x add constraint newschema.con check (x > 1)");
        this.rs = st.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        st.executeUpdate("set schema emptyschema");
        AlterTableTest.assertStatementError("42X86", st, "alter table TEST_DBO.x drop constraint emptyschema.con");
        this.rs = st.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        st.executeUpdate(" set schema newschema");
        st.executeUpdate("alter table TEST_DBO.x add constraint con2 check (x > 1)");
        this.rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1,2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"TEST_DBO", "CON"}, {"TEST_DBO", "CON2"}, {"TEST_DBO", "P1"}});
        st.executeUpdate("drop table TEST_DBO.x");
        st.executeUpdate("drop schema newschema restrict");
    }

    public void testTemporaryTable() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        AlterTableTest.assertUpdateCount(st, 0, "declare global temporary table session.t1 (c11 int) not logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.t2 (c21 int) on commit delete rows not logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.t3 (c31 int) on commit preserve rows not logged");
        st.executeUpdate("drop table session.t1");
        st.executeUpdate("drop table session.t2");
        st.executeUpdate("drop table session.t3");
        AlterTableTest.assertStatementError("42Y55", st, "drop table session.t1");
        st.executeUpdate("drop table t1");
        st.executeUpdate("create table t1(c1 int, c2 int not null primary key)");
        st.executeUpdate("insert into t1 values (1, 1)");
        AlterTableTest.assertStatementError("23505", st, "insert into t1 values (1, 1)");
        st.executeUpdate("alter table t1 drop primary key");
        st.executeUpdate("insert into t1 values (1, 1)");
        this.rs = st.executeQuery("select * from t1");
        this.expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1"}, {"1", "1"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        AlterTableTest.assertStatementError("42X86", st, " alter table t1 drop primary key");
        AlterTableTest.assertStatementError("42X86", st, " alter table t1 drop constraint emptyschema.C1");
        AlterTableTest.assertStatementError("42Y07", st, " alter table t1 drop constraint nosuchschema.C2");
        AlterTableTest.assertStatementError("42X85", st, " alter table t1 add constraint emptyschema.C1_PLUS_C2 check ((c1 + c2) < 100)");
        st.executeUpdate(" alter table t1 add constraint C1_PLUS_C2 check ((c1 + c2) < 100)");
        this.pSt = this.prepareStatement("alter table t1 drop constraint C1_PLUS_C2");
        st.executeUpdate(" alter table TEST_DBO.t1 drop constraint TEST_DBO.C1_PLUS_C2");
        AlterTableTest.assertStatementError("42X86", this.pSt);
        st.executeUpdate(" drop table t1");
        st.executeUpdate("create table LOGGED(c11 int)");
        st.executeUpdate("drop table LOGGED");
        st.executeUpdate("create table logged(logged int)");
        st.executeUpdate("drop table logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.logged(logged int) on commit delete rows not logged");
    }

    public void testRenameAutoincrementColumn() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table d4693(a int generated always as identity, b int)");
        JDBC.assertFullResultSet(st.executeQuery("select columnname,columnnumber,columndatatype,       autoincrementvalue,       autoincrementstart,       autoincrementinc from sys.syscolumns where       columnname = 'A' and       referenceid in (select tableid              from sys.systables where tablename = 'D4693')"), new String[][]{{"A", "1", "INTEGER NOT NULL", "1", "1", "1"}});
        st.executeUpdate("insert into d4693 (b) values (1)");
        st.executeUpdate("rename column d4693.a to a2");
        JDBC.assertFullResultSet(st.executeQuery("select columnname,columnnumber,columndatatype,       autoincrementvalue,       autoincrementstart,       autoincrementinc from sys.syscolumns where       columnname = 'A2' and       referenceid in (select tableid              from sys.systables where tablename = 'D4693')"), new String[][]{{"A2", "1", "INTEGER NOT NULL", "2", "1", "1"}});
        st.executeUpdate("insert into d4693 (b) values (2)");
        JDBC.assertFullResultSet(st.executeQuery("select a2, b from d4693"), new String[][]{{"1", "1"}, {"2", "2"}});
        st.executeUpdate("drop table d4693");
        String[] colspecs = new String[]{"autoinc int generated always as identity (start with 100)", "autoinc1 int generated always as identity (increment by 100)", "autoinc2 int generated always as identity (start with 101, increment by 100)", "a11 int generated always as identity (start with  0, increment by -1)", "a21 int generated always as identity (start with  +0, increment by -1)", "a31 int generated always as identity (start with  -1, increment by -1)", "a41 int generated always as identity (start with  -11, increment by +100)"};
        String[] cn = new String[]{"AUTOINC", "AUTOINC1", "AUTOINC2", "A11", "A21", "A31", "A41"};
        String[] val = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] start = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] inc = new String[]{"1", "100", "100", "-1", "-1", "-1", "100"};
        for (int i = 0; i < colspecs.length; ++i) {
            st.executeUpdate("create table d4693 (" + colspecs[i] + ")");
            this.checkValStartInc(st, cn[i], val[i], start[i], inc[i]);
            st.executeUpdate("rename column d4693." + cn[i] + " to " + cn[i] + "2");
            this.checkValStartInc(st, cn[i] + "2", val[i], start[i], inc[i]);
            st.executeUpdate("drop table d4693");
        }
    }

    private void checkValStartInc(Statement st, String nm, String v, String s, String inc) throws Exception {
        JDBC.assertFullResultSet(st.executeQuery("select autoincrementvalue,autoincrementstart,autoincrementinc from sys.syscolumns where columnname = '" + nm + "' and " + "      referenceid in (select tableid " + "             from sys.systables where tablename = 'D4693')"), new String[][]{{v, s, inc}});
    }

    public void testAlterColumn() throws Exception {
        int i;
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atmcn_1 (a integer, b integer not null)");
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (a) values (1)");
        st.executeUpdate("insert into atmcn_1 values (1,1)");
        this.rs = st.executeQuery("select * from atmcn_1");
        this.expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("alter table atmcn_1 alter column a not null");
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (b) values (2)");
        st.executeUpdate("insert into atmcn_1 values (2,2)");
        this.rs = st.executeQuery("select * from atmcn_1");
        this.expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("alter table atmcn_1 alter column b null");
        st.executeUpdate("insert into atmcn_1 (a) values (1)");
        this.rs = st.executeQuery("select * from atmcn_1");
        this.expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"1", null}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        AlterTableTest.assertStatementError("X0Y80", st, "alter table atmcn_1 alter column b not null");
        st.executeUpdate("create table atmcn_2 (a integer not null primary key, b integer not null)");
        AlterTableTest.assertStatementError("42Z20", st, " alter table atmcn_2 alter column a null");
        st.executeUpdate(" create table atmcn_3 (a integer not null, b integer not null)");
        st.executeUpdate(" alter table atmcn_3 add constraint atmcn_3_pk primary key(a, b)");
        AlterTableTest.assertStatementError("42Z20", st, " alter table atmcn_3 alter column b null");
        st.executeUpdate("create table atmcn_4 (a integer not null, b integer)");
        st.executeUpdate("alter table atmcn_4 alter a null");
        st.executeUpdate("create table atmcn_5 (a integer not null, b integer not null unique)");
        st.executeUpdate("alter table atmcn_5 alter column b null");
        st.executeUpdate("create table atmod_1 (a integer, b varchar(10))");
        st.executeUpdate("insert into atmod_1 values (1, 'one')");
        st.executeUpdate("alter table atmod_1 alter column a default -1");
        st.executeUpdate("insert into atmod_1 values (default, 'minus one')");
        st.executeUpdate("insert into atmod_1 (b) values ('b')");
        this.rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A", "B"});
        this.expRS = new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("alter table atmod_1 alter a default 42");
        st.executeUpdate("insert into atmod_1 values(3, 'three')");
        st.executeUpdate("insert into atmod_1 values (default, 'forty two')");
        this.rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A", "B"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}, {"3", "three"}, {"42", "forty two"}});
        st.executeUpdate("create table renc_1 (a int, b varchar(10), c timestamp, d double)");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_no_such.a to b");
        AlterTableTest.assertStatementError("42X14", st, "rename column renc_1.no_such to e");
        AlterTableTest.assertStatementError("X0Y32", st, "rename column renc_1.a to c");
        AlterTableTest.assertStatementError("X0Y32", st, "rename column renc_1.b to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to select");
        AlterTableTest.assertStatementError("42X62", st, "rename column sys.sysconglomerates.isindex to is_an_index");
        st.executeUpdate("create view renc_vw_1 (v1, v2) as select b, d from renc_1");
        AlterTableTest.assertStatementError("42Y62", st, " rename column renc_vw_1.v2 to v3");
        st.executeUpdate("create index renc_idx_1 on renc_1 (c, d)");
        AlterTableTest.assertStatementError("42Y55", st, " rename column renc_idx_1.d to d_new");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_1 to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1 rename a to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to b, c");
        AlterTableTest.assertStatementError("42X01", st, " rename column renc_1.a to b and c to d");
        st.executeUpdate("create table renc_2(c1 int not null constraint renc_2_p1 primary key)");
        st.executeUpdate("rename column renc_2.c1 to c2");
        this.dbmd = this.conn.getMetaData();
        this.rs = this.dbmd.getColumns(null, null, "RENC_2", "C2");
        AlterTableTest.assertTrue((boolean)this.rs.next());
        AlterTableTest.assertEquals((String)"C2", (String)this.rs.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)this.rs.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)this.rs.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)this.rs.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)this.rs.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)this.rs.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)this.rs.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)this.rs.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)this.rs.next());
        if (AlterTableTest.usingEmbedded()) {
            this.dbmd = this.conn.getMetaData();
            this.rs = this.dbmd.getIndexInfo(null, null, "RENC_2", false, false);
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_2", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)this.rs.next());
        }
        this.rs = st.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_2'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"RENC_2_P1", "P"}});
        st.executeUpdate(" create table renc_3 (a integer not null, b integer not null, c int, constraint renc_3_pk primary key(a, b))");
        st.executeUpdate("rename column renc_3.b to newbie");
        this.dbmd = this.conn.getMetaData();
        this.rs = this.dbmd.getColumns(null, null, "RENC_3", "NEWBIE");
        AlterTableTest.assertTrue((boolean)this.rs.next());
        AlterTableTest.assertEquals((String)"NEWBIE", (String)this.rs.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)this.rs.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)this.rs.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)this.rs.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)this.rs.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)this.rs.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)this.rs.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)this.rs.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)this.rs.next());
        if (AlterTableTest.usingEmbedded()) {
            this.dbmd = this.conn.getMetaData();
            this.rs = this.dbmd.getIndexInfo(null, null, "RENC_3", false, false);
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"NEWBIE", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)this.rs.next());
        }
        this.rs = st.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_3'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"RENC_3_PK", "P"}});
        st.executeUpdate(" create table renc_4 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint renc_4_c4_PK primary key, c5 int, c6 int, constraint renc_4_t2ck check (c2+c3<100.0))");
        st.executeUpdate(" create table renc_5 (c1 int, c2 int, c3 int, c4 int, c5 int not null, c6 int, constraint renc_5_t3fk foreign key (c2) references renc_4(c4), constraint renc_5_unq unique(c5), constraint renc_5_t3ck check (c2-c3<80))");
        AlterTableTest.assertStatementError("X0Y25", st, "rename column renc_4.c4 to another_c4");
        st.executeUpdate("rename column renc_4.c1 to unq_c1");
        if (AlterTableTest.usingEmbedded()) {
            this.dbmd = this.conn.getMetaData();
            this.rs = this.dbmd.getIndexInfo(null, null, "RENC_4", false, false);
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C1", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C4", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)this.rs.next());
        }
        st.executeUpdate("rename column renc_5.c5 to unq_c5");
        if (AlterTableTest.usingEmbedded()) {
            this.dbmd = this.conn.getMetaData();
            this.rs = this.dbmd.getIndexInfo(null, null, "RENC_5", false, false);
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C5", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)this.rs.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)this.rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)this.rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"true", (String)this.rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)this.rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)this.rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)this.rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)this.rs.next());
        }
        AlterTableTest.assertStatementError("42Z97", st, "rename column renc_4.c2 to some_other_name");
        st.executeUpdate("create trigger renc_5_tr1 after update of c2, c3, c6 on renc_4 for each row mode db2sql insert into renc_5 (c6) values (1)");
        AlterTableTest.assertStatementError("X0Y25", st, "rename column renc_4.c6 to some_name");
        st.executeUpdate("rename column renc_5.c6 to new_name");
        st.executeUpdate("insert into renc_4 values(1, 2, 3, 4, 5, 6)");
        AlterTableTest.assertStatementError("42X14", st, "update renc_4 set c6 = 92");
        this.rs = st.executeQuery("select * from renc_5");
        JDBC.assertColumnNames(this.rs, new String[]{"C1", "C2", "C3", "C4", "UNQ_C5", "NEW_NAME"});
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate("create table renc_6 (a int, b int, c int)");
        st.executeUpdate("grant select (a, b) on renc_6 to eranda");
        this.rs = st.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        st.executeUpdate("rename column renc_6.b to bb_gun");
        this.rs = st.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        PreparedStatement ps_renc_c1 = this.prepareStatement("select * from renc_6");
        ResultSet renc_c1 = ps_renc_c1.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", st, " rename column renc_6.bb_gun to water_pistol");
        }
        renc_c1.close();
        ps_renc_c1.close();
        this.conn.setAutoCommit(false);
        this.pSt = this.prepareStatement("select * from renc_6 where a = ?");
        this.rs = st.executeQuery("values (30)");
        this.rs.next();
        this.rsmd = this.rs.getMetaData();
        for (i = 1; i <= this.rsmd.getColumnCount(); ++i) {
            this.pSt.setObject(i, this.rs.getObject(i));
        }
        this.rs = this.pSt.executeQuery();
        this.expColNames = new String[]{"A", "BB_GUN", "C"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate(" rename column renc_6.a to abcdef");
        this.rs = st.executeQuery("values (30)");
        this.rs.next();
        this.rsmd = this.rs.getMetaData();
        for (i = 1; i <= this.rsmd.getColumnCount(); ++i) {
            this.pSt.setObject(i, this.rs.getObject(i));
        }
        AlterTableTest.assertStatementError("42X04", this.pSt);
        this.conn.setAutoCommit(true);
        st.executeUpdate("create table renc_7 (c1 varchar(50), c2 int)");
        st.executeUpdate("create synonym renc_7_syn for renc_7");
        st.executeUpdate("insert into renc_7 values ('one', 1)");
        AlterTableTest.assertStatementError("42Y55", st, " rename column renc_7_syn.c2 to c2_syn");
        st.executeUpdate("rename column renc_7.c1 to c1_renamed");
        this.rs = st.executeQuery("select c1_renamed from renc_7_syn");
        this.expColNames = new String[]{"C1_RENAMED"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"one"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
        st.executeUpdate("create schema renc_schema_1");
        st.executeUpdate("create schema renc_schema_2");
        st.executeUpdate("set schema renc_schema_2");
        st.executeUpdate("create table renc_8 (a int, b int, c int)");
        st.executeUpdate("set schema renc_schema_1");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_8.b to bbb");
        st.executeUpdate("rename column renc_schema_2.renc_8.b to b2");
    }

    public void testAlterTableAndSysdepends() throws Exception {
        Statement st = this.createStatement();
        this.createTableAndInsertData(st, "Derby5120_tab", "C11", "C12");
        this.createTableAndInsertData(st, "Derby5120_tab_bkup1", "C111", "C112");
        this.createTableAndInsertData(st, "Derby5120_tab_bkup2", "C211", "C212");
        int sysdependsRowCountBeforeTestStart = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger Derby5120_tr1 after update of c11 on Derby5120_tab referencing  old_table as old for each statement insert into Derby5120_tab_bkup1 select * from old");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 5));
        st.executeUpdate(" create trigger Derby5120_tr2 after update of c11 on Derby5120_tab referencing  old as oldrow for each row insert into  Derby5120_tab_bkup2(c211) values (oldrow.c11)");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 10));
        st.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 10));
        st.executeUpdate("alter table Derby5120_tab add column c113 int");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 10));
        AlterTableTest.assertStatementError("42802", st, " update Derby5120_tab set c11=2");
        st.executeUpdate("drop trigger Derby5120_tr1");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS will be less", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 5));
        st.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeTestStart + 5));
    }

    public void testTriggersAndSynonyms() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table atdcSynonymTab_1 (c11 integer, c12 integer)");
        st.executeUpdate("create table atdcSynonymTab_2 (c21 integer, c22 integer)");
        st.executeUpdate("CREATE SYNONYM synonymTab2 FOR atdcSynonymTab_2");
        st.executeUpdate("create trigger syn_tr1t1 after update of c11 on atdcSynonymTab_1 for each row mode db2sql insert into atdcSynonymTab_2(c21, c22) values(9,9)");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        st.executeUpdate(" delete from atdcSynonymTab_1");
        st.executeUpdate(" delete from synonymTab2");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdcSynonymTab_2 drop column c21 restrict");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        st.executeUpdate(" delete from atdcSynonymTab_1");
        st.executeUpdate(" delete from synonymTab2");
        st.executeUpdate(" alter table atdcSynonymTab_2 drop column c21");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
    }

    public void testDropColumnTriggerDependency() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atdctd_1 (c11 integer, c12 integer)");
        st.executeUpdate("create table atdctd_2 (c21 integer, c22 integer)");
        st.executeUpdate("create table atdctd_3 (c31 integer, c32 integer)");
        st.executeUpdate("create trigger tr1t1 after update of c11 on atdctd_1 for each row mode db2sql insert into atdctd_3(c31, c32) values(9,9)");
        st.executeUpdate("create trigger tr1t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31, c32) select c11, c12 from atdctd_1");
        st.executeUpdate("create trigger tr2t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31) select c11 from atdctd_1");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(11,12)");
        st.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        st.executeUpdate(" delete from atdctd_3");
        st.executeUpdate(" delete from atdctd_1");
        st.executeUpdate(" delete from atdctd_2");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdctd_1 drop column c11 restrict");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(11,12)");
        st.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        st.executeUpdate(" delete from atdctd_3");
        st.executeUpdate(" delete from atdctd_1");
        st.executeUpdate(" delete from atdctd_2");
        st.executeUpdate(" alter table atdctd_1 drop column c11");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(12)");
        st.executeUpdate(" update atdctd_1 set c12=99");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
    }

    public void testDropColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atdc_0 (a integer)");
        st.executeUpdate("create table atdc_1 (a integer, b integer)");
        st.executeUpdate("insert into atdc_1 values (1, 1)");
        JDBC.assertFullResultSet(st.executeQuery(" select * from atdc_1"), new String[][]{{"1", "1"}});
        this.rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "INTEGER"}});
        st.executeUpdate("alter table atdc_1 drop column b");
        this.rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A"});
        JDBC.assertSingleValueResultSet(this.rs, "1");
        this.rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"A", "1", "INTEGER"}});
        st.executeUpdate("alter table atdc_1 add column b varchar (20)");
        st.executeUpdate("insert into atdc_1 values (1, 'new val')");
        st.executeUpdate("insert into atdc_1 (a, b) values (2, 'two val')");
        this.rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A", "B"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", null}, {"1", "new val"}, {"2", "two val"}});
        this.rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "VARCHAR(20)"}});
        st.executeUpdate("alter table atdc_1 add column c integer");
        st.executeUpdate("insert into atdc_1 values (3, null, 3)");
        this.rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A", "B", "C"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", null, null}, {"1", "new val", null}, {"2", "two val", null}, {"3", null, "3"}});
        st.executeUpdate("alter table atdc_1 drop b");
        this.rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(this.rs, new String[]{"A", "C"});
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", null}, {"1", null}, {"2", null}, {"3", "3"}});
        this.rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"A", "1", "INTEGER"}, {"C", "2", "INTEGER"}});
        st.executeUpdate("create table atdc_1_01 (a int, b int, c int not null primary key)");
        st.executeUpdate("alter table atdc_1_01 drop column c cascade");
        if (AlterTableTest.usingEmbedded()) {
            if (this.sqlWarn == null && st != null) {
                this.sqlWarn = st.getWarnings();
            }
            if (this.sqlWarn == null) {
                this.sqlWarn = this.getConnection().getWarnings();
            }
            AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)this.sqlWarn);
            AlterTableTest.assertSQLState("01500", this.sqlWarn);
            this.sqlWarn = null;
        }
        st.executeUpdate(" create table atdc_1_02 (a int not null primary key, b int)");
        st.executeUpdate(" create table atdc_1_03 (a03 int, constraint a03_fk foreign key (a03) references atdc_1_02(a))");
        st.executeUpdate(" alter table atdc_1_02 drop column a cascade");
        if (AlterTableTest.usingEmbedded()) {
            if (this.sqlWarn == null && st != null) {
                this.sqlWarn = st.getWarnings();
            }
            if (this.sqlWarn == null) {
                this.sqlWarn = this.getConnection().getWarnings();
            }
            AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)this.sqlWarn);
            AlterTableTest.assertSQLState("01500", this.sqlWarn);
            this.sqlWarn = null;
        }
        if (AlterTableTest.usingEmbedded()) {
            if (this.sqlWarn == null && st != null) {
                this.sqlWarn = st.getWarnings();
            }
            if (this.sqlWarn == null) {
                this.sqlWarn = this.getConnection().getWarnings();
            }
            AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)this.sqlWarn);
            AlterTableTest.assertSQLState("01500", this.sqlWarn);
            this.sqlWarn = null;
        }
        st.executeUpdate("alter table atdc_1 add constraint atdc_constraint_1 check (a > 0)");
        this.rs = st.executeQuery(" select CONSTRAINTNAME,TYPE,STATE,REFERENCECOUNT from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ATDC_CONSTRAINT_1", "C", "E", "0"}});
        this.rs = st.executeQuery(" select sc.CHECKDEFINITION,sc.REFERENCEDCOLUMNS from sys.syschecks sc,sys.sysconstraints con,  sys.systables st where sc.constraintid = con.constraintid and con.tableid = st.tableid and st.tablename = 'ATDC_1'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"(a > 0)", "(1)"}});
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1 drop column a restrict");
        st.executeUpdate("alter table atdc_1 drop column a cascade");
        this.checkWarning(st, "01500");
        this.rs = st.executeQuery(" select * from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate("create table atdc_1_constraints (a int not null primary key, b int not null, c int constraint atdc_1_c_chk check (c is not null), d int not null unique, e int, f int, constraint atdc_1_e_fk foreign key (e) references atdc_1_constraints(a))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column a restrict");
        st.executeUpdate(" alter table atdc_1_constraints drop column b restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column c restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column d restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column e restrict");
        st.executeUpdate("alter table atdc_1_constraints drop column a cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column c cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column d cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column e cascade");
        AlterTableTest.assertStatementError("42Y55", st, "alter table atdc_nosuch drop column a");
        st.executeUpdate("create table atdc_2 (a integer)");
        AlterTableTest.assertStatementError("42X14", st, "alter table atdc_2 drop column b");
        AlterTableTest.assertStatementError("42X14", st, "alter table atdc_2 drop b");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column 'a'");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column column");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column constraint");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column primary");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column foreign");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column check");
        st.executeUpdate("create table atdc_3 (a integer)");
        st.executeUpdate("create index atdc_3_idx_1 on atdc_3 (a)");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_3 drop column a restrict");
        st.executeUpdate("drop index atdc_3_idx_1");
        st.executeUpdate("create table atdc_4 (a int, b int, c int, d int, e int)");
        st.executeUpdate("insert into atdc_4 values (1,2,3,4,5)");
        st.executeUpdate("create index atdc_4_idx_1 on atdc_4 (a)");
        st.executeUpdate("create index atdc_4_idx_2 on atdc_4 (b, c, d)");
        st.executeUpdate("create index atdc_4_idx_3 on atdc_4 (c, a)");
        this.rs = st.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ATDC_4_IDX_1", "true"}, {"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        st.executeUpdate("alter table atdc_4 drop column a restrict");
        this.rs = st.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        st.executeUpdate("alter table atdc_4 drop column c restrict");
        AlterTableTest.assertStatementError("42X04", st, "select * from atdc_4 where c = 3");
        this.rs = st.executeQuery(" select count(*) from sys.sysconglomerates where conglomeratename='ATDC_4_IDX_2'");
        JDBC.assertSingleValueResultSet(this.rs, "1");
        this.rs = st.executeQuery(" select conglomeratename, isindex from sys.sysconglomerates where conglomeratename like 'ATDC_4%'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ATDC_4_IDX_2", "true"}});
        st.executeUpdate("drop index atdc_4_idx_2");
        st.executeUpdate("create table atdc_5 (a int, b int)");
        st.executeUpdate(" create view atdc_vw_1 (vw_b) as select b from atdc_5");
        AlterTableTest.assertStatementError("X0Y23", st, " alter table atdc_5 drop column b restrict");
        this.rs = st.executeQuery("select * from atdc_vw_1");
        this.expColNames = new String[]{"VW_B"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        JDBC.assertDrainResults(this.rs, 0);
        st.executeUpdate("alter table atdc_5 drop column b cascade");
        this.checkWarning(st, "01501");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_1");
        st.executeUpdate("create table atdc_5a (a int, b int, c int)");
        st.executeUpdate(" create view atdc_vw_5a_1 (vw_5a_b, vw_5a_c) as select b,c from atdc_5a");
        st.executeUpdate(" create view atdc_vw_5a_2 (vw_5a_c_2) as select vw_5a_c from atdc_vw_5a_1");
        st.executeUpdate("alter table atdc_5a drop column b cascade");
        this.checkWarning(st, "01501");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_5a_1");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_5a_2");
        this.createTableAndInsertData(st, "ATDC_6", "A", "B");
        int sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_6_trigger_1 after update of b on atdc_6 for each row values current_date");
        int sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_6 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_6_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_6 drop column b cascade");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_6_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_6");
        this.createTableAndInsertData(st, "ATDC_11", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_11_trigger_1 after update of b on atdc_11 for each row select a,b from atdc_11");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_11 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_11_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_11 drop column b cascade");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_11_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_11");
        this.createTableAndInsertData(st, "ATDC_12", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_12_trigger_1 after update of a on atdc_12 for each row select a,b from atdc_12");
        st.executeUpdate(" create trigger atdc_12_trigger_2  after update of a on atdc_12 REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b from atdc_12");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_12 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_12_TRIGGER_1"}, {"ATDC_12_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_12 drop column b");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_12_TRIGGER_1', 'ATDC_12_TRIGGER_2')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_12");
        this.createTableAndInsertData(st, "ATDC_13", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_13_trigger_1 after update on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_2 after insert on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_3 after delete on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_4 after update on atdc_13  REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b, newt.b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_5 after insert on atdc_13  REFERENCING NEW AS newt  for each row select newt.b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_6 after delete on atdc_13  REFERENCING OLD AS oldt  for each row select oldt.b from atdc_13");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_13 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TRIGGER_1"}, {"ATDC_13_TRIGGER_2"}, {"ATDC_13_TRIGGER_3"}, {"ATDC_13_TRIGGER_4"}, {"ATDC_13_TRIGGER_5"}, {"ATDC_13_TRIGGER_6"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_13 drop column b");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_13_TRIGGER_1', 'ATDC_13_TRIGGER_2', 'ATDC_13_TRIGGER_3','ATDC_13_TRIGGER_4', 'ATDC_13_TRIGGER_5','ATDC_13_TRIGGER_6')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_13");
        st.executeUpdate("create table atdc_16_tab1 (a1 integer, b1 integer, c1 integer)");
        st.executeUpdate("create table atdc_16_tab2 (a2 integer, b2 integer, c2 integer)");
        st.executeUpdate("insert into atdc_16_tab1 values(1,11,111)");
        st.executeUpdate("insert into atdc_16_tab2 values(1,11,111)");
        this.rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "11", "111"}});
        this.rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "11", "111"}});
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_16_trigger_1  after update of b1 on atdc_16_tab1 REFERENCING NEW AS newt for each row  update atdc_16_tab2 set c2 = newt.c1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update atdc_16_tab1 set b1=22,c1=222");
        this.rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "22", "222"}});
        this.rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "11", "222"}});
        st.executeUpdate("alter table atdc_16_tab1 drop column a1 restrict");
        st.executeUpdate("update atdc_16_tab1 set b1=33, c1=333");
        this.rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"33", "333"}});
        this.rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "11", "333"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("drop table ATDC_16_TAB1");
        st.executeUpdate("drop table ATDC_16_TAB2");
        this.createTableAndInsertData(st, "ATDC_14_TAB1", "A1", "B1");
        this.createTableAndInsertData(st, "ATDC_14_TAB2", "A2", "B2");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_14_trigger_1 after update on atdc_14_tab1 REFERENCING NEW AS newt for each row update atdc_14_tab2 set a2 = newt.a1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_14_tab2 drop column a2 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_14_TRIGGER_1"}});
        st.executeUpdate("alter table atdc_14_tab2 drop column a2");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_14_TRIGGER_1')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_14_TAB1");
        st.executeUpdate("drop table ATDC_14_TAB2");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C31", "C32");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        int countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int countAfter3rdTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int countAfter4thTrigger = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        this.rs = st.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        st.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C31", "C32");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int countAfter4Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        this.rs = st.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        st.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.checkWarning(st, "01502");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter3Triggers);
        st.executeUpdate("alter table ATDC_13_TAB2 add column c21 int");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c11 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter3Triggers);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c11 int");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB1_BACKUP SET C11=123 WHERE C12>1");
        int countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB2 SET C21=123");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB3 SET C31=123 WHERE C32 IN (values(1))");
        countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB3 drop column c31 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c31");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter2Triggers);
        st.executeUpdate("alter table ATDC_13_TAB3 add column c31 int");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter2Triggers);
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c12 int");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB1_BACKUP WHERE C12>1");
        countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB3 WHERE C32 IN (values(1))");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB3 drop column c32 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c32");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C11", "C12");
        st.executeUpdate("create view ATDC_13_VIEW1 as select c11 from ATDC_13_TAB2");
        st.executeUpdate("create view ATDC_13_VIEW3 as select * from ATDC_13_TAB2");
        st.executeUpdate("create view ATDC_13_VIEW2 as select c12 from ATDC_13_TAB3 where c12>0");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW1 WHERE C11>0");
        countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW3");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW2 ");
        countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y23", st, "alter table ATDC_13_TAB3 drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c12");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)(countAfter2Triggers - 1));
        AlterTableTest.assertStatementError("X0Y23", st, "alter table ATDC_13_TAB2 drop column c11 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(countAfter2Triggers - 1));
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeCreateTrigger - 3));
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(st, "ATDC_15_TAB1", "A1", "B1");
        this.createTableAndInsertData(st, "ATDC_15_TAB2", "A2", "B2");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_15_trigger_1 after update on atdc_15_tab1 REFERENCING NEW AS newt for each row update atdc_15_tab2 set b2 = newt.b1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update atdc_15_tab1 set b1=22");
        this.rs = st.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "22"}});
        this.rs = st.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "22"}});
        st.executeUpdate("alter table atdc_15_tab1 drop column a1 restrict");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("update atdc_15_tab1 set b1=33");
        this.rs = st.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"33"}});
        this.rs = st.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"1", "33"}});
        st.executeUpdate("drop table ATDC_15_TAB1");
        st.executeUpdate("drop table ATDC_15_TAB2");
        st.executeUpdate(" create table atdc_7 (a int, b int, c int, primary key (a))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_7 drop column a restrict");
        st.executeUpdate(" alter table atdc_7 drop column a cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" create table atdc_8 (a int, b int, c int, primary key (b, c))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_8 drop column c restrict");
        st.executeUpdate("alter table atdc_8 drop column c cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate("create table atdc_9 (a int not null, b int)");
        st.executeUpdate("alter table atdc_9 drop column a restrict");
        st.executeUpdate("create table atdc_10 (a int, b int, c int)");
        st.executeUpdate("grant select(a, b, c) on atdc_10 to bryan");
        this.rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1, 2}"}});
        st.executeUpdate("alter table atdc_10 drop column b restrict");
        this.rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42X14", st, " alter table atdc_10 drop column b cascade");
        this.rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42Y55", st, "drop table d1909");
        st.executeUpdate("create table d1909 (a int, b int, c int)");
        st.executeUpdate("grant select (a) on d1909 to user1");
        st.executeUpdate("grant select (a,b) on d1909 to user2");
        st.executeUpdate("grant update(c) on d1909 to super_user");
        this.rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"USER1", "s", "{0}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{2}"}});
        st.executeUpdate("alter table d1909 drop column a");
        this.rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"USER1", "s", "{}"}, {"USER2", "s", "{0}"}, {"SUPER_USER", "u", "{1}"}});
        st.executeUpdate("grant update(b) on d1909 to user1");
        st.executeUpdate("grant select(c) on d1909 to user1");
        st.executeUpdate("grant select(c) on d1909 to user2");
        this.rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"USER1", "s", "{1}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{1}"}, {"USER1", "u", "{0}"}});
    }

    private void createTableAndInsertData(Statement s, String tableName, String column1, String column2) throws SQLException {
        s.execute("CREATE TABLE " + tableName + " (" + column1 + " int, " + column2 + " int) ");
        s.execute("INSERT INTO " + tableName + " VALUES (1,11)");
    }

    private int numberOfRowsInSysdepends(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        rs.next();
        return rs.getInt(1);
    }

    private void triggersExist(Statement st, String[][] expectedTriggers) throws SQLException {
        StringBuffer query = new StringBuffer("select triggername from sys.systriggers where triggername in (");
        for (int i = 0; i < expectedTriggers.length; ++i) {
            query.append("'" + expectedTriggers[i][0] + "'");
            if (i + 1 >= expectedTriggers.length) continue;
            query.append(", ");
        }
        query.append(")");
        ResultSet rs = st.executeQuery(query.toString());
        JDBC.assertFullResultSet(rs, expectedTriggers);
    }

    public void testJira3175() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table d3175 (x varchar(12), y varchar(12), id int primary key generated by default as identity)");
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and t.tablename='D3175'");
        JDBC.assertUnorderedResultSet(this.rs, new String[][]{{"X", "1", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"Y", "2", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"ID", "3", "INTEGER NOT NULL", "GENERATED_BY_DEFAULT", "1", "1", "1", "D3175", "T", "R"}});
        st.executeUpdate("insert into d3175(x) values 'b'");
        st.executeUpdate("alter table d3175 drop column y");
        st.executeUpdate("insert into d3175(x) values 'a'");
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and t.tablename='D3175'");
        JDBC.assertUnorderedResultSet(this.rs, new String[][]{{"X", "1", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"ID", "2", "INTEGER NOT NULL", "GENERATED_BY_DEFAULT", "3", "1", "1", "D3175", "T", "R"}});
    }

    public void testJira3177() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table d3177_SchemaVersion (version INTEGER NOT NULL)");
        st.executeUpdate("insert into d3177_SchemaVersion (version) values (0)");
        st.executeUpdate(" create table d3177_BinaryData ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), CRC32 BIGINT NOT NULL , data BLOB NOT NULL , CONSTRAINT d3177_BinaryData_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_MailServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , username varchar(80) NOT NULL , protocol varchar(80) NOT NULL , SSLProtocol varchar(10), emailAddress varchar(80) NOT NULL , server varchar(80) NOT NULL , password varchar(80) NOT NULL , CONSTRAINT d3177_MailServers_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_Mailboxes ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , folder varchar(80) NOT NULL , username varchar(80) NOT NULL , SSLProtocol varchar(10), hostname varchar(80) NOT NULL , storeType varchar(80) NOT NULL , password varchar(80) NOT NULL , timeout INTEGER NOT NULL , MailServerID INTEGER NOT NULL , CONSTRAINT d3177_Mailboxes_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_MESSAGES ( Message_From varchar(1000), Message_Cc varchar(1000), Message_Subject varchar(1000), Message_ID varchar(256) NOT NULL , Message_Bcc varchar(1000), Message_Date TIMESTAMP, Content_Type varchar(256), MailboxID INTEGER NOT NULL , Search_Text CLOB NOT NULL , id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Message_To varchar(1000), Display_Text CLOB NOT NULL , Message_Data_ID INTEGER NOT NULL , CONSTRAINT d3177_MESSAGES_id_pk PRIMARY KEY(id) )");
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        st.executeUpdate(" create table D3177_ATTACHMENTS ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Inline INTEGER, CRC32 BIGINT NOT NULL , Attachment_Name varchar(256) NOT NULL , Attachment_File varchar(512) NOT NULL , Message_ID INTEGER NOT NULL , Content_Type varchar(256) NOT NULL , CONSTRAINT D3177_ATTACHMENTS_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" alter table D3177_ATTACHMENTS ADD CONSTRAINT ATTACHMENTS_Message_ID_MESSAGES_ID FOREIGN KEY ( Message_ID ) REFERENCES D3177_MESSAGES ( ID )");
        st.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_MailboxID_Mailboxes_ID FOREIGN KEY ( MailboxID ) REFERENCES d3177_Mailboxes ( ID )");
        st.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_Message_Data_ID_d3177_BinaryData_ID FOREIGN KEY ( Message_Data_ID ) REFERENCES d3177_BinaryData ( ID )");
        st.executeUpdate(" alter table d3177_Mailboxes ADD CONSTRAINT Mailboxes_MailServerID_MailServers_ID FOREIGN KEY ( MailServerID ) REFERENCES d3177_MailServers ( ID )");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=1");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_To SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_From SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_Cc SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_Bcc SET DATA TYPE varchar(10000)");
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=2");
        st.executeUpdate(" create table D3177_MailStatistics ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), ProcessedCount INTEGER DEFAULT 0 NOT NULL , HourOfDay INTEGER NOT NULL , LastModified TIMESTAMP NOT NULL , RejectedMailCount INTEGER DEFAULT 0 NOT NULL , DayOfWeek INTEGER NOT NULL , CONSTRAINT D3177_MailStatistics_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" CREATE INDEX D3177_MailStatistics_HourOfDay_idx ON D3177_MailStatistics(HourOfDay)");
        st.executeUpdate(" CREATE INDEX D3177_MailStatistics_DayOfWeek_idx ON D3177_MailStatistics(DayOfWeek)");
        st.executeUpdate(" alter table D3177_MESSAGES alter CONTENT_TYPE SET DATA TYPE varchar(256)");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=3");
        st.executeUpdate(" alter table D3177_messages alter column Message_ID NULL");
        st.executeUpdate(" CREATE INDEX D3177_MESSAGES_Message_ID_idx ON D3177_MESSAGES(Message_ID)");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=4");
        st.executeUpdate("alter table D3177_MESSAGES add filename varchar(256)");
        st.executeUpdate("alter table D3177_MESSAGES add CRC32 BIGINT");
        JDBC.assertEmpty(st.executeQuery("select id,crc32,data from d3177_BinaryData"));
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        st.executeUpdate(" alter table D3177_messages alter column filename NOT NULL");
        st.executeUpdate(" alter table D3177_messages alter column crc32 NOT NULL");
        st.executeUpdate(" alter table D3177_messages alter column mailboxid NULL");
        AlterTableTest.assertStatementError("42X86", st, " ALTER TABLE D3177_MESSAGES DROP CONSTRAINT MESSAGES_message_data_id_BinaryData_id");
        st.executeUpdate(" alter table D3177_messages drop column message_data_id");
        this.checkWarning(st, "01500");
        st.executeUpdate("drop table d3177_BinaryData");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=6");
        st.executeUpdate(" create table D3177_EmailAddresses ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), address varchar(256) NOT NULL , CONSTRAINT D3177_EmailAddresses_id_pk PRIMARY KEY(id), CONSTRAINT D3177_EmailAddresses_address_uq UNIQUE(address) )");
        st.executeUpdate(" CREATE UNIQUE INDEX D3177_EmailAddresses_address_idx ON D3177_EmailAddresses(address)");
        this.checkWarning(st, "01504");
        st.executeUpdate(" create table D3177_EmailAddressesToMessages ( MessageID INTEGER NOT NULL , EmailAddressID INTEGER NOT NULL )");
        st.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_MessageID_Messages_ID FOREIGN KEY ( MessageID ) REFERENCES D3177_Messages ( ID )");
        st.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_EmailAddressID_EmailAddresses_ID FOREIGN KEY ( EmailAddressID ) REFERENCES D3177_EmailAddresses ( ID )");
        st.executeUpdate(" create table AuthenticationServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , protocol varchar(20) NOT NULL , hostname varchar(40) NOT NULL , CONSTRAINT AuthenticationServers_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" alter table d3177_Mailboxes add AuthenticationServerID INTEGER");
        JDBC.assertEmpty(st.executeQuery("select id,filename from D3177_messages"));
        st.executeUpdate("alter table D3177_MESSAGES drop column message_to");
        st.executeUpdate("alter table D3177_MESSAGES drop column message_cc");
        st.executeUpdate("alter table D3177_MESSAGES drop column message_from");
        this.rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(this.rs, new String[][]{{"ID", "8", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=7");
    }

    public void testJira2371() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table t2371 ( a varchar(10))");
        st.executeUpdate("alter table t2371 alter column a default 'my val'");
        st.executeUpdate("insert into t2371 (a) values ('hi')");
        st.executeUpdate("insert into t2371 (a) values (default)");
        st.executeUpdate("alter table t2371 alter column a default 'another'");
        st.executeUpdate("insert into t2371 (a) values (default)");
        JDBC.assertFullResultSet(st.executeQuery("select A from t2371"), new String[][]{{"hi"}, {"my val"}, {"another"}});
    }

    public void testJira3355() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table d3355 ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        st.executeUpdate(" create table \"d3355_a\" ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        st.executeUpdate(" create table d3355_qt_col (\"\"\"c\"\"4\" int, \"\"\"\"\"C5\" int, \"c 6\" int)");
        st.executeUpdate(" create table \"d3355_qt_\"\"tab\" ( c4 int, c5 int, c6 int)");
        st.executeUpdate("insert into d3355 values ('a', 'b', 'c')");
        st.executeUpdate("insert into \"d3355_a\" values ('d', 'e', 'f')");
        st.executeUpdate("insert into d3355_qt_col values (4, 5, 6)");
        st.executeUpdate("insert into \"d3355_qt_\"\"tab\" values (4, 5, 6)");
        st.executeUpdate("alter table d3355 alter column c1 not null");
        st.executeUpdate("alter table d3355 alter column \"c2\" not null");
        st.executeUpdate("alter table d3355 alter column \"C3\" not null");
        st.executeUpdate("alter table \"d3355_a\" alter column c1 not null");
        st.executeUpdate("alter table \"d3355_a\" alter column \"c2\" not null");
        st.executeUpdate("alter table \"d3355_a\" alter column \"C3\" not null");
        st.executeUpdate(" alter table d3355_qt_col alter column \"\"\"\"\"C5\" not null");
        st.executeUpdate(" alter table d3355_qt_col alter column \"c 6\" not null");
        st.executeUpdate(" alter table \"d3355_qt_\"\"tab\" alter column c5 not null");
        AlterTableTest.assertStatementError("42X14", st, "alter table d3355 alter column \"c1\" not null");
        AlterTableTest.assertStatementError("42X14", st, " alter table d3355 alter column c2 not null");
        AlterTableTest.assertStatementError("42Y55", st, " alter table d3355_a alter column c1 not null");
        AlterTableTest.assertStatementError("42X14", st, " alter table \"d3355_a\" alter column \"c1\" not null");
    }

    public void testJira4256() throws SQLException {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        Object clob = null;
        Object blob = null;
        int val = 1;
        int size = 15360;
        st.executeUpdate("create table clob_tab(c1 int,clob_col clob(10K))");
        this.conn.commit();
        this.pSt = this.conn.prepareStatement("INSERT INTO clob_tab values (?,?)");
        TestInputStream stream = new TestInputStream(size, val);
        this.pSt.setInt(1, val);
        this.pSt.setAsciiStream(2, (InputStream)stream, size);
        AlterTableTest.assertStatementError("XJ001", this.pSt);
        this.pSt.close();
        this.conn.rollback();
        st.executeUpdate("ALTER TABLE clob_tab ALTER COLUMN clob_col SET DATA TYPE clob(20K)");
        this.pSt = this.conn.prepareStatement("INSERT INTO clob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        this.pSt.setInt(1, val);
        this.pSt.setAsciiStream(2, (InputStream)stream, size);
        this.pSt.executeUpdate();
        this.pSt.close();
        st.executeUpdate("CREATE TABLE blob_tab ( C1 INTEGER,blob_col BLOB(10K) NOT NULL)");
        this.conn.commit();
        this.pSt = this.conn.prepareStatement("INSERT INTO blob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        this.pSt.setInt(1, val);
        this.pSt.setBinaryStream(2, (InputStream)stream, size);
        AlterTableTest.assertStatementError("22001", this.pSt);
        this.pSt.close();
        this.conn.rollback();
        st.executeUpdate("ALTER TABLE blob_tab ALTER COLUMN blob_col SET DATA TYPE blob(20K)");
        this.pSt = this.conn.prepareStatement("INSERT INTO blob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        this.pSt.setInt(1, val);
        this.pSt.setBinaryStream(2, (InputStream)stream, size);
        this.pSt.executeUpdate();
        this.pSt.close();
        this.conn.rollback();
    }

    public void testDerby5157_addColumnWithDefaultValue() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema \"\"\"\"");
        s.execute("create table \"\"\"\".\"\"\"\" (x int)");
        s.execute("alter table \"\"\"\".\"\"\"\" add column \"\"\"\" int default 42");
    }

    public void testDerby5157_changeIncrement() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema \"\"\"\"");
        s.execute("create table \"\"\"\".\"\"\"\"(\"\"\"\" int generated always as identity)");
        s.execute("alter table \"\"\"\".\"\"\"\" alter column \"\"\"\" set increment by 2");
    }
}

