/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ArithmeticTest
extends BaseJDBCTestCase {
    public ArithmeticTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ArithmeticTest.class);
    }

    public void testTypes() throws SQLException {
        String[] tableNames = new String[]{"smallint_r", "t", "bigint_r"};
        String[] types = new String[]{"smallint", "int", "bigint"};
        long[] positiveBoundaries = new long[]{32767L, Integer.MAX_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < types.length; ++i) {
            this.doBasically(tableNames[i], types[i], positiveBoundaries[i]);
            this.doOverflow(tableNames[i], types[i], positiveBoundaries[i]);
            this.dropTable(tableNames[i]);
        }
    }

    private void doBasically(String tableName, String type, long positiveBoundary) throws SQLException {
        String sql = "create table " + tableName + "(i " + type + ", j " + type + ")";
        Statement st = this.createStatement();
        st.addBatch(sql);
        sql = "insert into " + tableName + " values (null, null)";
        st.addBatch(sql);
        sql = "insert into " + tableName + " values (0, 100)";
        st.addBatch(sql);
        sql = "insert into " + tableName + " values (1, 101)";
        st.addBatch(sql);
        sql = "insert into " + tableName + " values (-2, -102)";
        st.addBatch(sql);
        st.executeBatch();
        sql = "select * from " + tableName;
        String[][] result = new String[][]{{null, null}, {"0", "100"}, {"1", "101"}, {"-2", "-102"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i + j from " + tableName;
        result = new String[][]{{null}, {"100"}, {"102"}, {"-104"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, i + 10 + 20, j, j + 100 + 200 from " + tableName;
        result = new String[][]{{null, null, null, null}, {"0", "30", "100", "400"}, {"1", "31", "101", "401"}, {"-2", "28", "-102", "198"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i - j, j - i from " + tableName;
        result = new String[][]{{null, null}, {"-100", "100"}, {"-100", "100"}, {"100", "-100"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, i - 10 - 20, 20 - 10 - i, j, j - 100 - 200, 200 - 100 - j from " + tableName;
        result = new String[][]{{null, null, null, null, null, null}, {"0", "-30", "10", "100", "-200", "0"}, {"1", "-29", "9", "101", "-199", "-1"}, {"-2", "-32", "12", "-102", "-402", "202"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, j, i * j, j * i from " + tableName;
        result = new String[][]{{null, null, null, null}, {"0", "100", "0", "0"}, {"1", "101", "101", "101"}, {"-2", "-102", "204", "204"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, j, i * 10 * -20, j * 100 * -200 from " + tableName;
        result = new String[][]{{null, null, null, null}, {"0", "100", "0", "-2000000"}, {"1", "101", "-200", "-2020000"}, {"-2", "-102", "400", "2040000"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select -i, -j, -(i * 10 * -20), -(j * 100 * -200) from " + tableName;
        result = new String[][]{{null, null, null, null}, {"0", "-100", "0", "2000000"}, {"-1", "-101", "200", "2020000"}, {"2", "102", "-400", "-2040000"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select +i, +j, +(+i * +10 * -20), +(+j * +100 * -200) from " + tableName;
        result = new String[][]{{null, null, null, null}, {"0", "100", "0", "-2000000"}, {"1", "101", "-200", "-2020000"}, {"-2", "-102", "400", "2040000"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, j, i / j, 10 / j, j / 10 from " + tableName;
        result = new String[][]{{null, null, null, null, null}, {"0", "100", "0", "0", "10"}, {"1", "101", "0", "0", "10"}, {"-2", "-102", "0", "0", "-10"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select j / i from " + tableName;
        ArithmeticTest.assertStatementError("22012", st, sql);
        sql = "select (j - 1) / (i + 4), 20 / 5 / 4, 20 / 4 / 5 from " + tableName;
        result = new String[][]{{null, "1", "1"}, {"24", "1", "1"}, {"20", "1", "1"}, {"-51", "1", "1"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select j, j / (0 - j), (0 - j) / j, (0 - j) / (0 - j) from " + tableName;
        result = new String[][]{{null, null, null, null}, {"100", "-1", "-1", "1"}, {"101", "-1", "-1", "1"}, {"-102", "-1", "-1", "1"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select i, i + 10, i - (10 - 20), i - 10, i - (20 - 10) from " + tableName;
        result = new String[][]{{null, null, null, null, null}, {"0", "10", "10", "-10", "-10"}, {"1", "11", "11", "-9", "-9"}, {"-2", "8", "8", "-12", "-12"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select  'The next 2 columns should agree', 2 + 3 * 4 + 5, 2 + (3 * 4) + 5 from " + tableName;
        result = new String[][]{{"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select 'The next column should be 45', (2 + 3) * (4 + 5) from " + tableName;
        result = new String[][]{{"The next column should be 45", "45"}, {"The next column should be 45", "45"}, {"The next column should be 45", "45"}, {"The next column should be 45", "45"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
    }

    private void doOverflow(String tableName, String type, long positiveBoundary) throws SQLException {
        this.dropTable(tableName);
        String sql = "create table " + tableName + " (i " + type + ", j " + type + ")";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        long i = 1L;
        sql = "insert into " + tableName + " values (" + i + "," + positiveBoundary + ")";
        ArithmeticTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select i + j from " + tableName;
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select i - j - j from " + tableName;
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select j + j from " + tableName;
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select j * j from " + tableName;
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "insert into " + tableName + " values " + "(" + (-positiveBoundary - 1L) + ", 0)";
        ArithmeticTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select -i from " + tableName;
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select -j from " + tableName;
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"" + -positiveBoundary}, {"0"}});
        sql = "select j / 2 * 2 from " + tableName;
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"" + (positiveBoundary - 1L)}, {"0"}});
        if (type.equals("bigint")) {
            sql = "select 2 * (" + positiveBoundary + " / 2 + 1) from " + tableName;
            ArithmeticTest.assertStatementError("22003", st, sql);
            sql = "select -2 * (" + positiveBoundary + " / 2 + 2) from " + tableName;
            ArithmeticTest.assertStatementError("22003", st, sql);
            sql = "select 2 * ((-" + positiveBoundary + " - 1) / 2 - 1) from " + tableName;
            ArithmeticTest.assertStatementError("22003", st, sql);
            sql = "select -2 * ((-" + positiveBoundary + " - 1) / 2 - 1) from " + tableName;
            ArithmeticTest.assertStatementError("22003", st, sql);
            sql = "select i / 2 * 2 - 1 from " + tableName;
            ArithmeticTest.assertStatementError("22003", st, sql);
        }
    }

    private void doMixedTypeImpl(String tableName, String type, int i) throws SQLException {
        String sql = "create table " + tableName + " (y " + type + ")";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        long y = 2L;
        sql = "insert into " + tableName + " values (" + y + ")";
        ArithmeticTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select " + i + " + y from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + ((long)i + y));
        sql = "select y + " + i + " from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + (y + (long)i));
        sql = "select y - " + i + " from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + (y - (long)i));
        sql = "select " + i + " - y from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + ((long)i - y));
        sql = "select " + i + " * y from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + (long)i * y);
        sql = "select y * " + i + " from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + y * (long)i);
        sql = "select " + i + " / y from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + (long)i / y);
        sql = "select y / " + i + " from " + tableName;
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "" + y / (long)i);
        st.close();
    }

    public void testMixedType() throws SQLException {
        String[] types = new String[]{"smallint", "bigint"};
        String[] tableNames = new String[]{"smallint_r", "bigint_r"};
        int[] positiveBoundaries = new int[]{65535, Integer.MAX_VALUE};
        for (int i = 0; i < types.length; ++i) {
            this.doMixedTypeImpl(tableNames[i], types[i], positiveBoundaries[i]);
            this.dropTable(tableNames[i]);
        }
    }

    public void testWrongType() throws SQLException {
        String sql = "create table s (x char(10), y char(10))";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        st.close();
        sql = "select x + y from s";
        this.assertCompileError("42Y95", sql);
        sql = "select x - y from s";
        this.assertCompileError("42Y95", sql);
        sql = "select x * y from s";
        this.assertCompileError("42Y95", sql);
        sql = "select x / y from s";
        this.assertCompileError("42Y95", sql);
        sql = "select -x from s";
        this.assertCompileError("42X37", sql);
        this.dropTable("s");
    }

    public void testNumericDataType() throws SQLException {
        String sql = "create table u (c1 int, c2 char(10))";
        Statement st = this.createStatement();
        st.addBatch(sql);
        sql = "insert into u (c2) values 'asdf'";
        st.addBatch(sql);
        sql = "insert into u (c1) values null";
        st.addBatch(sql);
        sql = "insert into u (c1) values 1";
        st.addBatch(sql);
        sql = "insert into u (c1) values null";
        st.addBatch(sql);
        sql = "insert into u (c1) values 2";
        st.addBatch(sql);
        st.executeBatch();
        sql = "select * from u";
        String[][] result = new String[][]{{null, "asdf"}, {null, null}, {"1", null}, {null, null}, {"2", null}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select c1 + c1 from u";
        result = new String[][]{{null}, {null}, {"2"}, {null}, {"4"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select c1 / c1 from u";
        result = new String[][]{{null}, {null}, {"1"}, {null}, {"1"}};
        JDBC.assertFullResultSet(st.executeQuery(sql), result);
        sql = "select c1 + c2 from u";
        ArithmeticTest.assertStatementError("22018", st, sql);
        st.close();
        this.dropTable("u");
    }

    public void testPrecedenceAndAssociativity() throws SQLException {
        String sql = "create table r (x int)";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        sql = "insert into r values (1)";
        ArithmeticTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select 2 + 3 * 4 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "14");
        sql = "select (2 + 3) * 4 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "20");
        sql = "select 3 * 4 + 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "14");
        sql = "select 3 * (4 + 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "18");
        sql = "select 2 - 3 * 4 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-10");
        sql = "select (2 - 3) * 4 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-4");
        sql = "select  3 * 4 - 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "10");
        sql = "select 3 * (4 - 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "6");
        sql = "select 4 + 3 / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "5");
        sql = "select (4 + 3) / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "3");
        sql = "select 3 / 2 + 4 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "5");
        sql = "select 3 / (2 + 4) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "0");
        sql = "select 4 - 3 / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "3");
        sql = "select (4 - 3) / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "0");
        sql = "select 1 + 2147483647 - 2 from r";
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select 1 + (2147483647 - 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "2147483646");
        sql = "select 4 * 3 / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "6");
        sql = "select 4 * (3 / 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "4");
        sql = "select -1 + 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select -(1 + 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-3");
        sql = "select -1 - 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-3");
        sql = "select -(1 - 2) from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select -1073741824 * 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-2147483648");
        sql = "select -(1073741824 * 2) from r";
        ArithmeticTest.assertStatementError("22003", st, sql);
        sql = "select -2147483648 / 2 from r";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "-1073741824");
        this.dropTable("r");
    }
}

