/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class ErrorMessageTest
extends BaseJDBCTestCase {
    public ErrorMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("ErrorMessageTest");
        }
        Object test = new TestSuite(ErrorMessageTest.class, "ErrorMessageTest");
        test = new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table t (id int primary key, text varchar(10))");
                s.executeUpdate("insert into t (id) values 1, 2");
            }
        };
        Properties prop = new Properties();
        prop.setProperty("derby.locks.waitTimeout", "4");
        prop.setProperty("derby.locks.deadlockTimeout", "2");
        prop.setProperty("derby.locks.deadlockTrace", "true");
        test = new DatabasePropertyTestSetup((Test)test, prop);
        return test;
    }

    public void testWaitTimeout() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        ErrorMessageTest.assertUpdateCount(s, 1, "update t set text='xxx' where id=1");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        try {
            JDBC.assertDrainResults(s2.executeQuery("select * from t where id=1"));
            ErrorMessageTest.fail((String)"Expected lock timeout");
        }
        catch (SQLException e) {
            ErrorMessageTest.assertSQLState("Not a timeout", "40XL2", e);
            String[] msg = e.getMessage().split("\n");
            ErrorMessageTest.assertEquals((String)"*** The following row is the victim ***", (String)msg[4]);
            ErrorMessageTest.assertEquals((String)"*** The above row is the victim ***", (String)msg[6]);
            String[] victim = msg[5].split(" *\\|");
            ErrorMessageTest.assertTrue((String)("Invalid XID string: " + victim[0]), (boolean)victim[0].matches("\\d+"));
            ErrorMessageTest.assertEquals((String)"Victim should be a row lock", (String)"ROW", (String)victim[1]);
            ErrorMessageTest.assertEquals((String)"Victim should be a shared lock", (String)"S", (String)victim[2]);
            ErrorMessageTest.assertEquals((String)"Victim should be waiting", (String)"WAIT", (String)victim[5]);
            boolean locksDumped = false;
            for (int i = 7; i < msg.length - 1; ++i) {
                String[] tokens = msg[i].split(" *\\|");
                ErrorMessageTest.assertTrue((String)("Invalid XID string: " + tokens[0]), (boolean)tokens[0].matches("\\d+"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock type: " + tokens[1]), (boolean)tokens[1].matches("ROW|TABLE"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock mode: " + tokens[2]), (boolean)tokens[2].matches("S|X|IX|IS"));
                ErrorMessageTest.assertEquals((String)"Expected lock to be granted", (String)"GRANT", (String)tokens[5]);
                locksDumped = true;
            }
            ErrorMessageTest.assertTrue((String)"No locks dumped", (boolean)locksDumped);
        }
        s.close();
        s2.close();
        c2.close();
    }

    public void testDeadlockTimeout() throws SQLException, InterruptedException {
        String msg;
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        ErrorMessageTest.assertUpdateCount(s, 1, "update t set text='xxx' where id=1");
        Connection c2 = this.openDefaultConnection();
        c2.setAutoCommit(false);
        final Statement s2 = c2.createStatement();
        ErrorMessageTest.assertUpdateCount(s2, 1, "update t set text='yyy' where id=2");
        final SQLException[] holder = new SQLException[2];
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    JDBC.assertDrainResults(s2.executeQuery("select * from t where id=1"));
                }
                catch (SQLException e) {
                    holder[0] = e;
                }
            }
        });
        t.start();
        try {
            JDBC.assertDrainResults(s.executeQuery("select * from t where id=2"));
        }
        catch (SQLException e) {
            holder[1] = e;
        }
        t.join();
        if (holder[0] != null) {
            ErrorMessageTest.assertSQLState("Not a deadlock", "40001", holder[0]);
            ErrorMessageTest.assertNull((String)"Only one of the waiters should be aborted", (Object)holder[1]);
            msg = holder[0].getMessage();
        } else {
            ErrorMessageTest.assertSQLState("Not a deadlock", "40001", holder[1]);
            msg = holder[1].getMessage();
        }
        String[] lines = msg.split("\n");
        ErrorMessageTest.assertEquals((String)"Unexpected number of lines in message", (int)8, (int)lines.length);
        Pattern[] patterns = new Pattern[]{Pattern.compile("Lock : ROW, T, \\(\\d+,\\d+\\)"), Pattern.compile(" *Waiting XID : \\{\\d+, S\\} , APP, select \\* from t where id=(1|2)"), Pattern.compile(" *Granted XID : \\{\\d+, X\\} *")};
        for (int i = 0; i < patterns.length * 2; ++i) {
            String line = lines[i + 1];
            Matcher m = patterns[i % patterns.length].matcher(line);
            ErrorMessageTest.assertTrue((String)("mismatch: " + line), (boolean)m.matches());
        }
        s.close();
        s2.close();
        c2.rollback();
        c2.close();
    }
}

