/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InsertTest
extends BaseJDBCTestCase {
    private static final String PARAMETER_IN_SELECT_LIST = "42X34";
    private static final String TOO_MANY_RESULT_COLUMNS = "42X06";

    public InsertTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InsertTest.class);
    }

    public void testInsertIntoSelectFromWithLongVarchar() throws SQLException {
        String[][] data = new String[100][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = Integer.toString(i);
            data[i][1] = "-1";
        }
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a long varchar)");
        PreparedStatement insT1 = this.prepareStatement("insert into t1 values ?");
        for (int i = 0; i < data.length; ++i) {
            insT1.setString(1, data[i][0]);
            insT1.executeUpdate();
        }
        s.execute("create table t2(a long varchar, b int default -1 not null)");
        s.execute("insert into t2(a) select * from t1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by int(cast (a as varchar(10)))"), data);
    }

    public void testInsertFromExceptOrIntersect() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("insert into t1 values 1,2,3");
        s.execute("create table t2(x int)");
        s.execute("insert into t2 values 2,3,4");
        s.execute("create table t3(x int)");
        s.execute("insert into t3 select * from t1 intersect select * from t2");
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 intersect all select * from t2");
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 except select * from t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t3 order by x"), "1");
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 except all select * from t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t3 order by x"), "1");
        s.execute("delete from t3");
    }

    public void testInsertFromSelectWithParameters() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table derby4671(x int)");
        s.execute("insert into derby4671 values (1), (2)");
        PreparedStatement ins1 = this.prepareStatement("insert into derby4671 select ? from derby4671");
        ins1.setInt(1, 7);
        InsertTest.assertUpdateCount(ins1, 2);
        JDBC.assertFullResultSet(s.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}});
        PreparedStatement ins2 = this.prepareStatement("insert into derby4671 select (x+?)*10 from derby4671");
        ins2.setInt(1, 77);
        InsertTest.assertUpdateCount(ins2, 4);
        JDBC.assertFullResultSet(s.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}, {"780"}, {"790"}, {"840"}, {"840"}});
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 union select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 except select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 intersect select ? from derby4671");
    }

    public void testInsertTooManyDefaultColumns() throws SQLException {
        this.createStatement().execute("create table derby4449(x int)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 values (default, default)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 (x) values (default, default)");
    }
}

