/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OrderByAndOffsetFetchInSubqueries
extends BaseJDBCTestCase {
    static final String SYNTAX_ERROR = "42X01";
    static final String COLUMN_NOT_FOUND = "42X04";
    static final String COLUMN_OUT_OF_RANGE = "42X77";
    static final String ORDER_BY_COLUMN_NOT_FOUND = "42X78";

    public OrderByAndOffsetFetchInSubqueries(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OrderByAndOffsetFetchInSubqueries");
        suite.addTest(OrderByAndOffsetFetchInSubqueries.makeSuite());
        suite.addTest(TestConfiguration.clientServerDecorator(OrderByAndOffsetFetchInSubqueries.makeSuite()));
        return suite;
    }

    private static Test makeSuite() {
        return new CleanDatabaseTestSetup((Test)new TestSuite(OrderByAndOffsetFetchInSubqueries.class)){

            protected void decorateSQL(Statement s) throws SQLException {
                this.getConnection().setAutoCommit(false);
                s.execute("create table temp1(s varchar(10))");
                s.execute("create table temp2(i integer not null     generated always as identity,s varchar(10))");
                s.execute("create table temp2b(i integer not null     generated always as identity,s varchar(10))");
                s.execute("create table temp3(i integer not null     generated always as identity,s varchar(10),j integer not null     default 66,t varchar(10))");
                s.execute("create table temp4(i integer not null     generated always as identity,s varchar(10),j integer not null     generated always as (2*i),t varchar(10))");
                s.execute("create table t01(c1 int)");
                s.execute("create table t02(c2 int)");
                s.execute("create table t_source(c1 int, c2 varchar(10))");
                s.execute("create table t(i int not null,                constraint c unique (i),                j int, k int)");
                this.getConnection().commit();
            }
        };
    }

    public void testInsertSelectOrderBy() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        ResultSet rs = null;
        s.execute("insert into temp1 values 'x','a','c','b','a'");
        s.execute("insert into temp2(s) select s from temp1 order by s");
        s.execute("insert into temp2(s) select s as a1 from temp1 order by a1");
        s.execute("insert into temp2(s) select * from temp1 order by s");
        rs = s.executeQuery("select * from temp2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "a"}, {"2", "a"}, {"3", "b"}, {"4", "c"}, {"5", "x"}, {"6", "a"}, {"7", "a"}, {"8", "b"}, {"9", "c"}, {"10", "x"}, {"11", "a"}, {"12", "a"}, {"13", "b"}, {"14", "c"}, {"15", "x"}});
        rs = s.executeQuery("select * from temp2 order by i");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "a"}, {"2", "a"}, {"3", "b"}, {"4", "c"}, {"5", "x"}, {"6", "a"}, {"7", "a"}, {"8", "b"}, {"9", "c"}, {"10", "x"}, {"11", "a"}, {"12", "a"}, {"13", "b"}, {"14", "c"}, {"15", "x"}});
        s.execute("insert into temp2(s) select s as a1 from temp1 order by s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, s, "insert into temp2(s) select s as a1 from temp1 order by no_such");
        s.execute("insert into t01 values (50), (10), (1000), (15), (51)");
        rs = s.executeQuery("select * from t01");
        JDBC.assertFullResultSet(rs, new String[][]{{"50"}, {"10"}, {"1000"}, {"15"}, {"51"}});
        s.execute("insert into t02 select * from t01 order by c1");
        s.execute("insert into t02 select * from t01");
        s.execute("insert into t02 select * from t01 order by c1");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"10"}, {"15"}, {"50"}, {"51"}, {"1000"}, {"50"}, {"10"}, {"1000"}, {"15"}, {"51"}, {"10"}, {"15"}, {"50"}, {"51"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, s, "insert into t02 values 66 order by 1");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, s, "insert into t02 values (901), (920), (903) order by 1");
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 select 900 from sys.systables                 union values 66 order by 1");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"66"}, {"900"}});
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 values 66        union select 900 from sys.systables order by 1");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"66"}, {"900"}});
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 values 66        union values 66 order by 1");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"66"}});
        s.execute("delete from t02");
        s.execute("insert into t02 select * from t01 union all                 select * from t01 order by c1");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"10"}, {"10"}, {"15"}, {"15"}, {"50"}, {"50"}, {"51"}, {"51"}, {"1000"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(ORDER_BY_COLUMN_NOT_FOUND, s, "insert into t02 select * from t01 union all                 select * from t02 order by c1");
        s.execute("delete from t02");
        s.execute("insert into t_source     values (1, 'one'), (2, 'two'), (8, 'three')");
        s.execute("insert into t_source(c1)     select c1 from t_source order by c2 desc");
        rs = s.executeQuery("select * from t_source");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "one"}, {"2", "two"}, {"8", "three"}, {"2", null}, {"8", null}, {"1", null}});
        s.executeUpdate("create table t4496(x varchar(100))");
        s.execute("insert into t4496(x) select ibmreqd from     (select * from sysibm.sysdummy1         order by length(ibmreqd)) t1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t4496"), new String[][]{{"Y"}});
        this.rollback();
    }

    public void testInsertSelectOrderByOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        ResultSet rs = null;
        s.execute("insert into temp1 values 'x','a','c','b','a'");
        s.execute("insert into temp2b(s) select s from temp1 order by s     offset 1 rows fetch next 4 rows only");
        JDBC.assertFullResultSet(s.executeQuery("select * from temp2b"), new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}});
        s.execute("insert into temp2b(s) select s as a1 from temp1 order by a1    offset 1 rows fetch next 4 rows only");
        s.execute("insert into temp2b(s) select * from temp1 order by s     offset 1 rows fetch next 4 rows only");
        rs = s.executeQuery("select * from temp2b");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}, {"5", "a"}, {"6", "b"}, {"7", "c"}, {"8", "x"}, {"9", "a"}, {"10", "b"}, {"11", "c"}, {"12", "x"}});
        rs = s.executeQuery("select * from temp2b order by i");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}, {"5", "a"}, {"6", "b"}, {"7", "c"}, {"8", "x"}, {"9", "a"}, {"10", "b"}, {"11", "c"}, {"12", "x"}});
        s.execute("insert into t01 values (50), (10), (1000), (15), (51)");
        rs = s.executeQuery("select * from t01");
        JDBC.assertFullResultSet(rs, new String[][]{{"50"}, {"10"}, {"1000"}, {"15"}, {"51"}});
        s.execute("insert into t02 select * from t01 order by c1     fetch first 2 rows only");
        s.execute("insert into t02 select * from t01");
        s.execute("insert into t02 select * from t01 order by c1 offset 0 rows");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"10"}, {"15"}, {"50"}, {"10"}, {"1000"}, {"15"}, {"51"}, {"10"}, {"15"}, {"50"}, {"51"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, s, "insert into t02 values 66 offset 1 row");
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 select 900 from sys.systables                 union values 66 order by 1 offset 1 row");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"900"}});
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 values 66        union select 900 from sys.systables fetch next 1 row only");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"66"}});
        s.executeUpdate("delete from t02");
        s.executeUpdate("insert into t02 select * from (values 3,4,5 )v     order by 1 offset 1 row fetch next 2 rows only");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"4"}, {"5"}});
        s.execute("delete from t02");
        s.execute("insert into t02 select * from t01 union all                 select * from t01 order by c1                 fetch next 4 rows only");
        rs = s.executeQuery("select * from t02");
        JDBC.assertFullResultSet(rs, new String[][]{{"10"}, {"10"}, {"15"}, {"15"}});
        s.execute("delete from t01");
        s.execute("insert into t02 values 6,7");
        s.execute("insert into t01 select * from t02 except                 values 10 order by 1 offset 1 row");
        rs = s.executeQuery("select * from t01");
        JDBC.assertFullResultSet(rs, new String[][]{{"7"}, {"15"}});
        s.execute("delete from t02");
        s.execute("insert into t_source     values (1, 'one'), (2, 'two'), (8, 'three')");
        s.execute("insert into t_source(c1)     select c1 from t_source order by c2 desc     fetch next 2 rows only");
        rs = s.executeQuery("select * from t_source");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "one"}, {"2", "two"}, {"8", "three"}, {"2", null}, {"8", null}});
        this.rollback();
    }

    public void testSelectSubqueriesOrderBy() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        ResultSet rs = s.executeQuery("select * from (select c1 from t_source order by c1 desc) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}, {"2"}, {"1"}});
        rs = s.executeQuery("select * from (select c1+1 from t_source order by c1+1 desc) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"9"}, {"3"}, {"2"}});
        rs = s.executeQuery("select * from (select c1,c2 from t_source order by c1 desc,2) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"8", "three"}, {"2", "two"}, {"1", "one"}});
        rs = s.executeQuery("select * from (select c2 from t_source order by c1 desc) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"three"}, {"two"}, {"one"}});
        rs = s.executeQuery("select * from     (select c2 from t_source order by c1 desc) s order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"one"}, {"three"}, {"two"}});
        rs = s.executeQuery("select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 1 desc) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"8", "three"}, {"2", "two"}, {"1", "one"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc) order by 1 desc");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}, {"2"}, {"1"}});
        rs = s.executeQuery("select c1 from t_source where not exists     (select c1 from t_source order by c2 desc) order by 1 desc");
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select c1 from t_source ot where not exists    (select c1 from t_source where ot.c1=(c1/2) order by c2 desc)    order by 1 desc");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}, {"2"}});
        s.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by 1 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by i/5 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by j)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        String[][] expected = new String[][]{{"1", "10", "1"}, {"2", "40", "1"}};
        rs = s.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t) - 5)");
        JDBC.assertFullResultSet(rs, expected);
        rs = s.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t order by 1) - 5     order by 1 desc)");
        JDBC.assertFullResultSet(rs, expected);
        this.rollback();
    }

    public void testSelectSubqueriesOrderByAndOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        ResultSet rs = s.executeQuery("select * from (select c1 from t_source order by c1 desc                offset 1 row) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"2"}, {"1"}});
        rs = s.executeQuery("select * from (select c1+1 from t_source order by c1+1 desc                fetch first 2 rows only) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"9"}, {"3"}});
        rs = s.executeQuery("select * from (select c1,c2 from t_source order by c1 desc,2                offset 2 rows fetch next 1 row only) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "one"}});
        rs = s.executeQuery("select * from (select c2 from t_source order by c1 desc                offset 2 rows) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"one"}});
        rs = s.executeQuery("select * from     (select c2 from t_source order by c1 desc      fetch first 2 row only) s order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"three"}, {"two"}});
        rs = s.executeQuery("select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 1 desc offset 1 row) s");
        JDBC.assertFullResultSet(rs, new String[][]{{"2", "two"}, {"1", "one"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 offset 1 row)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 offset 3 rows)");
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 desc      fetch first 1 row only)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source offset 1 row)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"8"}});
        rs = s.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc      offset 1 row fetch first 1 row only)   order by 1 desc offset 1 row fetch first 1 row only");
        JDBC.assertFullResultSet(rs, new String[][]{{"2"}});
        rs = s.executeQuery("select c1 from t_source where not exists     (select c1 from t_source order by c2 desc          offset 3 rows)     order by 1 desc");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}, {"2"}, {"1"}});
        rs = s.executeQuery("select c1 from t_source ot where not exists    (select c1 from t_source where ot.c1=(c1/2) order by c2 desc         offset 1 row)   order by 1 desc");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}, {"2"}, {"1"}});
        s.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by 1 desc                             offset 1 row)");
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by 1 asc                             offset 1 row)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by i/5 desc                             offset 1 row)");
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by i/5 asc                             offset 1 row)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by j                             offset 1 row)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}});
        rs = s.executeQuery("select * from t where i in (select i/5 from t order by j desc                             offset 1 row)");
        JDBC.assertEmpty(rs);
        String[][] expected = new String[][]{{"1", "10", "1"}, {"2", "40", "1"}};
        rs = s.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t) - 5)");
        JDBC.assertFullResultSet(rs, expected);
        rs = s.executeQuery("select * from t where i = (select count(*) from t order by 1                            offset 1 row)");
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + cast(null as int) +         - 5     order by 1 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}, {"2", "40", "1"}, {"3", "45", "1"}, {"4", "46", "1"}, {"5", "90", "1"}});
        rs = s.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t order by 1 offset 1 row) - 5     order by 1 desc)");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "10", "1"}, {"2", "40", "1"}, {"3", "45", "1"}, {"4", "46", "1"}, {"5", "90", "1"}});
        this.rollback();
    }

    public void testJoinsWithOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("insert into temp1 values 'x','a','c','b','a'");
        PreparedStatement ps = this.prepareStatement("select * from    (select s from temp1 order by s                         fetch first ? rows only) t1 join    (select s from temp1 order by s offset ? row                         fetch first ? row only) t2    on t1.s=t2.s");
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"a", "a"}, {"a", "a"}});
        ps.setInt(1, 1);
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"a", "a"}});
        this.rollback();
    }

    public void testView() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create view v1 as select i from t order by j desc");
        s.executeUpdate("create view v2 as select i from t order by i");
        s.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        ResultSet rs = s.executeQuery("select i from v1");
        JDBC.assertFullResultSet(rs, new String[][]{{"5"}, {"4"}, {"3"}, {"2"}, {"1"}});
        rs = s.executeQuery("select i from v2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        this.rollback();
    }

    public void testViewFetchOffset() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create view v1 as select i from t order by j desc                   offset 2 rows fetch first 1 row only");
        s.executeUpdate("create view v2 as select i from t order by i                   fetch next 2 rows only");
        s.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        ResultSet rs = s.executeQuery("select i from v1");
        JDBC.assertFullResultSet(rs, new String[][]{{"3"}});
        rs = s.executeQuery("select i from v2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}});
        this.rollback();
    }

    public void testSelectSubqueriesOrderByNegative() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, s, "select * from (select c1 from t_source order by c3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_OUT_OF_RANGE, s, "select * from (select c1 from t_source order by 3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_OUT_OF_RANGE, s, "select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, s, "select c1 from t_source where exists     (select c1 from t_source order by c4)");
        this.rollback();
    }

    public void testSelectSubqueriesSortAvoidance() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table ts(i int, j int)");
        PreparedStatement ps = this.prepareStatement("insert into ts values(?,?)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i * 2);
            ps.execute();
        }
        s.executeUpdate("create unique index t_i on ts(i)");
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery("select * from (select i from ts order by i)tt");
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndOffsetFetchInSubqueries.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TS", "T_I"));
        OrderByAndOffsetFetchInSubqueries.assertFalse((boolean)rtsp.whatSortingRequired());
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        this.rollback();
    }
}

