/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;
import org.apache.derby.impl.sql.catalog.SequenceUpdater;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.SGVetter;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequenceGeneratorTest
extends GeneratedColumnsHelper {
    private static final long ALLOCATION_COUNT = 5L;
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH"};
    private static boolean _fullDebug = false;

    public SequenceGeneratorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)TestConfiguration.embeddedSuite(SequenceGeneratorTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "sequenceGenerator");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_01_basic() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_01\n");
        SequenceGeneratorTest.assertEquals((long)initialValue, (long)this.getCurrentValue(TEST_DBO, "SEQ_01"));
        int seq_01_value = initialValue;
        long seq_01_upperBound = (long)seq_01_value + 5L;
        int i = 0;
        while ((long)i < 5L) {
            this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound);
            ++i;
        }
        this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound += 5L);
        this.goodStatement(conn, "create sequence seq_01_a\n");
        int seq_01_a_value = initialValue;
        long seq_01_a_upperBound = (long)seq_01_a_value + 5L;
        for (int i2 = 0; i2 < 2; ++i2) {
            this.vetBumping(conn, TEST_DBO, "SEQ_01_A", seq_01_a_value++, seq_01_a_upperBound);
        }
        seq_01_upperBound = (long)seq_01_value + 5L;
        this.vetBumping(conn, TEST_DBO, "SEQ_01", seq_01_value++, seq_01_upperBound);
    }

    private void vetBumping(Connection conn, String schemaName, String sequenceName, int expectedValue, long expectedValueOnDisk) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "values( next value for " + schemaName + '.' + sequenceName + " )\n");
        SequenceGeneratorTest.assertEquals((int)expectedValue, (int)this.getScalarInteger(ps));
        SequenceGeneratorTest.assertEquals((long)expectedValueOnDisk, (long)this.getCurrentValue(schemaName, sequenceName));
    }

    public void test_02_boundary() throws Exception {
        T_SequenceUpdater updater = new T_SequenceUpdater(new Long(Integer.MIN_VALUE), true, 1L, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        SequenceGeneratorTest.assertEquals((long)Integer.MIN_VALUE, (long)updater.getValueOnDisk());
        this.vetBumping(updater, Integer.MIN_VALUE, -2147483643L);
        this.vetBumping(updater, -2147483647L, -2147483643L);
        this.vetBumping(updater, -2147483646L, -2147483643L);
        this.vetBumping(updater, -2147483645L, -2147483643L);
        this.vetBumping(updater, -2147483644L, -2147483643L);
        this.vetBumping(updater, -2147483643L, -2147483638L);
        this.vetBoundaries(32767L, -32768L);
        this.vetBoundaries(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBoundaries(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBoundaries(16383L, -16384L);
        this.vetBoundaries(0x3FFFFFFFL, -1073741824L);
        this.vetBoundaries(0x3FFFFFFFFFFFFFFFL, -4611686018427387904L);
    }

    private void vetBoundaries(long maxValue, long minValue) throws Exception {
        long biggestStep = 10L;
        for (long i = 1L; i <= biggestStep; ++i) {
            this.vetUpperBoundary(maxValue, minValue, i);
            this.vetLowerBoundary(maxValue, minValue, i);
        }
    }

    private void vetUpperBoundary(long maxValue, long minValue, long stepSize) throws Exception {
        long initValue;
        long restartValue = minValue;
        long i = initValue = maxValue - 5L * stepSize;
        while (i > 0L && i <= maxValue) {
            long firstValue = i++;
            this.vetBoundaries(maxValue, minValue, stepSize, firstValue, restartValue);
        }
    }

    private void vetLowerBoundary(long maxValue, long minValue, long stepSize) throws Exception {
        long initValue;
        long restartValue = maxValue;
        long i = initValue = minValue + 5L * stepSize;
        while (i < 0L && i >= minValue) {
            long firstValue = i--;
            this.vetBoundaries(maxValue, minValue, -stepSize, firstValue, restartValue);
        }
    }

    private void vetBoundaries(long maxValue, long minValue, long stepSize, long firstValue, long restartValue) throws Exception {
        long bumps = 11L;
        this.vetBumping(firstValue, true, stepSize, maxValue, minValue, restartValue, bumps);
        this.vetBumping(firstValue, false, stepSize, maxValue, minValue, restartValue, bumps);
    }

    private void vetBumping(long firstValue, boolean canCycle, long stepSize, long maxValue, long minValue, long restartValue, long bumps) throws Exception {
        if (_fullDebug) {
            SequenceGeneratorTest.println("stepSize = " + stepSize + " and firstValue = " + firstValue + " and canCycle = " + canCycle);
        }
        SGVetter vetter = new SGVetter(new Long(firstValue), canCycle, stepSize, maxValue, minValue, restartValue, 5L);
        T_SequenceUpdater updater = new T_SequenceUpdater(new Long(firstValue), canCycle, stepSize, maxValue, minValue, restartValue);
        if (_fullDebug) {
            SequenceGeneratorTest.println("");
        }
        for (long i = 0L; i < bumps; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    private void vetBump(SGVetter vetter, T_SequenceUpdater updater) throws Exception {
        this.assertLongEquals(vetter.getUpperBound(), updater.getValueOnDisk());
        Long vetterValue = vetter.getNextValue();
        if (_fullDebug) {
            SequenceGeneratorTest.println("Expecting value = " + vetterValue + " and expecting ValueOnDisk = " + vetter.getUpperBound());
        }
        if (vetterValue != null) {
            long updaterValue = updater.getCurrentValueAndAdvance();
            SequenceGeneratorTest.assertEquals((long)vetterValue, (long)updaterValue);
        } else {
            try {
                updater.getCurrentValueAndAdvance();
                SequenceGeneratorTest.fail((String)"Expected to catch cycle exception.");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.assertLongEquals(vetter.getUpperBound(), updater.getValueOnDisk());
    }

    private void assertLongEquals(Long left, Long right) {
        if (left == null) {
            SequenceGeneratorTest.assertNull((Object)right);
        } else {
            SequenceGeneratorTest.assertNotNull((Object)right);
            SequenceGeneratorTest.assertEquals((long)left, (long)right);
        }
    }

    private void vetBumping(T_SequenceUpdater updater, long expectedValue, long expectedValueOnDisk) throws Exception {
        long actualValue = updater.getCurrentValueAndAdvance();
        long actualValueOnDisk = updater.getValueOnDisk();
        SequenceGeneratorTest.println("Expected value = " + expectedValue + " vs actual value = " + actualValue);
        SequenceGeneratorTest.println("    Expected value on disk = " + expectedValue + " vs actual value on disk = " + actualValueOnDisk);
        SequenceGeneratorTest.assertEquals((long)expectedValue, (long)actualValue);
        SequenceGeneratorTest.assertEquals((long)expectedValueOnDisk, (long)actualValueOnDisk);
    }

    public void test_03_nonCycling() throws Exception {
        this.vetNonCycling(32767L, -32768L);
        this.vetNonCycling(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetNonCycling(Long.MAX_VALUE, Long.MIN_VALUE);
    }

    private void vetNonCycling(long maxValue, long minValue) throws Exception {
        this.vetNonCycling(maxValue, minValue, 1L);
        this.vetNonCycling(maxValue, minValue, -1L);
    }

    private void vetNonCycling(long maxValue, long minValue, long stepSize) throws Exception {
        long restartValue;
        long firstValue;
        long bumps = 3L;
        if (stepSize > 0L) {
            firstValue = maxValue - bumps;
            restartValue = minValue;
        } else {
            firstValue = minValue + bumps;
            restartValue = maxValue;
        }
        SGVetter vetter = new SGVetter(new Long(firstValue), false, stepSize, maxValue, minValue, restartValue, 5L);
        T_SequenceUpdater updater = new T_SequenceUpdater(new Long(firstValue), false, stepSize, maxValue, minValue, restartValue);
        long extraBumps = bumps + 2L;
        for (long i = 0L; i <= extraBumps; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    public void test_04_reboot() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_04\n");
        int seq_04_value = initialValue;
        long seq_04_upperBound = (long)seq_04_value + 5L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.getTestConfiguration().shutdownDatabase();
        conn = this.openUserConnection(TEST_DBO);
        seq_04_value = (int)seq_04_upperBound;
        seq_04_upperBound = (long)seq_04_value + 5L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
        this.getTestConfiguration().shutdownDatabase();
        conn = this.openUserConnection(TEST_DBO);
        seq_04_value = (int)seq_04_upperBound;
        seq_04_upperBound = (long)seq_04_value + 5L;
        this.vetBumping(conn, TEST_DBO, "SEQ_04", seq_04_value++, seq_04_upperBound);
    }

    public void test_05_concurrency() throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        int initialValue = Integer.MIN_VALUE;
        this.goodStatement(conn, "create sequence seq_05\n");
        this.goodStatement(conn, "grant usage on sequence seq_05 to public\n");
        int seq_05_value = initialValue;
        long seq_05_upperBound = seq_05_value;
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        ruthConnection.setAutoCommit(false);
        aliceConnection.setAutoCommit(false);
        long loopCount = 10L;
        for (long i = 0L; i < loopCount; ++i) {
            Connection loopConn;
            Connection connection = loopConn = i % 2L == 0L ? ruthConnection : aliceConnection;
            if (i % 5L == 0L) {
                seq_05_upperBound += 5L;
            }
            this.vetBumping(loopConn, TEST_DBO, "SEQ_05", seq_05_value++, seq_05_upperBound);
        }
        ruthConnection.commit();
        aliceConnection.commit();
    }

    public void test_06_bigStepSize() throws Exception {
        long stepSize = 0x4CCCCCCCCCCCCCCBL;
        T_SequenceUpdater updater = new T_SequenceUpdater(new Long(Long.MIN_VALUE), true, stepSize, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        long nextValue = updater.getCurrentValueAndAdvance();
        long currentValueOnDisk = updater.getValueOnDisk();
        long rangeSize = currentValueOnDisk - nextValue;
        SequenceGeneratorTest.assertEquals((long)stepSize, (long)rangeSize);
        this.vetBigStep(32767L, -32768L);
        this.vetBigStep(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBigStep(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBigStep(5L, 0L);
    }

    private void vetBigStep(long maxValue, long minValue) throws Exception {
        Long firstValue = new Long(minValue);
        long restartValue = minValue;
        long stepSize = maxValue - 1L;
        boolean canCycle = true;
        long truncatedAllocationCount = 1L;
        SGVetter vetter = new SGVetter(firstValue, canCycle, stepSize, maxValue, minValue, restartValue, truncatedAllocationCount);
        T_SequenceUpdater updater = new T_SequenceUpdater(firstValue, canCycle, stepSize, maxValue, minValue, restartValue);
        for (long i = 0L; i < 5L; ++i) {
            this.vetBump(vetter, updater);
        }
    }

    public void test_07_dropSequence() throws Exception {
        int initialValue;
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create sequence seq_07\n");
        int seq_07_value = initialValue = Integer.MIN_VALUE;
        long seq_07_upperBound = (long)seq_07_value + 5L;
        int i = 0;
        while ((long)i < 5L) {
            this.vetBumping(conn, TEST_DBO, "SEQ_07", seq_07_value++, seq_07_upperBound);
            ++i;
        }
        this.goodStatement(conn, "values( next value for seq_07 )\n");
        this.goodStatement(conn, "drop sequence seq_07 restrict\n");
        this.expectCompilationError("42X94", "values ( next value for seq_07 )\n");
    }

    private long getCurrentValue(String schemaName, String sequenceName) throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        PreparedStatement ps = this.chattyPrepare(conn, "select currentvalue from sys.syssequences seq, sys.sysschemas s where s.schemaname = ? and seq.sequencename = ? and s.schemaid = seq.schemaid");
        ps.setString(1, schemaName);
        ps.setString(2, sequenceName);
        long retval = this.getScalarLong(ps);
        conn.commit();
        return retval;
    }

    private int getScalarInteger(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        int retval = rs.getInt(1);
        rs.close();
        ps.close();
        return retval;
    }

    private long getScalarLong(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        long retval = rs.getLong(1);
        rs.close();
        ps.close();
        return retval;
    }

    public static final class T_SequenceUpdater
    extends SequenceUpdater {
        private Long _valueOnDisk;

        public T_SequenceUpdater(Long currentValue, boolean canCycle, long increment, long maxValue, long minValue, long restartValue) {
            this._valueOnDisk = currentValue;
            this._sequenceGenerator = new SequenceGenerator(currentValue, canCycle, increment, maxValue, minValue, restartValue, "DUMMY_SEQUENCE");
        }

        public Long getValueOnDisk() {
            return this._valueOnDisk;
        }

        public long getCurrentValueAndAdvance() throws Exception {
            SQLLongint nextValue = new SQLLongint();
            this.getCurrentValueAndAdvance((NumberDataValue)nextValue);
            return nextValue.getLong();
        }

        protected SequenceGenerator createSequenceGenerator(TransactionController readOnlyTC) {
            return this._sequenceGenerator;
        }

        protected boolean updateCurrentValueOnDisk(TransactionController tc, Long oldValue, Long newValue, boolean wait) {
            this._valueOnDisk = newValue;
            return true;
        }

        public boolean updateCurrentValueOnDisk(Long oldValue, Long newValue) {
            return this.updateCurrentValueOnDisk(null, oldValue, newValue, false);
        }

        protected int getLockTimeout() {
            return 1000;
        }
    }
}

