/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobMemTest
extends BaseJDBCTestCase {
    private static final int LONG_BLOB_LENGTH = 18000000;
    private static final String LONG_BLOB_LENGTH_STRING = "18000000";
    private static final byte[] SHORT_BLOB_BYTES = new byte[]{1, 2, 3};

    public BlobMemTest(String name) {
        super(name);
    }

    private void testBlobLength(boolean lengthless, int extraLen) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int size;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE BLOBTAB (K INT CONSTRAINT PK PRIMARY KEY, B BLOB(18000000))");
        PreparedStatement ps = this.prepareStatement("INSERT INTO BLOBTAB VALUES(?,?)");
        ps.setInt(1, 1);
        int blobLen = 18000000 + extraLen;
        LoopingAlphabetStream stream = new LoopingAlphabetStream(blobLen);
        if (lengthless) {
            Method m = null;
            try {
                Class<?> c = ps.getClass();
                m = c.getMethod("setBinaryStream", Integer.TYPE, InputStream.class);
            }
            catch (NoSuchMethodException e) {
                BlobMemTest.println("Skipping lengthless insert because method is not available");
                return;
            }
            m.invoke((Object)ps, new Integer(2), stream);
        } else {
            ps.setBinaryStream(2, (InputStream)stream, blobLen);
        }
        if (extraLen != 0) {
            try {
                ps.executeUpdate();
                BlobMemTest.fail((String)"Expected truncation error for blob too large");
            }
            catch (SQLException sqlE) {
                BlobMemTest.assertSQLState("Wrong SQL State for truncation", "22001", sqlE);
            }
            return;
        }
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setBytes(2, new byte[0]);
        ps.executeUpdate();
        ps.setInt(1, 3);
        ps.setBytes(2, null);
        ps.executeUpdate();
        ps.setInt(1, 4);
        ps.setBytes(2, SHORT_BLOB_BYTES);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT K, LENGTH(B), B FROM BLOBTAB-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        rs.next();
        BlobMemTest.assertEquals((String)LONG_BLOB_LENGTH_STRING, (String)rs.getString(2));
        InputStream rsstream = rs.getBinaryStream(3);
        int len = 0;
        byte[] buf = new byte[32672];
        while ((size = rsstream.read(buf)) != -1) {
            int expectedValue = ((len += size) - 1) % 26 + 97;
            if (size == 0) continue;
            BlobMemTest.assertEquals((int)expectedValue, (int)buf[size - 1]);
        }
        BlobMemTest.assertEquals((int)18000000, (int)len);
        rs.next();
        BlobMemTest.assertEquals((String)"0", (String)rs.getString(2));
        byte[] bytes = rs.getBytes(3);
        BlobMemTest.assertEquals((int)0, (int)bytes.length);
        rs.next();
        BlobMemTest.assertEquals(null, (String)rs.getString(2));
        bytes = rs.getBytes(3);
        BlobMemTest.assertEquals(null, (Object)bytes);
        rs.next();
        BlobMemTest.assertEquals((String)"3", (String)rs.getString(2));
        bytes = rs.getBytes(3);
        BlobMemTest.assertTrue((boolean)Arrays.equals(SHORT_BLOB_BYTES, bytes));
        rs.close();
        rs = s.executeQuery("SELECT K, LENGTH(B)  FROM BLOBTAB ORDER BY K");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", LONG_BLOB_LENGTH_STRING}, {"2", "0"}, {"3", null}, {"4", "3"}});
    }

    public void testBlobLength() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 0);
    }

    public void testBlobLengthWithLengthlessInsert() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(true, 0);
    }

    public void testBlobLengthTooLongDerby961() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 10000);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(BlobMemTest.class);
        Properties p = new Properties();
        p.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup(suite, p);
    }

    public void testDerby4477_3645_3646_Repro_lowmem() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        int blobsize = 18000000;
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(" + blobsize + ") )");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        int blobLen = blobsize;
        LoopingAlphabetStream stream = new LoopingAlphabetStream(blobLen);
        ps.setBinaryStream(1, (InputStream)stream, blobLen);
        ps.executeUpdate();
        ps.close();
        s.executeUpdate("CREATE TABLE T_COPY ( V1 BLOB(" + blobsize + "), V2 BLOB(" + blobsize + "))");
        s.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet rs = s.executeQuery("SELECT * FROM T_COPY");
        rs.next();
        InputStream is = rs.getBinaryStream(1);
        stream.reset();
        BlobMemTest.assertEquals(stream, is);
        is = rs.getBinaryStream(2);
        stream.reset();
        BlobMemTest.assertEquals(stream, is);
        rs.close();
        rs = s.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        rs.next();
        is = rs.getBinaryStream(2);
        stream.reset();
        BlobMemTest.assertEquals(stream, is);
        is = rs.getBinaryStream(4);
        stream.reset();
        BlobMemTest.assertEquals(stream, is);
        stream.close();
        is.close();
        s.close();
        rs.close();
        this.rollback();
    }
}

