/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OfflineBackupTest
extends BaseJDBCTestCase {
    public OfflineBackupTest(String name) {
        super(name);
    }

    public void testCreateFromRestoreFrom() throws SQLException, IOException {
        this.getConnection();
        TestConfiguration.getCurrent().shutdownDatabase();
        File origdbloc = new File("system", "wombat");
        File backupdbloc = new File("system", "wombatbackup");
        PrivilegedFileOpsForTests.copy(origdbloc, backupdbloc);
        Connection connCreateFrom = DriverManager.getConnection("jdbc:derby:wombatCreateFrom;createFrom=system/wombatbackup");
        this.checkAllConsistency(connCreateFrom);
        try {
            DriverManager.getConnection("jdbc:derby:wombatCreateFrom;shutdown=true");
        }
        catch (SQLException se) {
            OfflineBackupTest.assertSQLState("Database shutdown", "08006", se);
        }
        Connection connRestoreFrom = DriverManager.getConnection("jdbc:derby:wombatRestoreFrom;restoreFrom=system/wombatbackup");
        this.checkAllConsistency(connRestoreFrom);
        try {
            DriverManager.getConnection("jdbc:derby:wombatRestoreFrom;shutdown=true");
        }
        catch (SQLException se) {
            OfflineBackupTest.assertSQLState("Database shutdown", "08006", se);
        }
        OfflineBackupTest.removeDirectory(backupdbloc);
        OfflineBackupTest.removeDirectory(new File("system", "wombatCreateFrom"));
        OfflineBackupTest.removeDirectory(new File("system", "wombatRestoreFrom"));
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("Empty OfflineBackupTest (uses DriverManager)");
        }
        return TestConfiguration.embeddedSuite(OfflineBackupTest.class);
    }
}

