/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_7
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String GRANT_REVOKE_WITH_LEGACY_ACCESS = "42Z60";

    public Changes10_7(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade test for 10.7");
        suite.addTestSuite(Changes10_7.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testBoolean() throws SQLException {
        String booleanValuedFunction = "create function f_4655( a varchar( 100 ) ) returns boolean\nlanguage java parameter style java no sql deterministic\nexternal name 'Z.getBooleanValue'\n";
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_7.assertFalse((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                Changes10_7.assertStatementError(SYNTAX_ERROR, s, booleanValuedFunction);
                break;
            }
            case 1: {
                Changes10_7.assertFalse((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                Changes10_7.assertStatementError(UPGRADE_REQUIRED, s, booleanValuedFunction);
                break;
            }
            case 3: {
                Changes10_7.assertTrue((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                s.execute(booleanValuedFunction);
            }
        }
        s.close();
    }

    private Set getSupportedTypes() throws SQLException {
        HashSet<String> types = new HashSet<String>();
        ResultSet rs = this.getConnection().getMetaData().getTypeInfo();
        while (rs.next()) {
            types.add(rs.getString("TYPE_NAME"));
        }
        rs.close();
        return types;
    }

    public void testAlterTableDropColumnAndTriggerAction() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_RESTRICT", "TAB1_SOFT_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_CASCADE", "TAB1_SOFT_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_RESTRICT", "TAB2_SOFT_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_CASCADE", "TAB2_SOFT_UPGRADE_CASCADE_TR1", false);
                this.createTableAndTrigger("TAB1_POSTSOFT_UPGRADE_RESTRICT", "TAB1_POSTSOFT_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_POSTSOFT_UPGRADE_CASCADE", "TAB1_POSTSOFT_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_POSTSOFT_UPGRADE_RESTRICT", "TAB2_POSTSOFT_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_POSTSOFT_UPGRADE_CASCADE", "TAB2_POSTSOFT_UPGRADE_CASCADE_TR1", false);
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_RESTRICT", "TAB1_HARD_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_CASCADE", "TAB1_HARD_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_RESTRICT", "TAB2_HARD_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_CASCADE", "TAB2_HARD_UPGRADE_CASCADE_TR1", false);
                break;
            }
            case 1: {
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB1_SOFT_UPGRADE_RESTRICT  drop column c11 restrict");
                ResultSet rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB1_SOFT_UPGRADE_RESTRICT_TR1"}});
                s.executeUpdate("alter table TAB1_SOFT_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_CASCADE_TR1'"));
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB2_SOFT_UPGRADE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB2_SOFT_UPGRADE_RESTRICT_TR1"}});
                s.executeUpdate("alter table TAB2_SOFT_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                s.executeUpdate("alter table TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                s.executeUpdate("alter table TAB2_soft_upgrade_NEW_TABLE_cascade  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                break;
            }
            case 2: {
                this.incorrectBehaviorForDropColumn("TAB1_POSTSOFT_UPGRADE_RESTRICT", "TAB1_POSTSOFT_UPGRADE_RESTRICT_TR1", "RESTRICT");
                this.incorrectBehaviorForDropColumn("TAB1_POSTSOFT_UPGRADE_CASCADE", "TAB1_POSTSOFT_UPGRADE_CASCADE_TR1", "CASCADE");
                this.incorrectBehaviorForDropColumn("TAB2_POSTSOFT_UPGRADE_RESTRICT", "TAB2_POSTSOFT_UPGRADE_RESTRICT_TR1", "RESTRICT");
                this.incorrectBehaviorForDropColumn("TAB2_POSTSOFT_UPGRADE_CASCADE", "TAB2_POSTSOFT_UPGRADE_CASCADE_TR1", "CASCADE");
                this.createTableAndTrigger("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                this.incorrectBehaviorForDropColumn("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                this.incorrectBehaviorForDropColumn("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                this.incorrectBehaviorForDropColumn("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                this.incorrectBehaviorForDropColumn("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", "RESTRICT");
                break;
            }
            case 3: {
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB1_HARD_UPGRADE_RESTRICT  drop column c11 restrict");
                ResultSet rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB1_HARD_UPGRADE_RESTRICT_TR1"}});
                s.executeUpdate("alter table TAB1_HARD_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_CASCADE_TR1'"));
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB2_HARD_UPGRADE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB2_HARD_UPGRADE_RESTRICT_TR1"}});
                s.executeUpdate("alter table TAB2_HARD_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE", "TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                s.executeUpdate("alter table TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                Changes10_7.assertStatementError("X0Y25", s, " alter table TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                rs = s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(rs, new String[][]{{"TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE", "TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                s.executeUpdate("alter table TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(s, "01502");
                JDBC.assertEmpty(s.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
            }
        }
    }

    private void createTableAndTrigger(String tableName, String triggerName, boolean usesReferencingClause) throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE " + tableName + " (c11 int, c12 int) ");
        s.execute("INSERT INTO " + tableName + " VALUES (1,10)");
        s.execute("CREATE TRIGGER " + triggerName + " AFTER UPDATE OF c12 ON " + tableName + (usesReferencingClause ? " REFERENCING OLD AS oldt" : "") + " FOR EACH ROW SELECT " + (usesReferencingClause ? "oldt.c11 " : "c11 ") + "FROM " + tableName);
        s.executeUpdate("UPDATE " + tableName + " SET c12=c12+1");
    }

    private void incorrectBehaviorForDropColumn(String tableName, String triggerName, String restrictOrCascade) throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN c11 " + restrictOrCascade);
        ResultSet rs = s.executeQuery(" select triggername from sys.systriggers where triggername='" + triggerName + "'");
        JDBC.assertFullResultSet(rs, new String[][]{{triggerName}});
    }

    private void checkWarning(Statement st, String expectedWarning) throws Exception {
        SQLWarning sqlWarn = null;
        sqlWarn = st.getWarnings();
        if (sqlWarn == null) {
            sqlWarn = this.getConnection().getWarnings();
        }
        Changes10_7.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
        Changes10_7.assertSQLState(expectedWarning, sqlWarn);
    }

    public void testTriggers() throws SQLException {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                s.execute("CREATE TABLE DERBY1482_table1(c11 int, c12 int)");
                s.execute("INSERT INTO DERBY1482_table1 VALUES (1,10)");
                s.execute("CREATE TABLE DERBY1482_table2(c21 int, c22 int)");
                s.execute("CREATE TABLE DERBY1482_table3(c31 int, c32 int)");
                s.execute("CREATE TABLE DERBY1482_table4(c41 int, c42 int)");
                s.execute("CREATE TABLE DERBY1482_table5(c51 int, c52 int)");
                s.execute("CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table2 VALUES(-1, oldt.c12)");
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
                break;
            }
            case 1: {
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"2"}});
                s.execute("CREATE TRIGGER tr2 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table3 VALUES(-1, oldt.c12)");
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"3"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
                break;
            }
            case 2: {
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"4"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(rs, new String[][]{{"2"}});
                s.execute("CREATE TRIGGER tr3 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table4 VALUES(-1, oldt.c12)");
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"5"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(rs, new String[][]{{"3"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
                break;
            }
            case 3: {
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"6"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(rs, new String[][]{{"4"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(rs, new String[][]{{"2"}});
                s.execute("CREATE TRIGGER tr4 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table5 VALUES(-1, oldt.c12)");
                s.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(rs, new String[][]{{"7"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(rs, new String[][]{{"5"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(rs, new String[][]{{"3"}});
                rs = s.executeQuery("SELECT COUNT(*) FROM DERBY1482_table5");
                JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
            }
        }
        s.close();
    }

    public void testExternalSecuritySpecification() throws SQLException {
        String functionWithDefinersRights = "create function f_4551( a varchar( 100 ) ) returns int\nlanguage java parameter style java reads sql data\nexternal security definer\nexternal name 'Z.getIntValue'\n";
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_7.assertStatementError(SYNTAX_ERROR, s, functionWithDefinersRights);
                break;
            }
            case 1: {
                Changes10_7.assertStatementError(UPGRADE_REQUIRED, s, functionWithDefinersRights);
                break;
            }
            case 3: {
                Changes10_7.assertStatementError(GRANT_REVOKE_WITH_LEGACY_ACCESS, s, functionWithDefinersRights);
            }
        }
        s.close();
    }
}

