/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public class PrivilegedFileOpsForTests {
    public static long length(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.length());
            }
        });
    }

    public static String getAbsolutePath(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                return file.getAbsolutePath();
            }
        });
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
    }

    public static boolean exists(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists();
            }
        });
    }

    public static boolean delete(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.delete();
            }
        });
    }

    public static FileReader getFileReader(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (FileReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileReader(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getCause();
        }
    }

    public static FileWriter getFileWriter(final File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (FileWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    public static void copy(final File source, final File target) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    PrivilegedFileOpsForTests.recursiveCopy(source, target);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private static void recursiveCopy(File source, File target) throws IOException {
        byte[] buf = new byte[32768];
        if (source.isFile()) {
            PrivilegedFileOpsForTests.copySingleFile(source, target, buf);
            return;
        }
        String[] list = source.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(source, list[i]);
                File targetEntry = new File(target, list[i]);
                if (entry.isDirectory()) {
                    PrivilegedFileOpsForTests.copy(entry, targetEntry);
                    continue;
                }
                PrivilegedFileOpsForTests.copySingleFile(entry, targetEntry, buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File source, File target, byte[] buf) throws IOException {
        File targetParent;
        if (buf == null) {
            buf = new byte[32768];
        }
        if ((targetParent = target.getParentFile()) != null && !targetParent.exists()) {
            target.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            int read;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return PrivilegedFileOpsForTests.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getCause();
        }
    }

    public static File[] persistentRecursiveDelete(final File dir) throws FileNotFoundException {
        if (!PrivilegedFileOpsForTests.exists(dir)) {
            throw new FileNotFoundException(PrivilegedFileOpsForTests.getAbsolutePath(dir));
        }
        final ArrayList notDeleted = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PrivilegedFileOpsForTests.deleteRecursively(dir, notDeleted);
            }
        });
        File[] failedDeletes = new File[notDeleted.size()];
        notDeleted.toArray(failedDeletes);
        return failedDeletes;
    }

    private static boolean deleteRecursively(File dir, List failedDeletes) {
        File[] files;
        boolean allDeleted = true;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    allDeleted &= PrivilegedFileOpsForTests.deleteRecursively(f, failedDeletes);
                    continue;
                }
                allDeleted &= PrivilegedFileOpsForTests.internalDelete(f, failedDeletes);
            }
        }
        return allDeleted &= PrivilegedFileOpsForTests.internalDelete(dir, failedDeletes);
    }

    private static boolean internalDelete(File f, List failedDeletes) {
        boolean deleted = f.delete();
        if (!deleted) {
            failedDeletes.add(f);
        }
        return deleted;
    }

    public static String getFileInfo(final File f) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!f.exists()) {
                    return "(non-existant)";
                }
                StringBuffer sb = new StringBuffer();
                sb.append("(isDir=").append(f.isDirectory()).append(", canRead=").append(f.canRead()).append(", canWrite=").append(f.canWrite()).append(", size=").append(f.length()).append(')');
                return sb.toString();
            }
        });
    }
}

