/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.CanonTestCase;
import org.apache.derbyTesting.junit.Derby;

public abstract class ScriptTestCase
extends CanonTestCase {
    private final String inputEncoding;
    private final String user;
    private boolean useSystemProperties = false;
    private Locale oldLocale;

    public ScriptTestCase(String script, boolean useSystemProperties) {
        this(script, null, null, null);
        this.useSystemProperties = useSystemProperties;
    }

    public ScriptTestCase(String script) {
        this(script, null, null, null);
    }

    public ScriptTestCase(String script, String encoding) {
        this(script, encoding, encoding, null);
    }

    public ScriptTestCase(String script, String inputEnc, String outputEnc, String user) {
        super(script, outputEnc);
        this.inputEncoding = inputEnc == null ? "US-ASCII" : inputEnc;
        this.user = user;
    }

    protected String getArea() {
        String name = ((Object)((Object)this)).getClass().getName();
        int lastDot = name.lastIndexOf(46);
        name = name.substring(0, lastDot);
        lastDot = name.lastIndexOf(46);
        return name.substring(lastDot + 1);
    }

    public static Test getIJConfig(Test test) {
        if (!Derby.hasTools()) {
            return new TestSuite("empty: no tools support");
        }
        return test;
    }

    public void runTest() throws Throwable {
        String outputEnc;
        String resource = "org/apache/derbyTesting/functionTests/tests/" + this.getArea() + "/" + this.getName() + ".sql";
        String canon = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        URL sql = ScriptTestCase.getTestResource(resource);
        ScriptTestCase.assertNotNull((String)("SQL script missing: " + resource), (Object)sql);
        InputStream sqlIn = ScriptTestCase.openTestResource(sql);
        Connection conn = this.user != null ? this.openUserConnection(this.user) : this.getConnection();
        String derby_ui_codeset = ScriptTestCase.getSystemProperty("derby.ui.codeset");
        if (derby_ui_codeset != null) {
            outputEnc = null;
            ScriptTestCase.assertEquals((String)"Requested output encoding and derby.ui.codeset differ", (String)this.outputEncoding, (String)derby_ui_codeset);
        } else {
            outputEnc = this.outputEncoding;
        }
        ij.runScript((Connection)conn, (InputStream)sqlIn, (String)this.inputEncoding, (OutputStream)this.getOutputStream(), (String)outputEnc, (boolean)this.useSystemProperties);
        if (!conn.isClosed() && !conn.getAutoCommit()) {
            conn.commit();
        }
        sqlIn.close();
        this.compareCanon(canon);
    }

    protected void setUp() {
        this.oldLocale = Locale.getDefault();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Locale.setDefault(Locale.US);
                return null;
            }
        });
        LocalizedResource.resetLocalizedResourceCache();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Locale.setDefault(ScriptTestCase.this.oldLocale);
                return null;
            }
        });
        LocalizedResource.resetLocalizedResourceCache();
    }
}

