/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.Properties;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.ChangeConfigurationSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Decorator {
    private Decorator() {
    }

    public static Test encryptedDatabase(Test test) {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("no encryption support");
        }
        Properties attributes = new Properties();
        attributes.setProperty("dataEncryption", "true");
        attributes.setProperty("bootPassword", Decorator.getBootPhrase(16));
        return Decorator.attributesDatabase(attributes, test);
    }

    public static Test encryptedDatabase(Test test, String algorithm) {
        Properties attributes = new Properties();
        attributes.setProperty("dataEncryption", "true");
        attributes.setProperty("bootPassword", Decorator.getBootPhrase(64));
        attributes.setProperty("encryptionAlgorithm", algorithm);
        return Decorator.attributesDatabase(attributes, test);
    }

    private static String getBootPhrase(int length) {
        Random rand = new Random();
        char[] bp = new char[length];
        int i = 0;
        while (i < bp.length) {
            char c = (char)rand.nextInt();
            if (!Character.isLetterOrDigit(c)) continue;
            bp[i++] = c;
        }
        return new String(bp);
    }

    public static Test territoryCollatedDatabase(Test test, String locale) {
        Properties attributes = new Properties();
        attributes.setProperty("collation", "TERRITORY_BASED");
        if (locale != null) {
            attributes.setProperty("territory", locale);
        }
        return Decorator.attributesDatabase(attributes, test);
    }

    public static Test territoryCollatedCaseInsensitiveDatabase(Test test, String locale) {
        Properties attributes = new Properties();
        attributes.setProperty("collation", "TERRITORY_BASED:SECONDARY");
        if (locale != null) {
            attributes.setProperty("territory", locale);
        }
        return Decorator.attributesDatabase(attributes, test);
    }

    private static Test attributesDatabase(final Properties attributes, Test test) {
        test = new ChangeConfigurationSetup((Test)test){

            TestConfiguration getNewConfiguration(TestConfiguration old) {
                return old.addConnectionAttributes(attributes);
            }
        };
        return TestConfiguration.singleUseDatabaseDecorator(test);
    }
}

