/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;

public class ClobAccessTest
extends JDBCPerfTestCase {
    private static final boolean disableSmallClobs = Boolean.getBoolean("derby.tests.disableSmallClobs");
    private static final boolean disableLargeClobs = Boolean.getBoolean("derby.tests.disableLargeClobs");
    private static final boolean disableConcurrencyTest = Boolean.getBoolean("derby.tests.disableConcurrencyTest");
    private static final String runLargeClobTests = System.getProperty("derby.tests.runLargeClobTests", null);
    private static final int largeClobSizeMB = Integer.getInteger("derby.tests.largeClobSize", 15);
    private static final int MAX_BSIZE = 32676;

    public ClobAccessTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        int reps;
        int iters;
        TestSuite mainSuite = new TestSuite("ClobAccessTest suite");
        if (!disableSmallClobs) {
            iters = 50;
            reps = 1;
            ClobAccessTest.println("Adding small Clob tests.");
            TestSuite smallSuite = new TestSuite("Small Clob suite");
            smallSuite.addTest((Test)new ClobAccessTest("testFetchSmallClobs", iters, reps));
            smallSuite.addTest((Test)new ClobAccessTest("testFetchSmallClobsInaccurateLength", iters, reps));
            smallSuite.addTest((Test)new ClobAccessTest("testModifySmallClobs", iters, reps));
            mainSuite.addTest((Test)smallSuite);
        }
        if (!disableLargeClobs) {
            String[] specifiedTests;
            iters = 5;
            reps = 1;
            String[] tests = new String[]{"testFetchLargeClobs", "testFetchLargeClobsModified", "testFetchLargeClobWithStream", "testFetchLargeClobOneByOneCharBaseline", "testFetchLargeClobOneByOneCharModified", "testFetchLargeClobOneByOneChar", "testFetchLargeClobPieceByPiece", "testFetchLargeClobPieceByPieceModified", "testLargeClobGetLength", "testLargeClobGetLengthModified", "testLargeClobTruncateLengthMinusOne", "testFetchLargeClobPieceByPieceBackwards"};
            if (runLargeClobTests != null && (specifiedTests = runLargeClobTests.split(",")).length > 0) {
                tests = specifiedTests;
            }
            ClobAccessTest.println("Adding " + tests.length + " large Clob tests.");
            TestSuite largeSuite = new TestSuite("Large Clob suite");
            for (int i = 0; i < tests.length; ++i) {
                largeSuite.addTest((Test)new ClobAccessTest(tests[i], iters, reps));
            }
            mainSuite.addTest((Test)largeSuite);
        }
        if (!disableConcurrencyTest) {
            mainSuite.addTest((Test)new ClobAccessTest("testConcurrency", 1, 1));
        }
        return new CleanDatabaseTestSetup((Test)mainSuite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                ClobAccessTest.initializeClobData(stmt);
            }
        };
    }

    public void testFetchSmallClobs() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int clobLength = rs.getInt(2);
            String content = clob.getSubString(1L, clobLength);
        }
        rs.close();
    }

    public void testFetchSmallClobsInaccurateLength() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int unusedLength = rs.getInt(2);
            String content = clob.getSubString(1L, 100);
        }
        rs.close();
    }

    public void testModifySmallClobs() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int length = rs.getInt(2);
            clob.setString(length, "X");
            String content = clob.getSubString(1L, 100);
        }
        rs.close();
    }

    public void testFetchLargeClobs() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs");
        ResultSet rs = ps.executeQuery();
        char[] charBuf = new char[16384];
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            Reader content = clob.getCharacterStream();
            for (long remaining = (long)rs.getInt(2); remaining > 0L; remaining -= (long)content.read(charBuf)) {
            }
            content.close();
        }
        rs.close();
    }

    public void testFetchLargeClobsModified() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs");
        ResultSet rs = ps.executeQuery();
        char[] charBuf = new char[16384];
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            clob.setString(1L, "X");
            Reader content = clob.getCharacterStream();
            for (long remaining = (long)rs.getInt(2); remaining > 0L; remaining -= (long)content.read(charBuf)) {
            }
            content.close();
        }
        rs.close();
    }

    public void testFetchLargeClobOneByOneCharBaseline() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            Reader content = clob.getCharacterStream();
            BufferedReader bufferedContent = new BufferedReader(content);
            long remaining = rs.getInt(2);
            while (bufferedContent.read() != -1) {
                --remaining;
            }
            content.close();
            ClobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeClobOneByOneChar() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            Reader content = clob.getCharacterStream();
            long remaining = rs.getInt(2);
            while (content.read() != -1) {
                --remaining;
            }
            content.close();
            ClobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeClobOneByOneCharModified() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            long remaining = rs.getInt(2);
            clob.setString(++remaining, "X");
            Reader content = clob.getCharacterStream();
            while (content.read() != -1) {
                --remaining;
            }
            content.close();
            ClobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeClobPieceByPieceBackwards() throws IOException, SQLException {
        boolean modifyClob = false;
        int intBufSize = 8192;
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int remaining = rs.getInt(2);
            if (modifyClob) {
                long modifyStart = System.currentTimeMillis();
                clob.setString(++remaining, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - modifyStart) + " ms");
            }
            int pieceSize = 10;
            long pos = remaining / 2 / 8192 * 8192 - 10;
            for (int i = 0; i < 8192; i += 10) {
                String str = clob.getSubString(pos - (long)i, 10);
            }
        }
        rs.close();
    }

    public void testFetchLargeClobPieceByPiece() throws IOException, SQLException {
        this.fetchPieceByPiece(false);
    }

    public void testFetchLargeClobPieceByPieceModified() throws IOException, SQLException {
        this.fetchPieceByPiece(true);
    }

    private void fetchPieceByPiece(boolean modifyClob) throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int remaining = rs.getInt(2);
            LoopingAlphabetReader myReader = new LoopingAlphabetReader(remaining);
            if (modifyClob) {
                long modifyStart = System.currentTimeMillis();
                clob.setString(++remaining, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - modifyStart) + " ms");
            }
            long pos = 1L;
            while (remaining > 0) {
                String str = clob.getSubString(pos, Math.min(32676, remaining));
                myReader.skip(Math.min(32676, remaining) - 1);
                pos += (long)str.length();
                if (modifyClob && (remaining -= str.length()) == 0) continue;
                ClobAccessTest.assertEquals((int)((Reader)myReader).read(), (int)str.charAt(str.length() - 1));
            }
        }
        rs.close();
    }

    public void testFetchLargeClobWithStream() throws IOException, SQLException {
        boolean modifyClob = false;
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 5");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int remaining = rs.getInt(2);
            LoopingAlphabetReader myReader = new LoopingAlphabetReader(remaining);
            if (modifyClob) {
                long modifyStart = System.currentTimeMillis();
                clob.setString(++remaining, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - modifyStart) + " ms");
            }
            Reader clobReader = clob.getCharacterStream();
            char[] buf = new char[32676];
            while (remaining > 0) {
                int read = clobReader.read(buf, 0, Math.min(32676, remaining));
                myReader.skip(read - 1);
                remaining -= read;
                ClobAccessTest.assertEquals((int)((Reader)myReader).read(), (int)buf[read - 1]);
            }
        }
        rs.close();
    }

    public void testLargeClobGetLength() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 7");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            long remaining = rs.getInt(2);
            for (int i = 0; i < 50; ++i) {
                ClobAccessTest.assertEquals((long)remaining, (long)clob.length());
            }
        }
        rs.close();
    }

    public void testLargeClobGetLengthModified() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 7");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            clob.setString(1L, "X");
            long remaining = rs.getInt(2);
            for (int i = 0; i < 50; ++i) {
                ClobAccessTest.assertEquals((long)remaining, (long)clob.length());
            }
        }
        rs.close();
    }

    public void testLargeClobTruncateLengthMinusOne() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob, length from largeClobs where id = 8");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int length = rs.getInt(2);
            clob.truncate(length - 1);
        }
    }

    public void testConcurrency() throws InterruptedException, SQLException {
        int records = 100000;
        boolean tables = true;
        int threads = 16;
        SingleRecordFiller filler = new SingleRecordFiller(100000, 1, 2005, false, false);
        Connection conn = this.getConnection();
        ClobAccessTest.println("initializing database...");
        filler.fill(conn);
        conn.close();
        Client[] clients = new Client[16];
        for (int i = 0; i < clients.length; ++i) {
            Connection c = this.openDefaultConnection();
            c.setTransactionIsolation(2);
            clients[i] = new SingleRecordSelectClient(100000, 1, 2005, false, false);
            clients[i].init(c);
        }
        int warmupSec = 30;
        int steadySec = 60;
        BackToBackLoadGenerator gen = new BackToBackLoadGenerator();
        gen.init(clients);
        ClobAccessTest.println("starting warmup...");
        gen.startWarmup();
        Thread.sleep(30000L);
        ClobAccessTest.println("entering steady state...");
        gen.startSteadyState();
        Thread.sleep(60000L);
        ClobAccessTest.println("stopping threads...");
        gen.stop();
        gen.printReport(System.out);
    }

    private static void initializeClobData(Statement stmt) throws SQLException {
        Connection con = stmt.getConnection();
        con.setAutoCommit(false);
        if (!disableSmallClobs) {
            ClobAccessTest.println("Generating small Clobs test data.");
            try {
                stmt.executeUpdate("drop table smallClobs");
            }
            catch (SQLException sqle) {
                ClobAccessTest.assertSQLState("42Y55", sqle);
            }
            stmt.executeUpdate("create table smallClobs (dClob clob, length int)");
            PreparedStatement smallClobInsert = con.prepareStatement("insert into smallClobs values (?,?)");
            for (int clobCounter = 1; clobCounter < 15001; ++clobCounter) {
                String content = Integer.toString(clobCounter);
                smallClobInsert.setString(1, content);
                smallClobInsert.setInt(2, content.length());
                smallClobInsert.executeUpdate();
                if (clobCounter % 1000 != 0) continue;
                con.commit();
            }
            con.commit();
        }
        if (!disableLargeClobs) {
            ClobAccessTest.println("Generating large Clobs test data.");
            try {
                stmt.executeUpdate("drop table largeClobs");
            }
            catch (SQLException sqle) {
                ClobAccessTest.assertSQLState("42Y55", sqle);
            }
            stmt.executeUpdate("create table largeClobs (id int unique not null, dClob clob, length int)");
            PreparedStatement largeClobInsert = con.prepareStatement("insert into largeClobs values (?,?,?)");
            int size = largeClobSizeMB * 1024 * 1024;
            for (int clobCounter = 1; clobCounter < 11; ++clobCounter) {
                largeClobInsert.setInt(1, clobCounter);
                largeClobInsert.setCharacterStream(2, (Reader)new LoopingAlphabetReader(size), size);
                largeClobInsert.setInt(3, size);
                largeClobInsert.executeUpdate();
                ClobAccessTest.println("Inserted large Clob #" + (clobCounter - 1));
            }
            con.commit();
        }
    }
}

